/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.replication.conflict;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;

public class OReplicationConflictException
extends OException {
    private static final String MESSAGE_REMOTE_VERSION = "remote=v";
    private static final String MESSAGE_LOCAL_VERSION = "local=v";
    private static final long serialVersionUID = 1L;
    private final ORID localRID;
    private final int localVersion;
    private final ORID remoteRID;
    private final int remoteVersion;

    public OReplicationConflictException(String message) {
        super(message);
        int beginPos = message.indexOf(35);
        int endPos = message.indexOf(32, beginPos);
        this.localRID = new ORecordId(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_LOCAL_VERSION, endPos) + MESSAGE_LOCAL_VERSION.length();
        endPos = message.indexOf(32, beginPos);
        this.localVersion = Integer.parseInt(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_REMOTE_VERSION, endPos) + MESSAGE_REMOTE_VERSION.length();
        endPos = message.indexOf(41, beginPos);
        this.remoteVersion = Integer.parseInt(message.substring(beginPos, endPos));
        this.remoteRID = null;
    }

    public OReplicationConflictException(String message, ORID iRID, int iDatabaseVersion, int iRecordVersion) {
        super(message);
        this.localRID = iRID;
        this.remoteRID = null;
        this.localVersion = iDatabaseVersion;
        this.remoteVersion = iRecordVersion;
    }

    public OReplicationConflictException(String message, ORID iOriginalRID, ORID iRemoteRID) {
        super(message);
        this.localRID = iOriginalRID;
        this.remoteRID = iRemoteRID;
        this.remoteVersion = 0;
        this.localVersion = 0;
    }

    public String getMessage() {
        StringBuilder buffer = new StringBuilder(super.getMessage());
        if (this.remoteRID != null) {
            buffer.append("local RID=");
            buffer.append(this.localRID);
            buffer.append(" remote RID=");
            buffer.append(this.remoteRID);
        } else {
            buffer.append(MESSAGE_LOCAL_VERSION);
            buffer.append(this.localVersion);
            buffer.append(" remote=v");
            buffer.append(this.remoteVersion);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    public int getLocalVersion() {
        return this.localVersion;
    }

    public int getRemoteVersion() {
        return this.remoteVersion;
    }

    public ORID getLocalRID() {
        return this.localRID;
    }

    public ORID getRemoteRID() {
        return this.remoteRID;
    }
}

