/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.tx.OTransactionEntryProxy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OTransactionOptimisticProxy
extends OTransactionOptimistic {
    private final Map<ORecordId, ORecord<?>> createdRecords = new HashMap();
    private final Map<ORecordId, ORecord<?>> updatedRecords = new HashMap();
    private final int clientTxId;
    private ODocument remoteIndexEntries = null;
    private final OChannelBinary channel;

    public OTransactionOptimisticProxy(ODatabaseRecordTx iDatabase, OChannelBinary iChannel) throws IOException {
        super(iDatabase);
        this.channel = iChannel;
        this.clientTxId = iChannel.readInt();
    }

    public void begin() {
        super.begin();
        try {
            this.setUsingLog(this.channel.readByte() == 1);
            byte lastTxStatus = this.channel.readByte();
            while (lastTxStatus == 1) {
                OTransactionEntryProxy entry;
                byte recordStatus = this.channel.readByte();
                ORecordId rid = this.channel.readRID();
                byte recordType = this.channel.readByte();
                switch (recordStatus) {
                    case 3: {
                        entry = new OTransactionEntryProxy(recordType);
                        entry.type = recordStatus;
                        entry.getRecord().fill(rid, 0, this.channel.readBytes(), true);
                        this.createdRecords.put(rid.copy(), (ORecord<?>)entry.getRecord());
                        break;
                    }
                    case 1: {
                        ORecordInternal currentRecord;
                        ORecordInternal newRecord = Orient.instance().getRecordFactoryManager().newInstance(recordType);
                        newRecord.fill(rid, this.channel.readInt(), this.channel.readBytes(), true);
                        if (newRecord.getRecordType() == 100) {
                            currentRecord = this.getDatabase().load((ORID)rid);
                            if (currentRecord == null) {
                                throw new ORecordNotFoundException(rid.toString());
                            }
                            if (currentRecord.getRecordType() == 100) {
                                ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
                            }
                        } else {
                            currentRecord = newRecord;
                        }
                        currentRecord.setVersion(newRecord.getVersion());
                        entry = new ORecordOperation((OIdentifiable)currentRecord, recordStatus);
                        this.updatedRecords.put(rid, (ORecord<?>)currentRecord);
                        break;
                    }
                    case 2: {
                        entry = new OTransactionEntryProxy(recordType);
                        entry.type = recordStatus;
                        entry.getRecord().fill(rid, this.channel.readInt(), null, false);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.recordEntries.put(entry.getRecord().getIdentity(), entry);
                lastTxStatus = this.channel.readByte();
            }
            if (lastTxStatus == -1) {
                throw new OTransactionException("Transaction aborted by the client");
            }
            this.remoteIndexEntries = new ODocument(this.channel.readBytes());
            for (ORecord<?> record : this.createdRecords.values()) {
                this.unmarshallRecord(record);
            }
            for (ORecord<?> record : this.updatedRecords.values()) {
                this.unmarshallRecord(record);
            }
        }
        catch (IOException e) {
            this.rollback();
            throw new OSerializationException("Cannot read transaction record from the network. Transaction aborted", (Throwable)e);
        }
    }

    public ORecordInternal<?> getRecord(ORID rid) {
        ORecordInternal record = super.getRecord(rid);
        if (record == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (record == null && rid.isNew()) {
            record = (ORecordInternal)this.createdRecords.get(rid);
        }
        return record;
    }

    public ODocument getIndexChanges() {
        return this.remoteIndexEntries.merge(super.getIndexChanges(), true, true);
    }

    public Map<ORecordId, ORecord<?>> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord<?>> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord<?> iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields();
            for (Map.Entry field : (ODocument)iRecord) {
                if (!(field.getValue() instanceof ORecordLazyList)) continue;
                ((ORecordLazyList)field.getValue()).lazyLoad(true);
            }
        }
    }
}

