/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel;

import com.orientechnologies.common.concur.resource.OSharedResourceExternalTimeout;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public abstract class OChannel
extends OSharedResourceExternalTimeout {
    public Socket socket;
    public InputStream inStream;
    public OutputStream outStream;
    public int socketBufferSize;

    public OChannel(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(OGlobalConfiguration.NETWORK_LOCK_TIMEOUT.getValueAsInteger());
        this.socket = iSocket;
        this.socketBufferSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_BUFFER_SIZE);
    }

    public void flush() throws IOException {
        this.outStream.flush();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outStream != null) {
                this.outStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.socket != null ? this.socket.getRemoteSocketAddress().toString() : "Not connected";
    }
}

