/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class OAsynchChannelServiceThread
extends OSoftThread {
    private OChannelBinaryClient network;
    private int sessionId = sessionIdSerial.getAndIncrement();
    private ORemoteServerEventListener remoteServerEventListener;
    private static AtomicInteger sessionIdSerial = new AtomicInteger(Integer.MIN_VALUE);

    public OAsynchChannelServiceThread(ORemoteServerEventListener iRemoteServerEventListener, OChannelBinaryClient iFirstChannel, String iThreadName) {
        super(Orient.getThreadGroup(), iThreadName);
        this.remoteServerEventListener = iRemoteServerEventListener;
        this.network = iFirstChannel;
        this.start();
    }

    protected void execute() throws Exception {
        try {
            this.network.beginResponse(this.sessionId);
            try {
                try {
                    byte request = this.network.readByte();
                    ORecordInternal obj = null;
                    switch (request) {
                        case 79: {
                            obj = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable(this.network);
                            break;
                        }
                        case 80: {
                            obj = new ODocument().fromStream(this.network.readBytes());
                        }
                    }
                    if (this.remoteServerEventListener != null) {
                        this.remoteServerEventListener.onRequest(request, obj);
                    }
                }
                catch (IOException ioe) {
                    this.sendShutdown();
                    this.network.close();
                    this.network = null;
                    if (this.network != null) {
                        this.network.endResponse();
                    }
                }
            }
            finally {
                if (this.network != null) {
                    this.network.endResponse();
                }
            }
        }
        catch (Exception e) {
            this.sendShutdown();
        }
    }
}

