/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OChannelBinary
extends OChannel {
    public DataInputStream in;
    public DataOutputStream out;
    private final int maxChunkSize;
    protected final boolean debug;
    private final byte[] buffer;

    public OChannelBinary(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
        this.maxChunkSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_BINARY_MAX_CONTENT_LENGTH);
        this.debug = iConfig.getValueAsBoolean(OGlobalConfiguration.NETWORK_BINARY_DEBUG);
        this.buffer = new byte[this.maxChunkSize];
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Connected", new Object[]{this.socket.getRemoteSocketAddress()});
        }
    }

    public byte readByte() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading byte (1 byte)...", new Object[]{this.socket.getRemoteSocketAddress()});
            byte value = this.in.readByte();
            OLogManager.instance().debug((Object)this, "%s - Read byte: %d", new Object[]{this.socket.getRemoteSocketAddress(), (int)value});
            return value;
        }
        return this.in.readByte();
    }

    public int readInt() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            int value = this.in.readInt();
            OLogManager.instance().debug((Object)this, "%s - Read int: %d", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading long (8 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            long value = this.in.readLong();
            OLogManager.instance().debug((Object)this, "%s - Read long: %d", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        return this.in.readLong();
    }

    public short readShort() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading short (2 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            short value = this.in.readShort();
            OLogManager.instance().debug((Object)this, "%s - Read short: %d", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        return this.in.readShort();
    }

    public String readString() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading string (4+N bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
            int len = this.in.readInt();
            if (len < 0) {
                return null;
            }
            byte[] tmp = new byte[len];
            this.in.readFully(tmp);
            String value = new String(tmp);
            OLogManager.instance().debug((Object)this, "%s - Read string: %s", new Object[]{this.socket.getRemoteSocketAddress(), value});
            return value;
        }
        int len = this.in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        return new String(tmp);
    }

    public byte[] readBytes() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading chunk of bytes. Reading chunk length as int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        int len = this.in.readInt();
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Read chunk lenght: %d", new Object[]{this.socket.getRemoteSocketAddress(), len});
        }
        if (len < 0) {
            return null;
        }
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading %d bytes...", new Object[]{this.socket.getRemoteSocketAddress(), len});
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Read %d bytes: %s", new Object[]{this.socket.getRemoteSocketAddress(), len, new String(tmp)});
        }
        return tmp;
    }

    public List<String> readStringList() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading string list. Reading string list items as int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        int items = this.in.readInt();
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Read string list items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items});
        }
        if (items < 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < items) {
            result.add(this.readString());
            ++i;
        }
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Read string list with %d items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items});
        }
        return result;
    }

    public Set<String> readStringSet() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Reading string set. Reading string set items as int (4 bytes)...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        int items = this.in.readInt();
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Read string set items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items});
        }
        if (items < 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < items) {
            result.add(this.readString());
            ++i;
        }
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Read string set with %d items: %d", new Object[]{this.socket.getRemoteSocketAddress(), items, result});
        }
        return result;
    }

    public ORecordId readRID() throws IOException {
        return new ORecordId(this.readShort(), this.readLong());
    }

    public OChannelBinary writeByte(byte iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing byte (1 byte): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.write(iContent);
        return this;
    }

    public OChannelBinary writeInt(int iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing int (4 bytes): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.writeInt(iContent);
        return this;
    }

    public OChannelBinary writeLong(long iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing long (8 bytes): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.writeLong(iContent);
        return this;
    }

    public OChannelBinary writeShort(short iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing short (2 bytes): %d", new Object[]{this.socket.getRemoteSocketAddress(), iContent});
        }
        this.out.writeShort(iContent);
        return this;
    }

    public OChannelBinary writeString(String iContent) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing string (4+%d=%d bytes): %s", new Object[]{this.socket.getRemoteSocketAddress(), iContent != null ? iContent.length() : 0, iContent != null ? iContent.length() + 4 : 4, iContent});
        }
        if (iContent == null) {
            this.out.writeInt(-1);
        } else {
            byte[] buffer = iContent.getBytes();
            this.out.writeInt(buffer.length);
            this.out.write(buffer, 0, buffer.length);
        }
        return this;
    }

    public OChannelBinary writeBytes(byte[] iContent) throws IOException {
        return this.writeBytes(iContent, iContent != null ? iContent.length : 0);
    }

    public OChannelBinary writeBytes(byte[] iContent, int iLength) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing bytes (4+%d=%d bytes): %s", new Object[]{this.socket.getRemoteSocketAddress(), iLength, iLength + 4, Arrays.toString(iContent)});
        }
        if (iContent == null) {
            this.out.writeInt(-1);
        } else {
            this.out.writeInt(iLength);
            this.out.write(iContent, 0, iLength);
        }
        return this;
    }

    public OChannelBinary writeCollectionString(Collection<String> iCollection) throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Writing strings (4+%d=%d items): %s", new Object[]{this.socket.getRemoteSocketAddress(), iCollection != null ? iCollection.size() : 0, iCollection != null ? iCollection.size() + 4 : 4, iCollection.toString()});
        }
        if (iCollection == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(iCollection.size());
            for (String s : iCollection) {
                this.writeString(s);
            }
        }
        return this;
    }

    public void writeRID(ORID iRID) throws IOException {
        this.writeShort((short)iRID.getClusterId());
        this.writeLong(iRID.getClusterPosition());
    }

    public void clearInput() throws IOException {
        if (this.in != null) {
            while (this.in.available() > 0) {
                this.in.read();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Flush", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        super.flush();
        this.out.flush();
    }

    @Override
    public void close() {
        if (this.debug) {
            OLogManager.instance().debug((Object)this, "%s - Closing socket...", new Object[]{this.socket.getRemoteSocketAddress()});
        }
        boolean lockAcquired = false;
        try {
            this.acquireExclusiveLock();
            lockAcquired = true;
        }
        catch (OTimeoutException oTimeoutException) {
            // empty catch block
        }
        try {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.close();
        }
        finally {
            if (lockAcquired) {
                this.releaseExclusiveLock();
            }
        }
    }

    public int readStatus() throws IOException {
        return this.handleStatus(this.readByte(), this.readInt());
    }

    protected int handleStatus(byte iResult, int iClientTxId) throws IOException {
        if (iResult != 0 && iResult != 3) {
            if (iResult == 1) {
                StringBuilder buffer = new StringBuilder();
                ArrayList<OPair> exceptions = new ArrayList<OPair>();
                while (this.readByte() == 1) {
                    String excClassName = this.readString();
                    String excMessage = this.readString();
                    exceptions.add(new OPair((Comparable)((Object)excClassName), (Object)excMessage));
                }
                RuntimeException previous = null;
                int i = exceptions.size() - 1;
                while (i > -1) {
                    previous = OChannelBinary.createException((String)((Object)((OPair)exceptions.get(i)).getKey()), (String)((OPair)exceptions.get(i)).getValue(), previous);
                    --i;
                }
                if (previous != null) {
                    if (previous instanceof RuntimeException) {
                        throw (RuntimeException)previous;
                    }
                    throw new ODatabaseException("Generic error, see the underlying cause", previous);
                }
                throw new ONetworkProtocolException("Network response error: " + buffer.toString());
            }
            throw new ONetworkProtocolException("Error on reading response from the server");
        }
        return iClientTxId;
    }

    private static RuntimeException createException(String iClassName, String iMessage, Exception iPrevious) {
        Object rootException = null;
        Constructor<?> c = null;
        try {
            Class<?> excClass = Class.forName(iClassName);
            if (iPrevious != null) {
                try {
                    c = excClass.getConstructor(String.class, Throwable.class);
                }
                catch (NoSuchMethodException e) {
                    c = excClass.getConstructor(String.class, Exception.class);
                }
            }
            if (c == null) {
                c = excClass.getConstructor(String.class);
            }
        }
        catch (Exception e) {
            rootException = new OStorageException(iMessage, iPrevious);
        }
        if (c != null) {
            try {
                e = c.getParameterTypes().length > 1 ? (Exception)c.newInstance(iMessage, iPrevious) : (Exception)c.newInstance(iMessage);
                rootException = e instanceof RuntimeException ? (RuntimeException)e : new OException((Throwable)e);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return rootException;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }
}

