/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class OChannelBinaryAsynch
extends OChannelBinary {
    private final ReentrantLock lockRead = new ReentrantLock();
    private final ReentrantLock lockWrite = new ReentrantLock();
    private boolean channelRead = false;
    private byte currentStatus;
    private int currentSessionId;
    private final int maxUnreadResponses = OGlobalConfiguration.NETWORK_BINARY_READ_RESPONSE_MAX_TIMES.getValueAsInteger();
    private static final int MAX_LENGTH_DEBUG = 100;

    public OChannelBinaryAsynch(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
    }

    public void beginRequest() {
        this.lockWrite.lock();
    }

    public void endRequest() throws IOException {
        this.flush();
        this.lockWrite.unlock();
    }

    public void beginResponse(int iRequesterId) throws IOException {
        this.beginResponse(iRequesterId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginResponse(int iRequesterId, long iTimeout) throws IOException {
        try {
            long startClock;
            int unreadResponse = 0;
            long l = startClock = iTimeout > 0L ? System.currentTimeMillis() : 0L;
            while (true) {
                if (iTimeout <= 0L) {
                    this.lockRead.lock();
                } else if (!this.lockRead.tryLock(iTimeout, TimeUnit.MILLISECONDS)) {
                    throw new OTimeoutException("Cannot acquire read lock against channel: " + (Object)((Object)this));
                }
                if (!this.channelRead) {
                    this.channelRead = true;
                    try {
                        this.currentStatus = this.readByte();
                        this.currentSessionId = this.readInt();
                        if (this.debug) {
                            OLogManager.instance().debug((Object)this, "%s - Read response: %d-%d", new Object[]{this.socket.getRemoteSocketAddress(), (int)this.currentStatus, this.currentSessionId});
                        }
                    }
                    catch (IOException e) {
                        this.lockRead.unlock();
                        this.channelRead = false;
                        throw e;
                    }
                }
                if (this.currentSessionId == iRequesterId) break;
                if (this.debug) {
                    OLogManager.instance().debug((Object)this, "%s - Session %d skip response, it is for %d", new Object[]{this.socket.getRemoteSocketAddress(), iRequesterId, this.currentSessionId});
                }
                if (iTimeout > 0L && System.currentTimeMillis() - startClock > iTimeout) {
                    throw new OTimeoutException("Timeout on reading response from the server for the request " + iRequesterId);
                }
                if (unreadResponse > this.maxUnreadResponses) {
                    StringBuilder dirtyBuffer = new StringBuilder();
                    int i = 0;
                    while (this.in.available() > 0) {
                        char c = (char)this.in.read();
                        ++i;
                        if (dirtyBuffer.length() >= 100) continue;
                        if (dirtyBuffer.length() > 0) {
                            dirtyBuffer.append('-');
                        }
                        dirtyBuffer.append(c);
                    }
                    OLogManager.instance().error((Object)this, "Received unread response from " + this.socket.getRemoteSocketAddress() + " for session=" + this.currentSessionId + ", probably corrupted data from the network connection. Cleared dirty data in the buffer (" + i + " bytes): [" + dirtyBuffer + (i > dirtyBuffer.length() ? "..." : "") + "]", OIOException.class);
                }
                this.lockRead.unlock();
                OChannelBinaryAsynch oChannelBinaryAsynch = this;
                synchronized (oChannelBinaryAsynch) {
                    try {
                        long start = System.currentTimeMillis();
                        ((Object)((Object)this)).wait(1000L);
                        if (System.currentTimeMillis() - start >= 1000L) {
                            ++unreadResponse;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (this.debug) {
                OLogManager.instance().debug((Object)this, "%s - Session %d handle response", new Object[]{this.socket.getRemoteSocketAddress(), iRequesterId});
            }
            this.handleStatus(this.currentStatus, this.currentSessionId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endResponse() {
        this.channelRead = false;
        this.lockRead.unlock();
        OChannelBinaryAsynch oChannelBinaryAsynch = this;
        synchronized (oChannelBinaryAsynch) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public ReentrantLock getLockRead() {
        return this.lockRead;
    }

    public ReentrantLock getLockWrite() {
        return this.lockWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        OChannelBinaryAsynch oChannelBinaryAsynch = this;
        synchronized (oChannelBinaryAsynch) {
            ((Object)((Object)this)).notifyAll();
        }
        super.close();
    }

    public void clearInput() throws IOException {
        this.lockRead.lock();
        try {
            super.clearInput();
        }
        finally {
            this.lockRead.unlock();
        }
    }
}

