/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.command;

import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.enterprise.command.OScriptDocumentDatabaseWrapper;
import com.orientechnologies.orient.enterprise.command.OScriptGraphDatabaseWrapper;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorScript
extends OCommandExecutorAbstract {
    protected static final String DEF_LANGUAGE = "javascript";
    protected static ScriptEngineManager scriptEngineManager;
    protected static Map<String, ScriptEngine> engines;
    protected static String defaultLanguage;
    protected OCommandScript request;

    static {
        defaultLanguage = DEF_LANGUAGE;
        if (engines == null) {
            engines = new HashMap<String, ScriptEngine>();
            scriptEngineManager = new ScriptEngineManager();
            for (ScriptEngineFactory f : scriptEngineManager.getEngineFactories()) {
                engines.put(f.getLanguageName().toLowerCase(), f.getScriptEngine());
                if (defaultLanguage != null) continue;
                defaultLanguage = f.getLanguageName();
            }
            if (!engines.containsKey(DEF_LANGUAGE)) {
                engines.put(DEF_LANGUAGE, scriptEngineManager.getEngineByName(DEF_LANGUAGE));
                defaultLanguage = DEF_LANGUAGE;
            }
        }
    }

    public OCommandExecutorScript parse(OCommandRequest iRequest) {
        this.request = (OCommandScript)iRequest;
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        String language = this.request.getLanguage();
        String script = this.request.getText();
        if (language == null) {
            throw new OCommandScriptException("No language was specified");
        }
        if (!engines.containsKey(language.toLowerCase())) {
            throw new OCommandScriptException("Unsupported language: " + language + ". Supported languages are: " + engines);
        }
        if (script == null) {
            throw new OCommandScriptException("Invalid script: null");
        }
        ScriptEngine scriptEngine = engines.get(language.toLowerCase());
        if (scriptEngine == null) {
            throw new OCommandScriptException("Cannot find script engine: " + language);
        }
        Bindings binding = scriptEngine.createBindings();
        binding.put("db", (Object)new OScriptDocumentDatabaseWrapper((ODatabaseRecordTx)OCommandExecutorScript.getDatabase()));
        binding.put("gdb", (Object)new OScriptGraphDatabaseWrapper((ODatabaseRecordTx)OCommandExecutorScript.getDatabase()));
        if (iArgs != null) {
            int i = 0;
            while (i < iArgs.size()) {
                binding.put("$" + i, iArgs.get(i));
                ++i;
            }
        }
        try {
            Object result = null;
            result = scriptEngine.eval(script, binding);
            return result;
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.request.getText(), 0, e);
        }
    }
}

