/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.command;

import com.orientechnologies.orient.core.db.ODataSegmentStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OScriptDocumentDatabaseWrapper {
    private ODatabaseDocumentTx database;

    public OScriptDocumentDatabaseWrapper(ODatabaseDocumentTx database) {
        this.database = database;
    }

    public OScriptDocumentDatabaseWrapper(ODatabaseRecordTx database) {
        this.database = new ODatabaseDocumentTx(database);
    }

    public OScriptDocumentDatabaseWrapper(String iURL) {
        this.database = new ODatabaseDocumentTx(iURL);
    }

    public List<OIdentifiable> query(String iText) {
        return this.database.query(new OSQLSynchQuery(iText), new Object[0]);
    }

    public Object command(String iText) {
        return this.database.command(new OCommandSQL(iText));
    }

    public boolean exists() {
        return this.database.exists();
    }

    public ODocument newInstance() {
        return this.database.newInstance();
    }

    public void reload() {
        this.database.reload();
    }

    public ODocument newInstance(String iClassName) {
        return this.database.newInstance(iClassName);
    }

    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.database.browseClass(iClassName);
    }

    public ODatabase.STATUS getStatus() {
        return this.database.getStatus();
    }

    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        return this.database.browseClass(iClassName, iPolymorphic);
    }

    public <THISDB extends ODatabase> THISDB setStatus(ODatabase.STATUS iStatus) {
        return this.database.setStatus(iStatus);
    }

    public void drop() {
        this.database.drop();
    }

    public String getName() {
        return this.database.getName();
    }

    public int addCluster(String iType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        return this.database.addCluster(iType, iClusterName, iLocation, iDataSegmentName, iParameters);
    }

    public String getURL() {
        return this.database.getURL();
    }

    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        return this.database.browseCluster(iClusterName);
    }

    public boolean isClosed() {
        return this.database.isClosed();
    }

    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        return this.database.open(iUserName, iUserPassword);
    }

    public ODocument save(ORecordInternal<?> iRecord) {
        return (ODocument)this.database.save(iRecord);
    }

    public boolean dropCluster(String iClusterName) {
        return this.database.dropCluster(iClusterName);
    }

    public <THISDB extends ODatabase> THISDB create() {
        return this.database.create();
    }

    public boolean dropCluster(int iClusterId) {
        return this.database.dropCluster(iClusterId);
    }

    public void close() {
        this.database.close();
    }

    public int getClusters() {
        return this.database.getClusters();
    }

    public Collection<String> getClusterNames() {
        return this.database.getClusterNames();
    }

    public int addDataSegment(String iName, String iLocation) {
        return this.database.addDataSegment(iName, iLocation);
    }

    public String getClusterType(String iClusterName) {
        return this.database.getClusterType(iClusterName);
    }

    public OTransaction getTransaction() {
        return this.database.getTransaction();
    }

    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.database.getDataSegmentIdByName(iDataSegmentName);
    }

    public ODatabaseComplex<ORecordInternal<?>> begin() {
        return this.database.begin();
    }

    public String getDataSegmentNameById(int iDataSegmentId) {
        return this.database.getDataSegmentNameById(iDataSegmentId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.database.getClusterIdByName(iClusterName);
    }

    public boolean isMVCC() {
        return this.database.isMVCC();
    }

    public String getClusterNameById(int iClusterId) {
        return this.database.getClusterNameById(iClusterId);
    }

    public <RET extends ODatabaseComplex<?>> RET setMVCC(boolean iValue) {
        return this.database.setMVCC(iValue);
    }

    public long getClusterRecordSizeById(int iClusterId) {
        return this.database.getClusterRecordSizeById(iClusterId);
    }

    public boolean isValidationEnabled() {
        return this.database.isValidationEnabled();
    }

    public long getClusterRecordSizeByName(String iClusterName) {
        return this.database.getClusterRecordSizeByName(iClusterName);
    }

    public <RET extends ODatabaseRecord> RET setValidationEnabled(boolean iValue) {
        return this.database.setValidationEnabled(iValue);
    }

    public OUser getUser() {
        return this.database.getUser();
    }

    public ODocument save(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return (ODocument)this.database.save(iRecord, iMode, iCallback);
    }

    public OMetadata getMetadata() {
        return this.database.getMetadata();
    }

    public ODictionary<ORecordInternal<?>> getDictionary() {
        return this.database.getDictionary();
    }

    public byte getRecordType() {
        return this.database.getRecordType();
    }

    public ODatabaseComplex<ORecordInternal<?>> delete(ORID iRid) {
        return this.database.delete(iRid);
    }

    public boolean dropDataSegment(String name) {
        return this.database.dropDataSegment(name);
    }

    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return (RET)this.database.load(iRecordId);
    }

    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)this.database.load(iRecordId, iFetchPlan);
    }

    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)this.database.load(iRecordId, iFetchPlan, iIgnoreCache);
    }

    public <RET extends ORecordInternal<?>> RET getRecord(OIdentifiable iIdentifiable) {
        return this.database.getRecord(iIdentifiable);
    }

    public int getDefaultClusterId() {
        return this.database.getDefaultClusterId();
    }

    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return this.database.load(iRecord);
    }

    public boolean declareIntent(OIntent iIntent) {
        return this.database.declareIntent(iIntent);
    }

    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.database.load(iRecord, iFetchPlan);
    }

    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.database.load(iRecord, iFetchPlan, iIgnoreCache);
    }

    public ODatabaseComplex<?> setDatabaseOwner(ODatabaseComplex<?> iOwner) {
        return this.database.setDatabaseOwner(iOwner);
    }

    public void reload(ORecordInternal<?> iRecord) {
        this.database.reload(iRecord);
    }

    public void reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        this.database.reload(iRecord, iFetchPlan, iIgnoreCache);
    }

    public Object setProperty(String iName, Object iValue) {
        return this.database.setProperty(iName, iValue);
    }

    public ODocument save(ORecordInternal<?> iRecord, String iClusterName) {
        return (ODocument)this.database.save(iRecord, iClusterName);
    }

    public Object getProperty(String iName) {
        return this.database.getProperty(iName);
    }

    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.database.getProperties();
    }

    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        return this.database.get(iAttribute);
    }

    public <THISDB extends ODatabase> THISDB set(ODatabase.ATTRIBUTES attribute, Object iValue) {
        return this.database.set(attribute, iValue);
    }

    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        this.database.setInternal(attribute, iValue);
    }

    public boolean isRetainRecords() {
        return this.database.isRetainRecords();
    }

    public ODatabaseRecord setRetainRecords(boolean iValue) {
        return this.database.setRetainRecords(iValue);
    }

    public long getSize() {
        return this.database.getSize();
    }

    public ORecordInternal<?> getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        return this.database.getRecordByUserObject(iUserObject, iCreateIfNotAvailable);
    }

    public ODocument save(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return (ODocument)this.database.save(iRecord, iClusterName, iMode, iCallback);
    }

    public ODataSegmentStrategy getDataSegmentStrategy() {
        return this.database.getDataSegmentStrategy();
    }

    public void setDataSegmentStrategy(ODataSegmentStrategy dataSegmentStrategy) {
        this.database.setDataSegmentStrategy(dataSegmentStrategy);
    }

    public ODatabaseDocumentTx delete(ODocument iRecord) {
        return this.database.delete(iRecord);
    }

    public long countClass(String iClassName) {
        return this.database.countClass(iClassName);
    }

    public ODatabaseComplex<ORecordInternal<?>> commit() {
        return this.database.commit();
    }

    public ODatabaseComplex<ORecordInternal<?>> rollback() {
        return this.database.rollback();
    }

    public String getType() {
        return this.database.getType();
    }
}

