/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OAlwaysGreaterKey;
import com.orientechnologies.common.collection.OAlwaysLessKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCompositeKey
implements Comparable<OCompositeKey>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Comparable<?>> keys;

    public OCompositeKey(List<? extends Comparable> keys) {
        this.keys = new ArrayList(keys.size());
        for (Comparable comparable : keys) {
            this.addKey(comparable);
        }
    }

    public OCompositeKey(Comparable ... keys) {
        this.keys = new ArrayList(keys.length);
        Comparable[] comparableArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Comparable key = comparableArray[n2];
            this.addKey(key);
            ++n2;
        }
    }

    public OCompositeKey() {
        this.keys = new ArrayList();
    }

    public List<Comparable<?>> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void addKey(Comparable key) {
        if (key instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)key;
            for (Comparable<?> inKey : compositeKey.keys) {
                this.addKey(inKey);
            }
        } else {
            this.keys.add(key);
        }
    }

    @Override
    public int compareTo(OCompositeKey otherKey) {
        Iterator<Comparable<?>> inIter = this.keys.iterator();
        Iterator<Comparable<?>> outIter = otherKey.keys.iterator();
        while (inIter.hasNext() && outIter.hasNext()) {
            Comparable<?> inKey = inIter.next();
            Comparable<?> outKey = outIter.next();
            if (outKey instanceof OAlwaysGreaterKey) {
                return -1;
            }
            if (outKey instanceof OAlwaysLessKey) {
                return 1;
            }
            int result = inKey.compareTo(outKey);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeKey that = (OCompositeKey)o;
        return this.keys.equals(that.keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public String toString() {
        return "OCompositeKey{keys=" + this.keys + '}';
    }
}

