/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OCompositeKey;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class OCompositeKeyTest {
    @Test
    public void testEqualSameKeys() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        compositeKey.addKey((Comparable)((Object)"b"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"a"));
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        Assert.assertTrue((boolean)compositeKey.equals(anotherCompositeKey));
        Assert.assertTrue((compositeKey.hashCode() == anotherCompositeKey.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualNotSameKeys() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        compositeKey.addKey((Comparable)((Object)"b"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"a"));
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        anotherCompositeKey.addKey((Comparable)((Object)"c"));
        Assert.assertFalse((boolean)compositeKey.equals(anotherCompositeKey));
    }

    @Test
    public void testEqualNull() {
        OCompositeKey compositeKey = new OCompositeKey();
        Assert.assertFalse((boolean)compositeKey.equals(null));
    }

    @Test
    public void testEqualSame() {
        OCompositeKey compositeKey = new OCompositeKey();
        Assert.assertTrue((boolean)compositeKey.equals(compositeKey));
    }

    @Test
    public void testEqualDiffClass() {
        OCompositeKey compositeKey = new OCompositeKey();
        Assert.assertFalse((boolean)compositeKey.equals("1"));
    }

    @Test
    public void testAddKeyComparable() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        Assert.assertEquals((int)compositeKey.getKeys().size(), (int)1);
        Assert.assertTrue((boolean)compositeKey.getKeys().contains("a"));
    }

    @Test
    public void testAddKeyComposite() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        OCompositeKey compositeKeyToAdd = new OCompositeKey();
        compositeKeyToAdd.addKey((Comparable)((Object)"a"));
        compositeKeyToAdd.addKey((Comparable)((Object)"b"));
        compositeKey.addKey(compositeKeyToAdd);
        Assert.assertEquals((int)compositeKey.getKeys().size(), (int)3);
        Assert.assertTrue((boolean)compositeKey.getKeys().contains("a"));
        Assert.assertTrue((boolean)compositeKey.getKeys().contains("b"));
    }

    @Test
    public void testCompareToSame() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        compositeKey.addKey((Comparable)((Object)"b"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"a"));
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        Assert.assertEquals((int)compositeKey.compareTo(anotherCompositeKey), (int)0);
    }

    @Test
    public void testCompareToPartiallyOneCase() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        compositeKey.addKey((Comparable)((Object)"b"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"a"));
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        anotherCompositeKey.addKey((Comparable)((Object)"c"));
        Assert.assertEquals((int)compositeKey.compareTo(anotherCompositeKey), (int)0);
    }

    @Test
    public void testCompareToPartiallySecondCase() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        compositeKey.addKey((Comparable)((Object)"b"));
        compositeKey.addKey((Comparable)((Object)"c"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"a"));
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        Assert.assertEquals((int)compositeKey.compareTo(anotherCompositeKey), (int)0);
    }

    @Test
    public void testCompareToGT() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"b"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"a"));
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        Assert.assertEquals((int)compositeKey.compareTo(anotherCompositeKey), (int)1);
    }

    @Test
    public void testCompareToLT() {
        OCompositeKey compositeKey = new OCompositeKey();
        compositeKey.addKey((Comparable)((Object)"a"));
        compositeKey.addKey((Comparable)((Object)"b"));
        OCompositeKey anotherCompositeKey = new OCompositeKey();
        anotherCompositeKey.addKey((Comparable)((Object)"b"));
        Assert.assertEquals((int)compositeKey.compareTo(anotherCompositeKey), (int)-1);
    }

    @Test
    public void testCompareToSymmetryOne() {
        OCompositeKey compositeKeyOne = new OCompositeKey();
        compositeKeyOne.addKey(Integer.valueOf(1));
        compositeKeyOne.addKey(Integer.valueOf(2));
        OCompositeKey compositeKeyTwo = new OCompositeKey();
        compositeKeyTwo.addKey(Integer.valueOf(1));
        compositeKeyTwo.addKey(Integer.valueOf(3));
        compositeKeyTwo.addKey(Integer.valueOf(1));
        Assert.assertEquals((int)compositeKeyOne.compareTo(compositeKeyTwo), (int)-1);
        Assert.assertEquals((int)compositeKeyTwo.compareTo(compositeKeyOne), (int)1);
    }

    @Test
    public void testCompareToSymmetryTwo() {
        OCompositeKey compositeKeyOne = new OCompositeKey();
        compositeKeyOne.addKey(Integer.valueOf(1));
        compositeKeyOne.addKey(Integer.valueOf(2));
        OCompositeKey compositeKeyTwo = new OCompositeKey();
        compositeKeyTwo.addKey(Integer.valueOf(1));
        compositeKeyTwo.addKey(Integer.valueOf(2));
        compositeKeyTwo.addKey(Integer.valueOf(3));
        Assert.assertEquals((int)compositeKeyOne.compareTo(compositeKeyTwo), (int)0);
        Assert.assertEquals((int)compositeKeyTwo.compareTo(compositeKeyOne), (int)0);
    }
}

