/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.DefaultConsoleReader;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.OArrays;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OConsoleApplication {
    protected InputStream in = System.in;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    protected char commandSeparator = (char)59;
    protected String wordSeparator = " ";
    protected String[] helpCommands = new String[]{"help", "?"};
    protected String[] exitCommands = new String[]{"exit", "bye", "quit"};
    protected Map<String, String> properties = new HashMap<String, String>();
    protected OConsoleReader reader = new DefaultConsoleReader();
    protected boolean interactiveMode;
    protected String[] args;
    protected static final String COMMENT_PREFIX = "#";

    public void setReader(OConsoleReader iReader) {
        this.reader = iReader;
        this.reader.setConsole(this);
    }

    public OConsoleApplication(String[] iArgs) {
        this.args = iArgs;
    }

    public void run() {
        this.interactiveMode = this.isInteractiveMode(this.args);
        this.onBefore();
        if (this.interactiveMode) {
            String consoleInput;
            do {
                this.out.println();
                this.out.print("orientdb> ");
            } while ((consoleInput = this.reader.readLine()) == null || consoleInput.length() == 0 || this.executeCommands(consoleInput));
        } else {
            this.executeBatch(this.getCommandLine(this.args));
        }
        this.onAfter();
    }

    protected boolean isInteractiveMode(String[] args) {
        return args.length == 0;
    }

    protected boolean executeBatch(String commandLine) {
        File commandFile = new File(commandLine);
        if (commandFile.exists()) {
            try {
                return this.executeCommands(new Scanner(commandFile).useDelimiter(";"));
            }
            catch (FileNotFoundException fnfe) {
                return false;
            }
        }
        return this.executeCommands(commandLine);
    }

    protected boolean executeCommands(String iCommands) {
        String[] commandLines = OStringParser.split(iCommands, this.commandSeparator, " \r\n");
        List<String> modifiedCommandLines = this.filterCommands(commandLines);
        for (String commandLine : modifiedCommandLines) {
            if (this.execute(commandLine)) continue;
            return false;
        }
        return true;
    }

    protected List<String> filterCommands(String[] commandLines) {
        return Arrays.asList(commandLines);
    }

    protected boolean executeCommands(Scanner iScanner) {
        while (iScanner.hasNext()) {
            String commandLine = iScanner.next();
            if (this.execute(commandLine)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean execute(String iCommand) {
        if ((iCommand = iCommand.trim()).length() == 0) {
            return true;
        }
        if (iCommand.startsWith("#")) {
            return true;
        }
        commandWords = OStringParser.getWords(iCommand, this.wordSeparator);
        var6_3 = this.helpCommands;
        var5_4 = this.helpCommands.length;
        var4_6 = 0;
        while (var4_6 < var5_4) {
            cmd = var6_3[var4_6];
            if (cmd.equals(commandWords[0])) {
                this.help();
                return true;
            }
            ++var4_6;
        }
        var6_3 = this.exitCommands;
        var5_4 = this.exitCommands.length;
        var4_6 = 0;
        while (var4_6 < var5_4) {
            cmd = var6_3[var4_6];
            if (cmd.equals(commandWords[0])) {
                return false;
            }
            ++var4_6;
        }
        lastMethodInvoked = null;
        lastCommandInvoked = new StringBuilder();
        commandLowerCase = iCommand.toLowerCase();
        block5: for (Method m : this.getConsoleMethods()) {
            methodName = m.getName();
            ann = m.getAnnotation(ConsoleCommand.class);
            commandName = new StringBuilder();
            commandWordCount = 1;
            i = 0;
            while (i < methodName.length()) {
                ch = methodName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    commandName.append(" ");
                    ch = Character.toLowerCase(ch);
                    ++commandWordCount;
                }
                commandName.append(ch);
                ++i;
            }
            if (!commandLowerCase.equals(commandName.toString()) && !commandLowerCase.startsWith(String.valueOf(commandName.toString()) + " ")) {
                if (ann == null || (aliases = ann.aliases()) == null || aliases.length == 0) continue;
                aliasMatch = false;
                var18_26 = aliases;
                var17_24 = aliases.length;
                var16_23 = 0;
                while (var16_23 < var17_24) {
                    alias = var18_26[var16_23];
                    if (iCommand.startsWith(alias.split(" ")[0])) {
                        aliasMatch = true;
                        commandWordCount = 1;
                        break;
                    }
                    ++var16_23;
                }
                if (!aliasMatch) continue;
            }
            if (ann != null && !ann.splitInWords()) {
                methodArgs = new String[]{iCommand.substring(iCommand.indexOf(32) + 1)};
            } else {
                if (m.getParameterTypes().length > commandWords.length - commandWordCount) {
                    paramNum = m.getParameterAnnotations().length - 1;
                    while (paramNum > -1) {
                        paramAnn = m.getParameterAnnotations()[paramNum];
                        if (paramAnn != null) {
                            annNum = paramAnn.length - 1;
                            while (annNum > -1) {
                                if (paramAnn[annNum] instanceof ConsoleParameter) {
                                    annotation = (ConsoleParameter)paramAnn[annNum];
                                    if (!annotation.optional()) break;
                                    commandWords = OArrays.copyOf(commandWords, commandWords.length + 1);
                                    break;
                                }
                                --annNum;
                            }
                        }
                        --paramNum;
                    }
                }
                methodArgs = OArrays.copyOfRange(commandWords, commandWordCount, commandWords.length);
            }
            try {
                m.invoke((Object)this, methodArgs);
            }
            catch (IllegalArgumentException e) {
                lastMethodInvoked = m;
                lastCommandInvoked.setLength(0);
                i = 0;
                ** while (i < commandWordCount)
            }
lbl-1000:
            // 1 sources

            {
                if (lastCommandInvoked.length() > 0) {
                    lastCommandInvoked.append(" ");
                }
                lastCommandInvoked.append(commandWords[i]);
                ++i;
                continue;
lbl96:
                // 1 sources

                continue block5;
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    this.onException(e.getCause());
                }
                e.printStackTrace();
            }
            return true;
        }
        if (lastMethodInvoked != null) {
            this.syntaxError(lastCommandInvoked.toString(), lastMethodInvoked);
        }
        this.out.println("!Unrecognized command: '" + iCommand + "'");
        return true;
    }

    protected void syntaxError(String iCommand, Method m) {
        this.out.print("!Wrong syntax. If you're using a file make sure all commands are delimited by ';'\n\r\n\r Expected: " + iCommand + " ");
        String paramName = null;
        String paramDescription = null;
        boolean paramOptional = false;
        StringBuilder buffer = new StringBuilder("\n\nWhere:\n\n");
        Annotation[][] annotationArray = m.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annotations;
            Annotation[] annotationArray2 = annotations = annotationArray[n2];
            int n3 = annotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation ann = annotationArray2[n4];
                if (ann instanceof ConsoleParameter) {
                    paramName = ((ConsoleParameter)ann).name();
                    paramDescription = ((ConsoleParameter)ann).description();
                    paramOptional = ((ConsoleParameter)ann).optional();
                    break;
                }
                ++n4;
            }
            if (paramName == null) {
                paramName = "?";
            }
            if (paramOptional) {
                this.out.print("[<" + paramName + ">] ");
            } else {
                this.out.print("<" + paramName + "> ");
            }
            buffer.append("* ");
            buffer.append(String.format("%-15s", paramName));
            if (paramDescription != null) {
                buffer.append(String.format("%-15s", paramDescription));
            }
            buffer.append("\n");
            ++n2;
        }
        this.out.println(buffer);
    }

    protected List<Method> getConsoleMethods() {
        Method[] methods = this.getClass().getMethods();
        ArrayList<Method> consoleMethods = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!Modifier.isAbstract(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getReturnType() == Void.TYPE) {
                Collections.sort(consoleMethods, new Comparator<Method>(){

                    @Override
                    public int compare(Method o1, Method o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                consoleMethods.add(m);
            }
            ++n2;
        }
        return consoleMethods;
    }

    protected Map<String, Object> addCommand(Map<String, Object> commandsTree, String commandLine) {
        return commandsTree;
    }

    protected void help() {
        this.out.println();
        this.out.println("AVAILABLE COMMANDS:");
        this.out.println();
        for (Method m : this.getConsoleMethods()) {
            ConsoleCommand annotation = m.getAnnotation(ConsoleCommand.class);
            if (annotation == null) continue;
            System.out.print(String.format("* %-70s%s\n", OConsoleApplication.getCorrectMethodName(m), annotation.description()));
        }
        System.out.print(String.format("* %-70s%s\n", OConsoleApplication.getClearName("help"), "Print this help"));
        System.out.print(String.format("* %-70s%s\n", OConsoleApplication.getClearName("exit"), "Close the console"));
    }

    public static String getCorrectMethodName(Method m) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OConsoleApplication.getClearName(m.getName()));
        int i = 0;
        while (i < m.getParameterAnnotations().length) {
            int j = 0;
            while (j < m.getParameterAnnotations()[i].length) {
                if (m.getParameterAnnotations()[i][j] instanceof ConsoleParameter) {
                    buffer.append(" <" + ((ConsoleParameter)m.getParameterAnnotations()[i][j]).name() + ">");
                }
                ++j;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getClearName(String iJavaName) {
        StringBuilder buffer = new StringBuilder();
        if (iJavaName != null) {
            buffer.append(iJavaName.charAt(0));
            int i = 1;
            while (i < iJavaName.length()) {
                char c = iJavaName.charAt(i);
                if (Character.isUpperCase(c)) {
                    buffer.append(' ');
                }
                buffer.append(Character.toLowerCase(c));
                ++i;
            }
        }
        return buffer.toString();
    }

    protected String getCommandLine(String[] iArguments) {
        StringBuilder command = new StringBuilder();
        int i = 0;
        while (i < iArguments.length) {
            if (i > 0) {
                command.append(" ");
            }
            command.append(iArguments[i]);
            ++i;
        }
        return command.toString();
    }

    protected void onBefore() {
    }

    protected void onAfter() {
    }

    protected void onException(Throwable throwable) {
        throwable.printStackTrace();
    }
}

