/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.io;

import java.io.File;
import java.util.Locale;

public class OFileUtils {
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int GIGABYTE = 0x40000000;
    private static final long TERABYTE = 0x10000000000L;

    public static long getSizeAsNumber(Object iSize) {
        if (iSize == null) {
            throw new IllegalArgumentException("Size is null");
        }
        if (iSize instanceof Number) {
            return ((Number)iSize).longValue();
        }
        String size = iSize.toString();
        boolean number = true;
        int i = size.length() - 1;
        while (i >= 0) {
            if (!Character.isDigit(size.charAt(i))) {
                number = false;
                break;
            }
            --i;
        }
        if (number) {
            return OFileUtils.string2number(size).longValue();
        }
        int pos = (size = size.toUpperCase(Locale.ENGLISH)).indexOf("KB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1024.0f);
        }
        pos = size.indexOf("MB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1048576.0f);
        }
        pos = size.indexOf("GB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1.0737418E9f);
        }
        pos = size.indexOf("TB");
        if (pos > -1) {
            return (long)(OFileUtils.string2number(size.substring(0, pos)).floatValue() * 1.0995116E12f);
        }
        pos = size.indexOf(66);
        if (pos > -1) {
            return (long)OFileUtils.string2number(size.substring(0, pos)).floatValue();
        }
        pos = size.indexOf(37);
        if (pos > -1) {
            return (long)(-1.0f * OFileUtils.string2number(size.substring(0, pos)).floatValue());
        }
        throw new IllegalArgumentException("Size " + size + " has a unrecognizable format");
    }

    public static Number string2number(String iText) {
        if (iText.indexOf(46) > -1) {
            return Double.parseDouble(iText);
        }
        return Long.parseLong(iText);
    }

    public static String getSizeAsString(long iSize) {
        if (iSize > 0x10000000000L) {
            return String.format("%2.2fTb", Float.valueOf((float)iSize / 1.0995116E12f));
        }
        if (iSize > 0x40000000L) {
            return String.format("%2.2fGb", Float.valueOf((float)iSize / 1.0737418E9f));
        }
        if (iSize > 0x100000L) {
            return String.format("%2.2fMb", Float.valueOf((float)iSize / 1048576.0f));
        }
        if (iSize > 1024L) {
            return String.format("%2.2fKb", Float.valueOf((float)iSize / 1024.0f));
        }
        return String.valueOf(String.valueOf(iSize)) + "b";
    }

    public static String getDirectory(String iPath) {
        int pos = (iPath = OFileUtils.getPath(iPath)).lastIndexOf("/");
        if (pos == -1) {
            return "";
        }
        return iPath.substring(0, pos);
    }

    public static void createDirectoryTree(String iFileName) {
        String[] fileDirectories = iFileName.split("/");
        int i = 0;
        while (i < fileDirectories.length - 1) {
            new File(fileDirectories[i]).mkdir();
            ++i;
        }
    }

    public static String getPath(String iPath) {
        if (iPath == null) {
            return null;
        }
        return iPath.replace('\\', '/');
    }
}

