/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OLogFormatter
extends Formatter {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");
    private static final String EOL = System.getProperty("line.separator");

    public String format(LogRecord record) {
        if (record.getThrown() == null) {
            return this.customFormatMessage(record);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(record.getMessage());
        Throwable current = record.getThrown();
        while (current != null) {
            buffer.append(EOL).append(current.getMessage());
            StackTraceElement[] stackTraceElementArray = record.getThrown().getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                buffer.append(EOL).append("-> ");
                buffer.append(stackTraceElement.toString());
                ++n2;
            }
            current = current.getCause();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String customFormatMessage(LogRecord iRecord) {
        Level iLevel = iRecord.getLevel();
        String iMessage = iRecord.getMessage();
        Object[] iAdditionalArgs = iRecord.getParameters();
        String iRequester = this.getSourceClassSimpleName(iRecord.getLoggerName());
        StringBuilder buffer = new StringBuilder();
        buffer.append(EOL);
        DateFormat dateFormat = OLogFormatter.dateFormat;
        synchronized (dateFormat) {
            buffer.append(OLogFormatter.dateFormat.format(new Date()));
        }
        buffer.append(' ');
        buffer.append(iLevel.getName().substring(0, 4));
        buffer.append(' ');
        try {
            buffer.append(String.format(iMessage, iAdditionalArgs));
        }
        catch (Exception e) {
            buffer.append(iMessage);
        }
        if (iRequester != null) {
            buffer.append(" [");
            buffer.append(iRequester);
            buffer.append(']');
        }
        return buffer.toString();
    }

    private String getSourceClassSimpleName(String iSourceClassName) {
        return iSourceClassName.substring(iSourceClassName.lastIndexOf(".") + 1);
    }
}

