/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import java.util.ArrayList;

public class OStringParser {
    public static final String WHITE_SPACE = " ";
    public static final String COMMON_JUMP = " \r\n";

    public static String getWordFromString(String iText, int iBeginIndex, String ioSeparatorChars) {
        return OStringParser.getWord(iText, iBeginIndex, ioSeparatorChars);
    }

    public static String getWord(CharSequence iText, int iBeginIndex, String ioSeparatorChars) {
        StringBuilder buffer = new StringBuilder();
        char stringBeginChar = ' ';
        int i = iBeginIndex;
        while (i < iText.length()) {
            char c = iText.charAt(i);
            if (c == '\'' || c == '\"') {
                if (stringBeginChar != ' ') {
                    if (stringBeginChar == c) {
                        stringBeginChar = ' ';
                    }
                } else {
                    stringBeginChar = c;
                }
            } else if (stringBeginChar == ' ') {
                int sepIndex = 0;
                while (sepIndex < ioSeparatorChars.length()) {
                    if (ioSeparatorChars.charAt(sepIndex) == c && buffer.length() > 0) {
                        return buffer.toString();
                    }
                    ++sepIndex;
                }
            }
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] getWords(String iRecord, String iSeparatorChars) {
        return OStringParser.getWords(iRecord, iSeparatorChars, false);
    }

    public static String[] getWords(String iRecord, String iSeparatorChars, boolean iIncludeStringSep) {
        return OStringParser.getWords(iRecord, iSeparatorChars, " \n\r\t", iIncludeStringSep);
    }

    public static String[] getWords(String iText, String iSeparatorChars, String iJumpChars, boolean iIncludeStringSep) {
        iText = iText.trim();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int stringBeginChar = ' ';
        int openBraket = 0;
        int openGraph = 0;
        boolean escape = false;
        int i = 0;
        while (i < iText.length()) {
            block27: {
                char c;
                block30: {
                    boolean charFound;
                    block32: {
                        block33: {
                            block31: {
                                block28: {
                                    block29: {
                                        block26: {
                                            c = iText.charAt(i);
                                            if (openBraket != 0 || openGraph != 0 || escape || c != '\\' || i + 1 >= iText.length()) break block26;
                                            char nextChar = iText.charAt(i + 1);
                                            if (nextChar == 'u') {
                                                i = OStringParser.readUnicode(iText, i + 2, buffer);
                                            } else if (nextChar == 'n') {
                                                buffer.append("\n");
                                                ++i;
                                            } else if (nextChar == 'r') {
                                                buffer.append("\r");
                                                ++i;
                                            } else if (nextChar == 't') {
                                                buffer.append("\t");
                                                ++i;
                                            } else if (nextChar == 'f') {
                                                buffer.append("\f");
                                                ++i;
                                            } else {
                                                escape = true;
                                            }
                                            break block27;
                                        }
                                        if (openBraket != 0 || openGraph != 0 || escape || c != '\'' && c != '\"') break block28;
                                        if (stringBeginChar == 32) break block29;
                                        if (stringBeginChar != c) break block30;
                                        stringBeginChar = 32;
                                        if (iIncludeStringSep) {
                                            buffer.append(c);
                                        }
                                        fields.add(buffer.toString());
                                        buffer.setLength(0);
                                        break block27;
                                    }
                                    stringBeginChar = c;
                                    if (iIncludeStringSep) {
                                        buffer.append(c);
                                    }
                                    break block27;
                                }
                                if (stringBeginChar != 32) break block30;
                                if (c == '[') {
                                    ++openBraket;
                                } else if (c == ']') {
                                    --openBraket;
                                }
                                if (c != '{') break block31;
                                ++openGraph;
                                break block32;
                            }
                            if (c != '}') break block33;
                            --openGraph;
                            break block32;
                        }
                        if (openBraket != 0 || openGraph != 0) break block32;
                        charFound = false;
                        int sepIndex = 0;
                        while (sepIndex < iSeparatorChars.length()) {
                            if (iSeparatorChars.charAt(sepIndex) == c) {
                                charFound = true;
                                if (buffer.length() <= 0) break;
                                fields.add(buffer.toString());
                                buffer.setLength(0);
                                break;
                            }
                            ++sepIndex;
                        }
                        if (charFound) break block27;
                    }
                    if (stringBeginChar != 32) break block30;
                    charFound = false;
                    int jumpIndex = 0;
                    while (jumpIndex < iJumpChars.length()) {
                        if (iJumpChars.charAt(jumpIndex) == c) {
                            charFound = true;
                            break;
                        }
                        ++jumpIndex;
                    }
                    if (charFound) break block27;
                }
                buffer.append(c);
                if (escape) {
                    escape = false;
                }
            }
            ++i;
        }
        if (buffer.length() > 0) {
            fields.add(buffer.toString());
        }
        String[] result = new String[fields.size()];
        fields.toArray(result);
        return result;
    }

    public static String[] split(String iText, char iSplitChar, String iJumpChars) {
        iText = iText.trim();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char stringChar = ' ';
        boolean escape = false;
        boolean jumpSplitChar = false;
        int i = 0;
        while (i < iText.length()) {
            block15: {
                char c;
                block17: {
                    block16: {
                        block14: {
                            c = iText.charAt(i);
                            if (escape || c != '\\' || i + 1 >= iText.length()) break block14;
                            if (iText.charAt(i + 1) == 'u') {
                                i = OStringParser.readUnicode(iText, i + 2, buffer);
                            } else {
                                escape = true;
                                buffer.append(c);
                            }
                            break block15;
                        }
                        if (c == '\'' || c == '\"') {
                            if (!jumpSplitChar) {
                                jumpSplitChar = true;
                                stringChar = c;
                            } else if (!escape && c == stringChar) {
                                jumpSplitChar = false;
                            }
                        }
                        if (c != iSplitChar || jumpSplitChar) break block16;
                        fields.add(buffer.toString());
                        buffer.setLength(0);
                        break block15;
                    }
                    if (buffer.length() != 0) break block17;
                    boolean charFound = false;
                    int jumpIndex = 0;
                    while (jumpIndex < iJumpChars.length()) {
                        if (iJumpChars.charAt(jumpIndex) == c) {
                            charFound = true;
                            break;
                        }
                        ++jumpIndex;
                    }
                    if (charFound) break block15;
                }
                buffer.append(c);
                if (escape) {
                    escape = false;
                }
            }
            ++i;
        }
        if (buffer.length() > 0) {
            fields.add(buffer.toString());
            buffer.setLength(0);
        }
        String[] result = new String[fields.size()];
        fields.toArray(result);
        return result;
    }

    public static int jumpWhiteSpaces(CharSequence iText, int iCurrentPosition) {
        return OStringParser.jump(iText, iCurrentPosition, COMMON_JUMP);
    }

    public static int jump(CharSequence iText, int iCurrentPosition, String iJumpChars) {
        if (iCurrentPosition < 0) {
            return -1;
        }
        int size = iText.length();
        int jumpCharSize = iJumpChars.length();
        boolean found = true;
        while (iCurrentPosition < size) {
            found = false;
            char c = iText.charAt(iCurrentPosition);
            int jumpIndex = 0;
            while (jumpIndex < jumpCharSize) {
                if (iJumpChars.charAt(jumpIndex) == c) {
                    found = true;
                    break;
                }
                ++jumpIndex;
            }
            if (!found) break;
            ++iCurrentPosition;
        }
        return iCurrentPosition >= size ? -1 : iCurrentPosition;
    }

    public static int readUnicode(String iText, int position, StringBuilder buffer) {
        StringBuilder buff = new StringBuilder();
        int lastPos = position + 4;
        while (position < lastPos) {
            buff.append(iText.charAt(position));
            ++position;
        }
        buffer.append((char)Integer.parseInt(buff.toString(), 16));
        return position - 1;
    }

    public static int readUnicode(char[] iText, int position, StringBuilder buffer) {
        StringBuilder buff = new StringBuilder();
        int lastPos = position + 4;
        while (position < lastPos) {
            buff.append(iText[position]);
            ++position;
        }
        buffer.append((char)Integer.parseInt(buff.toString(), 16));
        return position - 1;
    }

    public static String replaceAll(String iText, String iToReplace, String iReplacement) {
        if (iText == null || iText.length() <= 0 || iToReplace == null || iToReplace.length() <= 0) {
            return iText;
        }
        int pos = iText.indexOf(iToReplace);
        int lastAppend = 0;
        StringBuffer buffer = new StringBuffer();
        while (pos > -1) {
            buffer.append(iText.substring(lastAppend, pos));
            buffer.append(iReplacement);
            lastAppend = pos + iToReplace.length();
            pos = iText.indexOf(iToReplace, lastAppend);
        }
        buffer.append(iText.substring(lastAppend));
        return buffer.toString();
    }
}

