/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.reflection;

import com.orientechnologies.common.log.OLogManager;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OReflectionHelper {
    private static final String CLASS_EXTENSION = ".class";

    /*
     * Unable to fully structure code
     */
    public static List<Class<?>> getClassesForPackage(String iPackageName, ClassLoader iClassLoader) throws ClassNotFoundException {
        block15: {
            classes = new ArrayList<Class<?>>();
            directories = new ArrayList<File>();
            try {
                packageUrl = iPackageName.replace('.', '/');
                resources = iClassLoader.getResources(packageUrl);
                if (resources.hasMoreElements()) ** GOTO lbl23
                resources = iClassLoader.getResources(String.valueOf(packageUrl) + ".class");
                if (!resources.hasMoreElements()) break block15;
                throw new IllegalArgumentException(String.valueOf(iPackageName) + " does not appear to be a valid package but a class");
lbl-1000:
                // 1 sources

                {
                    res = resources.nextElement();
                    if (res.getProtocol().equalsIgnoreCase("jar")) {
                        conn = (JarURLConnection)res.openConnection();
                        jar = conn.getJarFile();
                        for (JarEntry e : Collections.list(jar.entries())) {
                            if (!e.getName().startsWith(iPackageName.replace('.', '/')) || !e.getName().endsWith(".class") || e.getName().contains("$")) continue;
                            className = e.getName().replace("/", ".").substring(0, e.getName().length() - 6);
                            classes.add(Class.forName(className));
                        }
                    } else {
                        directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
                    }
lbl23:
                    // 3 sources

                    ** while (resources.hasMoreElements())
                }
lbl24:
                // 1 sources

            }
            catch (NullPointerException x) {
                throw new ClassNotFoundException(String.valueOf(iPackageName) + " does not appear to be " + "a valid package (Null pointer exception)");
            }
            catch (UnsupportedEncodingException encex) {
                throw new ClassNotFoundException(String.valueOf(iPackageName) + " does not appear to be " + "a valid package (Unsupported encoding)");
            }
            catch (IOException ioex) {
                throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + iPackageName);
            }
        }
        for (File directory : directories) {
            if (directory.exists()) {
                files = directory.listFiles();
                var10_15 = files;
                var9_14 = files.length;
                var8_12 = 0;
                while (var8_12 < var9_14) {
                    file = var10_15[var8_12];
                    if (file.isDirectory()) {
                        classes.addAll(OReflectionHelper.findClasses((File)file, iPackageName));
                    } else if (file.getName().endsWith(".class")) {
                        className = file.getName().substring(0, file.getName().length() - ".class".length());
                        classes.add(Class.forName(String.valueOf(iPackageName) + '.' + className));
                    }
                    ++var8_12;
                }
                continue;
            }
            throw new ClassNotFoundException(String.valueOf(iPackageName) + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File iDirectory, String iPackageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!iDirectory.exists()) {
            return classes;
        }
        iPackageName = String.valueOf(iPackageName) + "." + iDirectory.getName();
        File[] fileArray = files = iDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (!file.getName().contains(".")) {
                    classes.addAll(OReflectionHelper.findClasses(file, iPackageName));
                }
            } else if (file.getName().endsWith(CLASS_EXTENSION)) {
                String className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length());
                classes.add(Class.forName(String.valueOf(iPackageName) + '.' + className));
            }
            ++n2;
        }
        return classes;
    }

    public static List<Class<?>> getClassessOfInterface(String thePackage, Class<?> theInterface, ClassLoader iClassLoader) {
        ArrayList classList = new ArrayList();
        try {
            for (Class<?> discovered : OReflectionHelper.getClassesForPackage(thePackage, iClassLoader)) {
                if (!Arrays.asList(discovered.getInterfaces()).contains(theInterface)) continue;
                classList.add(discovered);
            }
        }
        catch (ClassNotFoundException ex) {
            OLogManager.instance().error(null, "Error finding classes", (Throwable)ex, new Object[0]);
        }
        return classList;
    }

    public static Type[] getGenericTypes(Class<?> iClass) {
        ParameterizedType pt;
        Type genericType = iClass.getGenericInterfaces()[0];
        if (genericType != null && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments() != null && pt.getActualTypeArguments().length > 1) {
            return pt.getActualTypeArguments();
        }
        return null;
    }

    public static Class<?> getGenericMultivalueType(Field p) {
        if (p.getType() instanceof Class) {
            Type genericType = p.getGenericType();
            if (genericType != null && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                if (pt.getActualTypeArguments() != null && pt.getActualTypeArguments().length > 0) {
                    if (((Class)pt.getRawType()).isAssignableFrom(Map.class)) {
                        if (pt.getActualTypeArguments()[1] instanceof Class) {
                            return (Class)pt.getActualTypeArguments()[1];
                        }
                        if (pt.getActualTypeArguments()[1] instanceof ParameterizedType) {
                            return (Class)((ParameterizedType)pt.getActualTypeArguments()[1]).getRawType();
                        }
                    } else {
                        if (pt.getActualTypeArguments()[0] instanceof Class) {
                            return (Class)pt.getActualTypeArguments()[0];
                        }
                        if (pt.getActualTypeArguments()[0] instanceof ParameterizedType) {
                            return (Class)((ParameterizedType)pt.getActualTypeArguments()[0]).getRawType();
                        }
                    }
                }
            } else if (p.getType().isArray()) {
                return p.getType().getComponentType();
            }
        }
        return null;
    }

    public static boolean isJavaType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java.lang")) {
            return true;
        }
        if (clazz.getName().startsWith("java.util")) {
            return true;
        }
        return clazz.isArray();
    }
}

