/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.test;

import com.orientechnologies.common.test.SpeedTest;
import com.orientechnologies.common.test.SpeedTestData;
import com.orientechnologies.common.test.SpeedTestGroup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.annotations.Test;

@Test
public abstract class SpeedTestAbstract
implements SpeedTest {
    protected final SpeedTestData data;

    protected SpeedTestAbstract() {
        this.data = new SpeedTestData();
    }

    protected SpeedTestAbstract(long iCycles) {
        this.data = new SpeedTestData(iCycles);
    }

    protected SpeedTestAbstract(SpeedTestGroup iGroup) {
        this.data = new SpeedTestData(iGroup);
    }

    public abstract void cycle() throws Exception;

    public void init() throws Exception {
    }

    public void deinit() throws Exception {
    }

    public void beforeCycle() throws Exception {
    }

    public void afterCycle() throws Exception {
    }

    @Test
    public void test() {
        this.data.go(this);
    }

    public SpeedTestAbstract config(Object ... iArgs) {
        this.data.configuration = iArgs;
        return this;
    }

    public long executeCycle(Method iMethod, Object ... iArgs) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.data.startTimer(this.getClass().getSimpleName());
        int percent = 0;
        this.data.cyclesDone = 0L;
        while (this.data.cyclesDone < this.data.cycles) {
            iMethod.invoke((Object)this, iArgs);
            if (this.data.cycles > 10L && this.data.cyclesDone % (this.data.cycles / 10L) == 0L) {
                System.out.print(++percent);
            }
            ++this.data.cyclesDone;
        }
        return this.data.takeTimer();
    }

    public SpeedTestData data() {
        return this.data;
    }
}

