/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.test;

import com.orientechnologies.common.test.SpeedTest;
import com.orientechnologies.common.test.SpeedTestGroup;

public class SpeedTestData {
    protected static final int TIME_WAIT = 200;
    protected long cycles = 1L;
    protected long cyclesDone = 0L;
    protected static final int DUMP_PERCENT = 10;
    protected String currentTestName;
    protected long currentTestTimer;
    protected long currentTestFreeMemory;
    protected long currentTestTotalMemory;
    protected long currentTestMaxMemory;
    protected SpeedTestGroup testGroup;
    protected Object[] configuration;
    protected boolean printResults = true;
    protected long partialTimer = 0L;
    protected int partialTimerCounter = 0;
    private long cyclesElapsed;

    protected SpeedTestData() {
    }

    protected SpeedTestData(long iCycles) {
        this.cycles = iCycles;
    }

    protected SpeedTestData(SpeedTestGroup iGroup) {
        this.setTestGroup(iGroup);
    }

    public SpeedTestData config(Object ... iArgs) {
        this.configuration = iArgs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(SpeedTest iTarget) {
        this.currentTestName = iTarget.getClass().getSimpleName();
        try {
            if (SpeedTestData.executeInit(iTarget, this.configuration)) {
                this.executeTest(iTarget, this.configuration);
            }
        }
        finally {
            SpeedTestData.executeDeinit(iTarget, this.configuration);
            this.collectResults(this.takeTimer());
        }
    }

    public void startTimer(String iName) {
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.currentTestName = iName;
        this.currentTestFreeMemory = Runtime.getRuntime().freeMemory();
        this.currentTestTotalMemory = Runtime.getRuntime().totalMemory();
        this.currentTestMaxMemory = Runtime.getRuntime().maxMemory();
        System.out.println("-> Started the test of '" + this.currentTestName + "' (" + this.cycles + " cycles)");
        this.currentTestTimer = System.currentTimeMillis();
    }

    public long takeTimer() {
        return System.currentTimeMillis() - this.currentTestTimer;
    }

    public void collectResults(long elapsed) {
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        long nowFreeMemory = Runtime.getRuntime().freeMemory();
        long nowTotalMemory = Runtime.getRuntime().totalMemory();
        long nowMaxMemory = Runtime.getRuntime().maxMemory();
        long freeMemory = nowFreeMemory - this.currentTestFreeMemory;
        long totalMemory = nowTotalMemory - this.currentTestTotalMemory;
        long maxMemory = nowMaxMemory - this.currentTestMaxMemory;
        if (this.printResults) {
            System.out.println();
            System.out.println("   Completed the test of '" + this.currentTestName + "' in " + elapsed + " ms. Memory used: " + freeMemory);
            System.out.println("   Cycles done.........: " + this.cyclesDone + "/" + this.cycles);
            System.out.println("   Cycles Elapsed......: " + this.cyclesElapsed + " ms");
            System.out.println("   Elapsed.............: " + elapsed + " ms");
            System.out.println("   Medium cycle elapsed: " + (float)elapsed / (float)this.cyclesDone);
            System.out.println("   Cycles per second...: " + (float)this.cyclesDone / (float)elapsed * 1000.0f);
            System.out.println("   Free memory diff....: " + freeMemory + " (" + this.currentTestFreeMemory + "->" + nowFreeMemory + ")");
            System.out.println("   Total memory diff...: " + totalMemory + " (" + this.currentTestTotalMemory + "->" + nowTotalMemory + ")");
            System.out.println("   Max memory diff.....: " + maxMemory + " (" + this.currentTestMaxMemory + "->" + nowMaxMemory + ")");
            System.out.println();
        }
        if (this.testGroup != null) {
            this.testGroup.setResult("Execution time", this.currentTestName, elapsed);
            this.testGroup.setResult("Free memory", this.currentTestName, freeMemory);
        }
        this.currentTestFreeMemory = freeMemory;
        this.currentTestTotalMemory = totalMemory;
        this.currentTestMaxMemory = maxMemory;
    }

    public long printSnapshot() {
        long e = this.takeTimer();
        StringBuilder buffer = new StringBuilder();
        buffer.append("Partial timer #");
        buffer.append(++this.partialTimerCounter);
        buffer.append(" elapsed: ");
        buffer.append(e);
        buffer.append(" ms");
        if (this.partialTimer > 0L) {
            buffer.append(" (from last partial: ");
            buffer.append(e - this.partialTimer);
            buffer.append(" ms)");
        }
        System.out.println(buffer);
        this.partialTimer = e;
        return this.partialTimer;
    }

    public long getCycles() {
        return this.cycles;
    }

    public SpeedTestData setCycles(long cycles) {
        this.cycles = cycles;
        return this;
    }

    public SpeedTestGroup getTestGroup() {
        return this.testGroup;
    }

    public SpeedTestData setTestGroup(SpeedTestGroup testGroup) {
        this.testGroup = testGroup;
        return this;
    }

    public Object[] getConfiguration() {
        return this.configuration;
    }

    protected static boolean executeInit(SpeedTest iTarget, Object ... iArgs) {
        try {
            iTarget.init();
            return true;
        }
        catch (Throwable t) {
            System.err.println("Exception caught when executing INIT: " + iTarget.getClass().getSimpleName());
            t.printStackTrace();
            return false;
        }
    }

    protected long executeTest(SpeedTest iTarget, Object ... iArgs) {
        try {
            this.startTimer(iTarget.getClass().getSimpleName());
            this.cyclesElapsed = 0L;
            long previousLapTimerElapsed = 0L;
            long lapTimerElapsed = 0L;
            lapTimerElapsed = System.nanoTime();
            this.cyclesDone = 0L;
            while (this.cyclesDone < this.cycles) {
                iTarget.beforeCycle();
                iTarget.cycle();
                iTarget.afterCycle();
                if (this.cycles > 10L && (this.cyclesDone + 1L) % (this.cycles / 10L) == 0L) {
                    lapTimerElapsed = (System.nanoTime() - lapTimerElapsed) / 1000000L;
                    this.cyclesElapsed += lapTimerElapsed;
                    int delta = (int)(previousLapTimerElapsed > 0L ? lapTimerElapsed * 100L / previousLapTimerElapsed - 100L : 0L);
                    System.out.print(String.format("\n%3d%% lap elapsed: %7dms, total: %7dms, delta: %+3d%%, forecast: %7dms", (this.cyclesDone + 1L) * 100L / this.cycles, lapTimerElapsed, this.cyclesElapsed, delta, this.cyclesElapsed * this.cycles / this.cyclesDone));
                    previousLapTimerElapsed = lapTimerElapsed;
                    lapTimerElapsed = System.nanoTime();
                }
                ++this.cyclesDone;
            }
            return this.takeTimer();
        }
        catch (Throwable t) {
            System.err.println("Exception caught when executing CYCLE test: " + iTarget.getClass().getSimpleName());
            t.printStackTrace();
            return -1L;
        }
    }

    protected static void executeDeinit(SpeedTest iTarget, Object ... iArgs) {
        try {
            iTarget.deinit();
        }
        catch (Throwable t) {
            System.err.println("Exception caught when executing DEINIT: " + iTarget.getClass().getSimpleName());
            t.printStackTrace();
        }
    }

    public long getCyclesDone() {
        return this.cyclesDone;
    }
}

