/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.log.OLogManager;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OArrays {
    public static <T> T[] copyOf(T[] iSource, int iNewSize) {
        return OArrays.copyOf(iSource, iNewSize, iSource.getClass());
    }

    public static <T, U> T[] copyOf(U[] iSource, int iNewSize, Class<? extends T[]> iNewType) {
        Object[] copy = iNewType == Object[].class ? new Object[iNewSize] : (Object[])Array.newInstance(iNewType.getComponentType(), iNewSize);
        System.arraycopy(iSource, 0, copy, 0, Math.min(iSource.length, iNewSize));
        return copy;
    }

    public static <S> S[] copyOfRange(S[] iSource, int iBegin, int iEnd) {
        return OArrays.copyOfRange(iSource, iBegin, iEnd, iSource.getClass());
    }

    public static <D, S> D[] copyOfRange(S[] iSource, int iBegin, int iEnd, Class<? extends D[]> iClass) {
        int newLength = iEnd - iBegin;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(iBegin) + " > " + iEnd);
        }
        Object[] copy = iClass == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(iClass.getComponentType(), newLength);
        System.arraycopy(iSource, iBegin, copy, 0, Math.min(iSource.length - iBegin, newLength));
        return copy;
    }

    public static byte[] copyOfRange(byte[] iSource, int iBegin, int iEnd) {
        int newLength = iEnd - iBegin;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(iBegin) + " > " + iEnd);
        }
        try {
            byte[] copy = new byte[newLength];
            System.arraycopy(iSource, iBegin, copy, 0, Math.min(iSource.length - iBegin, newLength));
            return copy;
        }
        catch (OutOfMemoryError e) {
            OLogManager.instance().error(null, "Error on copying buffer of size %d bytes", (Throwable)e, newLength);
            throw e;
        }
    }

    public static int[] copyOf(int[] iSource, int iNewSize) {
        int[] copy = new int[iNewSize];
        System.arraycopy(iSource, 0, copy, 0, Math.min(iSource.length, iNewSize));
        return copy;
    }
}

