/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.util.OMultiKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class OMultiKeyTest {
    @Test
    public void testEqualsDifferentSize() {
        OMultiKey multiKey = new OMultiKey(Collections.singletonList("a"));
        OMultiKey anotherMultiKey = new OMultiKey(Arrays.asList("a", "b"));
        Assert.assertFalse((boolean)multiKey.equals(anotherMultiKey));
    }

    @Test
    public void testEqualsDifferentItems() {
        OMultiKey multiKey = new OMultiKey(Arrays.asList("b", "c"));
        OMultiKey anotherMultiKey = new OMultiKey(Arrays.asList("a", "b"));
        Assert.assertFalse((boolean)multiKey.equals(anotherMultiKey));
    }

    @Test
    public void testEqualsTheSame() {
        OMultiKey multiKey = new OMultiKey(Collections.singletonList("a"));
        Assert.assertTrue((boolean)multiKey.equals(multiKey));
    }

    @Test
    public void testEqualsNull() {
        OMultiKey multiKey = new OMultiKey(Collections.singletonList("a"));
        Assert.assertFalse((boolean)multiKey.equals(null));
    }

    @Test
    public void testEqualsDifferentClass() {
        OMultiKey multiKey = new OMultiKey(Collections.singletonList("a"));
        Assert.assertFalse((boolean)multiKey.equals("a"));
    }

    @Test
    public void testEmptyKeyEquals() {
        HashMap<OMultiKey, Object> multiKeyMap = new HashMap<OMultiKey, Object>();
        OMultiKey multiKey = new OMultiKey(Collections.emptyList());
        multiKeyMap.put(multiKey, new Object());
        OMultiKey anotherMultiKey = new OMultiKey(Collections.emptyList());
        Object mapResult = multiKeyMap.get(anotherMultiKey);
        Assert.assertNotNull(mapResult);
    }

    @Test
    public void testOneKeyMap() {
        HashMap<OMultiKey, Object> multiKeyMap = new HashMap<OMultiKey, Object>();
        OMultiKey multiKey = new OMultiKey(Collections.singletonList("a"));
        multiKeyMap.put(multiKey, new Object());
        OMultiKey anotherMultiKey = new OMultiKey(Collections.singletonList("a"));
        Object mapResult = multiKeyMap.get(anotherMultiKey);
        Assert.assertNotNull(mapResult);
    }

    @Test
    public void testOneKeyNotInMap() {
        HashMap<OMultiKey, Object> multiKeyMap = new HashMap<OMultiKey, Object>();
        OMultiKey multiKey = new OMultiKey(Collections.singletonList("a"));
        multiKeyMap.put(multiKey, new Object());
        OMultiKey anotherMultiKey = new OMultiKey(Collections.singletonList("b"));
        Object mapResult = multiKeyMap.get(anotherMultiKey);
        Assert.assertNull(mapResult);
    }

    @Test
    public void testTwoKeyMap() {
        HashMap<OMultiKey, Object> multiKeyMap = new HashMap<OMultiKey, Object>();
        OMultiKey multiKey = new OMultiKey(Arrays.asList("a", "b"));
        multiKeyMap.put(multiKey, new Object());
        OMultiKey anotherMultiKey = new OMultiKey(Arrays.asList("a", "b"));
        Object mapResult = multiKeyMap.get(anotherMultiKey);
        Assert.assertNotNull(mapResult);
    }

    @Test
    public void testTwoKeyMapReordered() {
        HashMap<OMultiKey, Object> multiKeyMap = new HashMap<OMultiKey, Object>();
        OMultiKey multiKey = new OMultiKey(Arrays.asList("a", "b"));
        multiKeyMap.put(multiKey, new Object());
        OMultiKey anotherMultiKey = new OMultiKey(Arrays.asList("b", "a"));
        Object mapResult = multiKeyMap.get(anotherMultiKey);
        Assert.assertNotNull(mapResult);
    }
}

