/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseFactory;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabasePoolBase;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.local.OEngineLocal;
import com.orientechnologies.orient.core.engine.memory.OEngineMemory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.storage.OClusterFactory;
import com.orientechnologies.orient.core.storage.ODefaultClusterFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orient
extends OSharedResourceAbstract {
    public static final String ORIENTDB_HOME = "ORIENTDB_HOME";
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    protected Map<String, OEngine> engines = new HashMap<String, OEngine>();
    protected Map<String, OStorage> storages = new HashMap<String, OStorage>();
    protected Set<ODatabaseLifecycleListener> dbLifecycleListeners = new HashSet<ODatabaseLifecycleListener>();
    protected final List<OOrientListener> listeners = new ArrayList<OOrientListener>();
    protected ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    protected ODatabaseFactory databaseFactory = new ODatabaseFactory();
    protected OClusterFactory clusterFactory = new ODefaultClusterFactory();
    protected volatile boolean active = false;
    protected static final OrientShutdownHook shutdownHook = new OrientShutdownHook();
    protected static final Timer timer = new Timer(true);
    protected static final ThreadGroup threadGroup = new ThreadGroup("OrientDB");
    protected static Orient instance = new Orient();
    private final OMemoryWatchDog memoryWatchDog;
    private static AtomicInteger serialId = new AtomicInteger();
    protected List<Class<? extends ODatabasePoolBase<?>>> pools;

    protected Orient() {
        this.registerEngine(new OEngineLocal());
        this.registerEngine(new OEngineMemory());
        this.registerEngine("com.orientechnologies.orient.client.remote.OEngineRemote");
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean()) {
            OProfiler.getInstance().startRecording();
        }
        this.memoryWatchDog = new OMemoryWatchDog();
        this.active = true;
    }

    public OStorage loadStorage(String iURL) {
        int pos;
        if (iURL == null || iURL.length() == 0) {
            throw new IllegalArgumentException("URL missed");
        }
        if (iURL.endsWith("/")) {
            iURL = iURL.substring(0, iURL.length() - 1);
        }
        if ((pos = iURL.indexOf(58)) <= 0) {
            throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
        }
        String engineName = iURL.substring(0, pos);
        this.acquireExclusiveLock();
        try {
            OStorage storage;
            OEngine engine = this.engines.get(engineName.toLowerCase());
            if (engine == null) {
                throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was not found. URL was: " + iURL + ". Registered engines are: " + this.engines.keySet());
            }
            iURL = iURL.substring(pos + 1);
            pos = iURL.indexOf(63);
            HashMap<String, String> parameters = null;
            String dbName = null;
            if (pos > 0) {
                String[] pairs;
                dbName = iURL.substring(0, pos);
                iURL = iURL.substring(pos + 1);
                parameters = new HashMap<String, String>();
                String[] stringArray = pairs = iURL.split("&");
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] kv = pair.split("=");
                    if (kv.length < 2) {
                        throw new OConfigurationException("Error on opening database: parameter has no value. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
                    }
                    parameters.put(kv[0], kv[1]);
                    ++n2;
                }
            } else {
                dbName = iURL;
            }
            if (engine.isShared()) {
                storage = this.storages.get(dbName);
                if (storage == null) {
                    storage = engine.createStorage(dbName, parameters);
                    this.storages.put(dbName, storage);
                }
            } else {
                storage = engine.createStorage(dbName, parameters);
                this.storages.put(String.valueOf(dbName) + "__" + serialId.incrementAndGet(), storage);
            }
            for (OOrientListener l : this.listeners) {
                l.onStorageRegistered(storage);
            }
            OStorage oStorage = storage;
            return oStorage;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void registerStorage(OStorage iStorage) throws IOException {
        this.acquireExclusiveLock();
        try {
            for (OOrientListener l : this.listeners) {
                l.onStorageRegistered(iStorage);
            }
            if (!this.storages.containsKey(iStorage.getName())) {
                this.storages.put(iStorage.getURL(), iStorage);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OStorage getStorage(String iDbName) {
        this.acquireSharedLock();
        try {
            OStorage oStorage = this.storages.get(iDbName);
            return oStorage;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void registerEngine(OEngine iEngine) {
        this.acquireExclusiveLock();
        try {
            this.engines.put(iEngine.getName(), iEngine);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void registerEngine(String iClassName) {
        try {
            Class<?> cls = Class.forName(iClassName);
            this.registerEngine((OEngine)cls.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OEngine getEngine(String iEngineName) {
        this.acquireSharedLock();
        try {
            OEngine oEngine = this.engines.get(iEngineName);
            return oEngine;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public Set<String> getEngines() {
        this.acquireSharedLock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.engines.keySet());
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void unregisterStorage(OStorage iStorage) {
        if (!this.active) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            for (OOrientListener oOrientListener : this.listeners) {
                oOrientListener.onStorageUnregistered(iStorage);
            }
            for (Map.Entry entry : this.storages.entrySet()) {
                if (entry.getValue() != iStorage) continue;
                this.storages.remove(entry.getKey());
                break;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public Collection<OStorage> getStorages() {
        try {
            this.acquireSharedLock();
            ArrayList<OStorage> arrayList = new ArrayList<OStorage>(this.storages.values());
            return arrayList;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void shutdown() {
        this.acquireExclusiveLock();
        try {
            if (!this.active) {
                return;
            }
            this.active = false;
            shutdownHook.cancel();
            OLogManager.instance().debug((Object)this, "Orient Engine is shutting down...", new Object[0]);
            for (OOrientListener l : this.listeners) {
                l.onShutdown();
            }
            this.databaseFactory.shutdown();
            ArrayList<OStorage> storagesCopy = new ArrayList<OStorage>(this.storages.values());
            for (OStorage stg : storagesCopy) {
                OLogManager.instance().debug((Object)this, "Shutting down storage: " + stg.getName() + "...", new Object[0]);
                stg.close(true);
            }
            OMMapManager.shutdown();
            threadGroup.interrupt();
            this.listeners.clear();
            OLogManager.instance().debug((Object)this, "Orient Engine shutdown complete", new Object[0]);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public static Timer getTimer() {
        return timer;
    }

    public void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
    }

    public Iterator<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return this.dbLifecycleListeners.iterator();
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.add(iListener);
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public static Orient instance() {
        return instance;
    }

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public OMemoryWatchDog getMemoryWatchDog() {
        return this.memoryWatchDog;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }

    public OClusterFactory getClusterFactory() {
        return this.clusterFactory;
    }

    public ODatabaseFactory getDatabaseFactory() {
        return this.databaseFactory;
    }

    public void registerListener(OOrientListener iListener) {
        this.acquireExclusiveLock();
        try {
            if (!this.listeners.contains(iListener)) {
                this.listeners.add(iListener);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void unregisterListener(OOrientListener iListener) {
        if (!this.active) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            int i = 0;
            while (i < this.listeners.size()) {
                if (this.listeners.get(i) == iListener) {
                    this.listeners.remove(i);
                    break;
                }
                ++i;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public List<OOrientListener> getListeners() {
        this.acquireExclusiveLock();
        try {
            ArrayList<OOrientListener> arrayList = new ArrayList<OOrientListener>(this.listeners);
            return arrayList;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void setRecordFactoryManager(ORecordFactoryManager iRecordFactoryManager) {
        this.recordFactoryManager = iRecordFactoryManager;
    }

    public static String getHomePath() {
        String v = System.getProperty("orient.home");
        if (v == null) {
            v = System.getenv(ORIENTDB_HOME);
        }
        return v;
    }

    public void setClusterFactory(OClusterFactory clusterFactory) {
        this.clusterFactory = clusterFactory;
    }
}

