/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandGenericIterator
implements Iterator<Object>,
Iterable<Object> {
    protected OCommandExecutor command;
    protected Iterator<Object> resultSet;
    protected Object resultOne;
    protected boolean executed = false;

    public OCommandGenericIterator(OCommandExecutor command) {
        this.command = command;
    }

    @Override
    public boolean hasNext() {
        this.checkForExecution();
        if (this.resultOne != null) {
            return true;
        }
        if (this.resultSet != null) {
            return this.resultSet.hasNext();
        }
        return false;
    }

    @Override
    public Object next() {
        this.checkForExecution();
        if (this.resultOne != null) {
            return this.resultOne;
        }
        if (this.resultSet != null) {
            return this.resultSet.next();
        }
        return null;
    }

    @Override
    public Iterator<Object> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    protected void checkForExecution() {
        if (!this.executed) {
            this.executed = true;
            Object result = this.command.execute(null);
            if (result instanceof Collection) {
                this.resultSet = ((Collection)result).iterator();
            } else if (result instanceof Object) {
                this.resultOne = result;
            }
        }
    }
}

