/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequestAbstract;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCommandRequestTextAbstract
extends OCommandRequestAbstract
implements OCommandRequestText {
    protected String text;
    protected OCommandContext context;

    protected OCommandRequestTextAbstract() {
    }

    protected OCommandRequestTextAbstract(String iText) {
        if (iText == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.text = iText.trim();
    }

    @Override
    public <RET> RET execute(Object ... iArgs) {
        this.setParameters(iArgs);
        return (RET)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().command(this);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public OCommandRequestText setText(String iText) {
        this.text = iText;
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream(iStream);
        this.fromStream(buffer);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream();
        return this.toStream(buffer);
    }

    @Override
    public OCommandContext getContext() {
        return this.context;
    }

    @Override
    public OCommandRequestText setContext(OCommandContext iContext) {
        this.context = iContext;
        return this;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [text=" + this.text + "]";
    }

    protected byte[] toStream(OMemoryStream buffer) {
        buffer.set(this.text);
        if (this.parameters == null || this.parameters.size() == 0) {
            buffer.set(false);
            buffer.set(false);
        } else {
            HashMap params = new HashMap();
            HashMap compositeKeyParams = new HashMap();
            for (Map.Entry paramEntry : this.parameters.entrySet()) {
                if (paramEntry.getValue() instanceof OCompositeKey) {
                    OCompositeKey compositeKey = (OCompositeKey)paramEntry.getValue();
                    int bufferSize = OCompositeKeySerializer.INSTANCE.getObjectSize(compositeKey);
                    byte[] stream = new byte[bufferSize];
                    OCompositeKeySerializer.INSTANCE.serialize(compositeKey, stream, 0);
                    compositeKeyParams.put(paramEntry.getKey(), stream);
                    continue;
                }
                if (paramEntry.getValue() instanceof String) {
                    StringBuilder builder = new StringBuilder();
                    ORecordSerializerStringAbstract.simpleValueToStream(builder, OType.STRING, paramEntry.getValue());
                    params.put(paramEntry.getKey(), builder.toString());
                    continue;
                }
                params.put(paramEntry.getKey(), (String)paramEntry.getValue());
            }
            buffer.set(!params.isEmpty());
            if (!params.isEmpty()) {
                ODocument param = new ODocument();
                param.field("params", params);
                buffer.set(param.toStream());
            }
            buffer.set(!compositeKeyParams.isEmpty());
            if (!compositeKeyParams.isEmpty()) {
                ODocument compositeKey = new ODocument();
                compositeKey.field("compositeKeyParams", compositeKeyParams);
                buffer.set(compositeKey.toStream());
            }
        }
        return buffer.toByteArray();
    }

    protected void fromStream(OMemoryStream buffer) {
        boolean compositeKeyParamsPresent;
        this.text = buffer.getAsString();
        this.parameters = null;
        boolean simpleParams = buffer.getAsBoolean();
        if (simpleParams) {
            byte[] paramBuffer = buffer.getAsByteArray();
            ODocument param = new ODocument();
            param.fromStream(paramBuffer);
            Map params = (Map)param.field("params");
            this.parameters = new HashMap();
            for (Map.Entry p : params.entrySet()) {
                Object value = p.getValue() instanceof String ? ORecordSerializerStringAbstract.getTypeValue((String)p.getValue()) : p.getValue();
                if (Character.isDigit(((String)p.getKey()).charAt(0))) {
                    this.parameters.put(Integer.parseInt((String)p.getKey()), value);
                    continue;
                }
                this.parameters.put(p.getKey(), value);
            }
        }
        if (compositeKeyParamsPresent = buffer.getAsBoolean()) {
            byte[] paramBuffer = buffer.getAsByteArray();
            ODocument param = new ODocument();
            param.fromStream(paramBuffer);
            Map compositeKeyParams = (Map)param.field("compositeKeyParams");
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            for (Map.Entry p : compositeKeyParams.entrySet()) {
                OCompositeKey value = OCompositeKeySerializer.INSTANCE.deserialize(OStringSerializerHelper.getBinaryContent(p.getValue()), 0);
                if (Character.isDigit(((String)p.getKey()).charAt(0))) {
                    this.parameters.put(Integer.parseInt((String)p.getKey()), value);
                    continue;
                }
                this.parameters.put(p.getKey(), value);
            }
        }
    }
}

