/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.OCommand;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraverseContext;
import com.orientechnologies.orient.core.command.traverse.OTraverseRecordSetProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTraverse
implements OCommand,
Iterable<OIdentifiable>,
Iterator<OIdentifiable> {
    private OTraverseContext context = new OTraverseContext();
    private OCommandPredicate predicate;
    private Iterator<? extends OIdentifiable> target;
    private List<String> fields = new ArrayList<String>();
    private long resultCount = 0L;
    private long limit = 0L;
    private OIdentifiable lastTraversed;

    @Override
    public List<OIdentifiable> execute() {
        ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }

    public OTraverseAbstractProcess<?> currentProcess() {
        return this.context.peek();
    }

    @Override
    public boolean hasNext() {
        if (this.limit > 0L && this.resultCount >= this.limit) {
            return false;
        }
        if (this.lastTraversed == null) {
            this.lastTraversed = this.next();
        }
        if (this.lastTraversed == null && this.context.peek() != null) {
            throw new IllegalStateException("Traverse ended abnormally");
        }
        return this.lastTraversed != null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public OIdentifiable next() {
        if (this.lastTraversed != null) {
            result = this.lastTraversed;
            this.lastTraversed = null;
            return result;
        }
        if (this.limit <= 0L || this.resultCount < this.limit) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            result = (OIdentifiable)toProcess.process();
            if (result == null) continue;
            ++this.resultCount;
            return result;
lbl11:
            // 2 sources

            ** while ((toProcess = this.currentProcess()) != null)
        }
lbl12:
        // 1 sources

        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    public OTraverse context(OCommandContext iContext) {
        if (iContext != null) {
            iContext.merge(this.context);
        }
        return this;
    }

    @Override
    public OTraverseContext getContext() {
        return this.context;
    }

    public OTraverse target(Iterable<? extends OIdentifiable> iTarget) {
        return this.target(iTarget.iterator());
    }

    public OTraverse target(OIdentifiable ... iRecords) {
        ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
        OIdentifiable[] oIdentifiableArray = iRecords;
        int n = iRecords.length;
        int n2 = 0;
        while (n2 < n) {
            OIdentifiable id = oIdentifiableArray[n2];
            list.add(id);
            ++n2;
        }
        return this.target(list.iterator());
    }

    public OTraverse target(Iterator<? extends OIdentifiable> iTarget) {
        this.target = iTarget;
        this.context.reset();
        new OTraverseRecordSetProcess(this, this.target);
        return this;
    }

    public Iterator<? extends OIdentifiable> getTarget() {
        return this.target;
    }

    public OTraverse predicate(OCommandPredicate iPredicate) {
        this.predicate = iPredicate;
        return this;
    }

    public OCommandPredicate getPredicate() {
        return this.predicate;
    }

    public OTraverse field(String iFieldName) {
        if (!this.fields.contains(iFieldName)) {
            this.fields.add(iFieldName);
        }
        return this;
    }

    public OTraverse fields(Collection<String> iFields) {
        for (String f : iFields) {
            this.field(f);
        }
        return this;
    }

    public OTraverse fields(String ... iFields) {
        String[] stringArray = iFields;
        int n = iFields.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            this.field(f);
            ++n2;
        }
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public long getLimit() {
        return this.limit;
    }

    public OTraverse limit(long iLimit) {
        if (iLimit < -1L) {
            throw new IllegalArgumentException("Limit cannot be negative. 0 = infinite");
        }
        this.limit = iLimit;
        return this;
    }

    public String toString() {
        return String.format("OTraverse.target(%s).fields(%s).limit(%d).predicate(%s)", this.target, this.fields, this.limit, this.predicate);
    }

    public long getResultCount() {
        return this.resultCount;
    }

    public OIdentifiable getLastTraversed() {
        return this.lastTraversed;
    }
}

