/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTraverseContext
implements OCommandContext {
    private OCommandContext nestedStack;
    private Set<ORID> history = new HashSet<ORID>();
    private List<OTraverseAbstractProcess<?>> stack = new ArrayList();
    private int depth = -1;

    public void push(OTraverseAbstractProcess<?> iProcess) {
        this.stack.add(iProcess);
    }

    public OTraverseAbstractProcess<?> pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Traverse stack is empty");
        }
        return this.stack.remove(this.stack.size() - 1);
    }

    public OTraverseAbstractProcess<?> peek() {
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    public OTraverseAbstractProcess<?> peek(int iFromLast) {
        return this.stack.size() + iFromLast < 0 ? null : this.stack.get(this.stack.size() + iFromLast);
    }

    public void reset() {
        this.stack.clear();
    }

    public boolean isAlreadyTraversed(OIdentifiable identity) {
        return this.history.contains(identity.getIdentity());
    }

    public void addTraversed(OIdentifiable identity) {
        this.history.add(identity.getIdentity());
    }

    public int incrementDepth() {
        return ++this.depth;
    }

    public int decrementDepth() {
        return --this.depth;
    }

    @Override
    public Object getVariable(String iName) {
        String name = iName.trim().toUpperCase();
        if ("DEPTH".startsWith(name)) {
            return this.depth;
        }
        if (name.startsWith("PATH")) {
            return ODocumentHelper.getFieldValue(this.getPath(), iName.substring("PATH".length()));
        }
        if (name.startsWith("STACK")) {
            return ODocumentHelper.getFieldValue(this.stack, iName.substring("STACK".length()));
        }
        if (name.startsWith("HISTORY")) {
            return ODocumentHelper.getFieldValue(this.history, iName.substring("HISTORY".length()));
        }
        if (this.nestedStack != null) {
            this.nestedStack.getVariable(iName);
        }
        return null;
    }

    @Override
    public void setVariable(String iName, Object iValue) {
        if (this.nestedStack != null) {
            this.nestedStack.setVariable(iName, iValue);
        }
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("depth", this.depth);
        map.put("path", this.getPath());
        map.put("stack", this.stack);
        if (this.nestedStack != null) {
            map.putAll(this.nestedStack.getVariables());
        }
        return map;
    }

    @Override
    public void merge(OCommandContext context) {
        this.nestedStack = context;
    }

    public String getPath() {
        StringBuilder buffer = new StringBuilder();
        for (OTraverseAbstractProcess<?> process : this.stack) {
            String status = process.getStatus();
            if (status == null) continue;
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            buffer.append(status);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getVariables().toString();
    }
}

