/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseDocumentTx
extends ODatabaseRecordWrapperAbstract<ODatabaseRecordTx>
implements ODatabaseDocument {
    public ODatabaseDocumentTx(String iURL) {
        super(new ODatabaseRecordTx(iURL, 100));
    }

    public ODatabaseDocumentTx(ODatabaseRecordTx iSource) {
        super(iSource);
    }

    @Override
    public ODocument newInstance() {
        return new ODocument();
    }

    @Override
    public ODocument newInstance(String iClassName) {
        this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)iClassName);
        return new ODocument(iClassName);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    @Override
    public ORecordIteratorClass<ODocument> browseClass(String iClassName, boolean iPolymorphic) {
        if (this.getMetadata().getSchema().getClass(iClassName) == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in current database");
        }
        this.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iClassName);
        return new ORecordIteratorClass<ODocument>(this, (ODatabaseRecordAbstract)this.underlying, iClassName, iPolymorphic);
    }

    @Override
    public ORecordIteratorCluster<ODocument> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        return new ORecordIteratorCluster<ODocument>(this, (ODatabaseRecordAbstract)this.underlying, this.getClusterIdByName(iClusterName));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord) {
        return this.save(iRecord, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        if (!(iRecord instanceof ODocument)) {
            return super.save(iRecord, iMode, iCallback);
        }
        ODocument doc = (ODocument)iRecord;
        doc.validate();
        doc.convertAllMultiValuesToTrackedVersions();
        try {
            if (doc.getIdentity().isNew()) {
                if (doc.getClassName() != null) {
                    this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)doc.getClassName());
                }
                if (doc.getSchemaClass() != null && doc.getIdentity().getClusterId() < 0) {
                    String clusterName = this.getClusterNameById(doc.getSchemaClass().getDefaultClusterId());
                    return super.save(doc, clusterName, iMode, iCallback);
                }
            } else if (doc.getClassName() != null) {
                this.checkSecurity("database.class", ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
            }
            doc = (ODocument)super.save(doc, iMode, iCallback);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on saving record %s of class '%s'", e, ODatabaseException.class, iRecord.getIdentity(), doc.getClassName() != null ? doc.getClassName() : "?");
        }
        return (RET)doc;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, String iClusterName) {
        return this.save(iRecord, iClusterName, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        if (!(iRecord instanceof ODocument)) {
            return super.save(iRecord, iClusterName, iMode, iCallback);
        }
        ODocument doc = (ODocument)iRecord;
        if (!doc.getIdentity().isValid()) {
            int[] clusterIds;
            int id;
            if (doc.getClassName() != null) {
                this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)doc.getClassName());
            }
            if (iClusterName == null && doc.getSchemaClass() != null) {
                iClusterName = this.getClusterNameById(doc.getSchemaClass().getDefaultClusterId());
            }
            if ((id = this.getClusterIdByName(iClusterName)) == -1) {
                throw new IllegalArgumentException("Cluster name " + iClusterName + " is not configured");
            }
            if (doc.getSchemaClass() != null) {
                clusterIds = doc.getSchemaClass().getClusterIds();
                int i = 0;
                while (i < clusterIds.length) {
                    if (clusterIds[i] != id) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                clusterIds = new int[]{id};
            }
            if (id == clusterIds.length) {
                throw new IllegalArgumentException("Cluster name " + iClusterName + " is not configured to store the class " + doc.getClassName());
            }
        } else if (doc.getClassName() != null) {
            this.checkSecurity("database.class", ORole.PERMISSION_UPDATE, (Object)doc.getClassName());
        }
        doc.validate();
        doc.convertAllMultiValuesToTrackedVersions();
        doc = (ODocument)super.save(doc, iClusterName, iMode, iCallback);
        return (RET)doc;
    }

    public ODatabaseDocumentTx delete(ODocument iRecord) {
        if (iRecord == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (iRecord.getClassName() != null) {
            this.checkSecurity("database.class", ORole.PERMISSION_DELETE, (Object)iRecord.getClassName());
        }
        try {
            ((ODatabaseRecordTx)this.underlying).delete(iRecord);
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on deleting record %s of class '%s'", e, ODatabaseException.class, iRecord.getIdentity(), iRecord.getClassName());
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        OClass cls = this.getMetadata().getSchema().getClass(iClassName);
        if (cls == null) {
            throw new IllegalArgumentException("Class '" + iClassName + "' not found in database");
        }
        return cls.count();
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> commit() {
        try {
            ODatabaseRecord oDatabaseRecord = ((ODatabaseRecordTx)this.underlying).commit();
            return oDatabaseRecord;
        }
        finally {
            this.getTransaction().close();
        }
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> rollback() {
        try {
            ODatabaseRecord oDatabaseRecord = ((ODatabaseRecordTx)this.underlying).rollback();
            return oDatabaseRecord;
        }
        finally {
            this.getTransaction().close();
        }
    }

    @Override
    public String getType() {
        return "document";
    }
}

