/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabaseMigration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGraphDatabase
extends ODatabaseDocumentTx {
    public static final String TYPE = "graph";
    public static final String VERTEX_CLASS_NAME = "OGraphVertex";
    public static final String VERTEX_FIELD_IN = "in";
    public static final String VERTEX_FIELD_IN_EDGES = "inEdges";
    public static final String VERTEX_FIELD_OUT = "out";
    public static final String VERTEX_FIELD_OUT_EDGES = "outEdges";
    public static final String EDGE_CLASS_NAME = "OGraphEdge";
    public static final String EDGE_FIELD_IN = "in";
    public static final String EDGE_FIELD_OUT = "out";
    public static final String LABEL = "label";
    private boolean useCustomTypes = true;
    private boolean safeMode = false;
    protected OClass vertexBaseClass;
    protected OClass edgeBaseClass;

    public OGraphDatabase(String iURL) {
        super(iURL);
    }

    public OGraphDatabase(ODatabaseRecordTx iSource) {
        super(iSource);
        this.checkForGraphSchema();
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        super.open(iUserName, iUserPassword);
        this.checkForGraphSchema();
        return (THISDB)this;
    }

    @Override
    public <THISDB extends ODatabase> THISDB create() {
        super.create();
        this.checkForGraphSchema();
        return (THISDB)this;
    }

    @Override
    public void close() {
        super.close();
        this.vertexBaseClass = null;
        this.edgeBaseClass = null;
    }

    public long countVertexes() {
        return this.countClass(VERTEX_CLASS_NAME);
    }

    public long countEdges() {
        return this.countClass(EDGE_CLASS_NAME);
    }

    public Iterable<ODocument> browseVertices() {
        return this.browseElements(VERTEX_CLASS_NAME, true);
    }

    public Iterable<ODocument> browseVertices(boolean iPolymorphic) {
        return this.browseElements(VERTEX_CLASS_NAME, iPolymorphic);
    }

    public Iterable<ODocument> browseEdges() {
        return this.browseElements(EDGE_CLASS_NAME, true);
    }

    public Iterable<ODocument> browseEdges(boolean iPolymorphic) {
        return this.browseElements(EDGE_CLASS_NAME, iPolymorphic);
    }

    public Iterable<ODocument> browseElements(String iClass, boolean iPolymorphic) {
        return new ORecordIteratorClass<ODocument>(this, (ODatabaseRecordAbstract)this.getUnderlying(), iClass, iPolymorphic);
    }

    public ODocument createVertex() {
        return this.createVertex(null);
    }

    public ODocument createVertex(String iClassName) {
        if (iClassName == null) {
            iClassName = VERTEX_CLASS_NAME;
        } else {
            this.checkVertexClass(iClassName);
        }
        return new ODocument(iClassName).setOrdered(true);
    }

    public ODocument createEdge(ORID iSourceVertexRid, ORID iDestVertexRid) {
        return this.createEdge(iSourceVertexRid, iDestVertexRid, null);
    }

    public ODocument createEdge(ORID iSourceVertexRid, ORID iDestVertexRid, String iClassName) {
        ODocument sourceVertex = (ODocument)this.load(iSourceVertexRid);
        if (sourceVertex == null) {
            throw new IllegalArgumentException("Source vertex '" + iSourceVertexRid + "' does not exist");
        }
        ODocument destVertex = (ODocument)this.load(iDestVertexRid);
        if (destVertex == null) {
            throw new IllegalArgumentException("Source vertex '" + iDestVertexRid + "' does not exist");
        }
        return this.createEdge(sourceVertex, destVertex, iClassName);
    }

    public void removeVertex(ODocument iVertex) {
        boolean safeMode = this.beginBlock();
        try {
            Set otherEdges;
            ODocument otherVertex;
            Set edges = (Set)iVertex.field("out");
            if (edges != null) {
                for (ODocument edge : edges) {
                    if (edge == null) continue;
                    otherVertex = (ODocument)edge.field("in");
                    if (otherVertex != null && (otherEdges = (Set)otherVertex.field("in")) != null && otherEdges.remove(edge)) {
                        this.save(otherVertex);
                    }
                    this.delete(edge);
                }
                edges.clear();
                iVertex.field("out", edges);
            }
            if ((edges = (Set)iVertex.field("in")) != null) {
                for (ODocument edge : edges) {
                    if (edge == null) continue;
                    otherVertex = (ODocument)edge.field("out");
                    if (otherVertex != null && (otherEdges = (Set)otherVertex.field("out")) != null && otherEdges.remove(edge)) {
                        this.save(otherVertex);
                    }
                    this.delete(edge);
                }
                edges.clear();
                iVertex.field("in", edges);
            }
            this.delete(iVertex);
            this.commitBlock(safeMode);
        }
        catch (RuntimeException e) {
            this.rollbackBlock(safeMode);
            throw e;
        }
    }

    public void removeEdge(ODocument iEdge) {
        boolean safeMode = this.beginBlock();
        try {
            Set in;
            ODocument inVertex;
            Set out;
            ODocument outVertex = (ODocument)iEdge.field("out");
            if (outVertex != null && (out = (Set)outVertex.field("out")) != null) {
                out.remove(iEdge);
            }
            if ((inVertex = (ODocument)iEdge.field("in")) != null && (in = (Set)inVertex.field("in")) != null) {
                in.remove(iEdge);
            }
            this.delete(iEdge);
            if (outVertex != null) {
                this.save(outVertex);
            }
            if (inVertex != null) {
                this.save(inVertex);
            }
            this.commitBlock(safeMode);
        }
        catch (RuntimeException e) {
            this.rollbackBlock(safeMode);
            throw e;
        }
    }

    public ODocument createEdge(ODocument iSourceVertex, ODocument iDestVertex) {
        return this.createEdge(iSourceVertex, iDestVertex, null);
    }

    public ODocument createEdge(ODocument iOutVertex, ODocument iInVertex, String iClassName) {
        if (iOutVertex == null) {
            throw new IllegalArgumentException("iOutVertex is null");
        }
        if (iInVertex == null) {
            throw new IllegalArgumentException("iInVertex is null");
        }
        this.checkEdgeClass(iClassName);
        boolean safeMode = this.beginBlock();
        try {
            ODocument edge = new ODocument(iClassName != null ? iClassName : EDGE_CLASS_NAME).setOrdered(true);
            edge.field("out", iOutVertex);
            edge.field("in", iInVertex);
            OMVRBTreeRIDSet out = (OMVRBTreeRIDSet)iOutVertex.field("out");
            if (out == null) {
                out = new OMVRBTreeRIDSet(iOutVertex);
                iOutVertex.field("out", out);
            }
            out.add(edge);
            OMVRBTreeRIDSet in = (OMVRBTreeRIDSet)iInVertex.field("in");
            if (in == null) {
                in = new OMVRBTreeRIDSet(iInVertex);
                iInVertex.field("in", in);
            }
            in.add(edge);
            if (safeMode) {
                this.save(edge);
                this.commitBlock(safeMode);
            }
            return edge;
        }
        catch (RuntimeException e) {
            this.rollbackBlock(safeMode);
            throw e;
        }
    }

    public Set<ODocument> getEdgesBetweenVertexes(ODocument iVertex1, ODocument iVertex2) {
        return this.getEdgesBetweenVertexes(iVertex1, iVertex2, null, null);
    }

    public Set<ODocument> getEdgesBetweenVertexes(ODocument iVertex1, ODocument iVertex2, String[] iLabels) {
        return this.getEdgesBetweenVertexes(iVertex1, iVertex2, iLabels, null);
    }

    public Set<ODocument> getEdgesBetweenVertexes(ODocument iVertex1, ODocument iVertex2, String[] iLabels, String[] iClassNames) {
        HashSet<ODocument> result = new HashSet<ODocument>();
        if (iVertex1 != null && iVertex2 != null) {
            ODocument edge;
            for (OIdentifiable e : this.getOutEdges(iVertex1)) {
                edge = (ODocument)e;
                if (!this.checkEdge(edge, iLabels, iClassNames) || !((ODocument)edge.field("in")).equals(iVertex2)) continue;
                result.add(edge);
            }
            for (OIdentifiable e : this.getInEdges(iVertex1)) {
                edge = (ODocument)e;
                if (!this.checkEdge(edge, iLabels, iClassNames) || !((ODocument)edge.field("out")).equals(iVertex2)) continue;
                result.add(edge);
            }
        }
        return result;
    }

    public Set<OIdentifiable> getOutEdges(OIdentifiable iVertex) {
        return this.getOutEdges(iVertex, null);
    }

    public Set<OIdentifiable> getOutEdges(OIdentifiable iVertex, String iLabel) {
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        OMVRBTreeRIDSet set = (OMVRBTreeRIDSet)vertex.field("out");
        if (iLabel == null) {
            if (set != null) {
                return Collections.unmodifiableSet(set);
            }
            return Collections.emptySet();
        }
        OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
        if (set != null) {
            for (OIdentifiable item : set) {
                if (iLabel != null && !iLabel.equals(((ODocument)item).field(LABEL))) continue;
                result.add(item);
            }
        }
        return result;
    }

    public Set<OIdentifiable> getOutEdgesHavingProperties(OIdentifiable iVertex, Map<String, Object> iProperties) {
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        return this.filterEdgesByProperties((OMVRBTreeRIDSet)vertex.field("out"), iProperties);
    }

    public Set<OIdentifiable> getOutEdgesHavingProperties(OIdentifiable iVertex, Iterable<String> iProperties) {
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        return this.filterEdgesByProperties((OMVRBTreeRIDSet)vertex.field("out"), iProperties);
    }

    public Set<OIdentifiable> getInEdges(OIdentifiable iVertex) {
        return this.getInEdges(iVertex, null);
    }

    public Set<OIdentifiable> getInEdges(OIdentifiable iVertex, String iLabel) {
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        OMVRBTreeRIDSet set = (OMVRBTreeRIDSet)vertex.field("in");
        if (iLabel == null) {
            if (set != null) {
                return Collections.unmodifiableSet(set);
            }
            return Collections.emptySet();
        }
        OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
        if (set != null) {
            for (OIdentifiable item : set) {
                if (iLabel != null && !iLabel.equals(((ODocument)item).field(LABEL))) continue;
                result.add(item);
            }
        }
        return result;
    }

    public Set<OIdentifiable> getInEdgesHavingProperties(OIdentifiable iVertex, Iterable<String> iProperties) {
        ODocument vertex = (ODocument)iVertex.getRecord();
        this.checkVertexClass(vertex);
        return this.filterEdgesByProperties((OMVRBTreeRIDSet)vertex.field("in"), iProperties);
    }

    public Set<OIdentifiable> getInEdgesHavingProperties(ODocument iVertex, Map<String, Object> iProperties) {
        this.checkVertexClass(iVertex);
        return this.filterEdgesByProperties((OMVRBTreeRIDSet)iVertex.field("in"), iProperties);
    }

    public ODocument getInVertex(OIdentifiable iEdge) {
        ODocument e = (ODocument)iEdge.getRecord();
        this.checkEdgeClass(e);
        OIdentifiable v = (OIdentifiable)e.field("in");
        if (v != null && v instanceof ORID) {
            v = v.getRecord();
            boolean wasDirty = e.isDirty();
            e.field("in", v);
            if (!wasDirty) {
                e.unsetDirty();
            }
        }
        return (ODocument)v;
    }

    public ODocument getOutVertex(OIdentifiable iEdge) {
        ODocument e = (ODocument)iEdge.getRecord();
        this.checkEdgeClass(e);
        OIdentifiable v = (OIdentifiable)e.field("out");
        if (v != null && v instanceof ORID) {
            v = v.getRecord();
            boolean wasDirty = e.isDirty();
            e.field("out", v);
            if (!wasDirty) {
                e.unsetDirty();
            }
        }
        return (ODocument)v;
    }

    public ODocument getRoot(String iName) {
        return (ODocument)this.getDictionary().get(iName);
    }

    public ODocument getRoot(String iName, String iFetchPlan) {
        return (ODocument)this.getDictionary().get(iName, iFetchPlan);
    }

    public OGraphDatabase setRoot(String iName, ODocument iNode) {
        if (iNode == null) {
            this.getDictionary().remove(iName);
        } else {
            this.getDictionary().put(iName, iNode);
        }
        return this;
    }

    public OClass createVertexType(String iClassName) {
        return this.getMetadata().getSchema().createClass(iClassName, this.vertexBaseClass);
    }

    public OClass createVertexType(String iClassName, String iSuperClassName) {
        this.checkVertexClass(iSuperClassName);
        return this.getMetadata().getSchema().createClass(iClassName, this.getMetadata().getSchema().getClass(iSuperClassName));
    }

    public OClass createVertexType(String iClassName, OClass iSuperClass) {
        this.checkVertexClass(iSuperClass);
        return this.getMetadata().getSchema().createClass(iClassName, iSuperClass);
    }

    public OClass getVertexType(String iClassName) {
        return this.getMetadata().getSchema().getClass(iClassName);
    }

    public OClass createEdgeType(String iClassName) {
        return this.getMetadata().getSchema().createClass(iClassName, this.edgeBaseClass);
    }

    public OClass createEdgeType(String iClassName, String iSuperClassName) {
        this.checkEdgeClass(iSuperClassName);
        return this.getMetadata().getSchema().createClass(iClassName, this.getMetadata().getSchema().getClass(iSuperClassName));
    }

    public OClass createEdgeType(String iClassName, OClass iSuperClass) {
        this.checkEdgeClass(iSuperClass);
        return this.getMetadata().getSchema().createClass(iClassName, iSuperClass);
    }

    public OClass getEdgeType(String iClassName) {
        return this.getMetadata().getSchema().getClass(iClassName);
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public OClass getVertexBaseClass() {
        return this.vertexBaseClass;
    }

    public OClass getEdgeBaseClass() {
        return this.edgeBaseClass;
    }

    public Set<OIdentifiable> filterEdgesByProperties(OMVRBTreeRIDSet iEdges, Iterable<String> iPropertyNames) {
        if (iPropertyNames == null) {
            if (iEdges != null) {
                return Collections.unmodifiableSet(iEdges);
            }
            return Collections.emptySet();
        }
        OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
        if (iEdges != null) {
            for (OIdentifiable item : iEdges) {
                ODocument doc = (ODocument)item;
                for (String propName : iPropertyNames) {
                    if (!doc.containsField(propName)) continue;
                    result.add(item);
                }
            }
        }
        return result;
    }

    public Set<OIdentifiable> filterEdgesByProperties(OMVRBTreeRIDSet iEdges, Map<String, Object> iProperties) {
        if (iProperties == null) {
            if (iEdges != null) {
                return Collections.unmodifiableSet(iEdges);
            }
            return Collections.emptySet();
        }
        OMVRBTreeRIDSet result = new OMVRBTreeRIDSet();
        if (iEdges != null) {
            for (OIdentifiable item : iEdges) {
                ODocument doc = (ODocument)item;
                for (Map.Entry<String, Object> prop : iProperties.entrySet()) {
                    if (prop.getKey() == null || !doc.containsField(prop.getKey())) continue;
                    if (prop.getValue() == null) {
                        if (doc.field(prop.getKey()) != null) continue;
                        result.add(item);
                        continue;
                    }
                    if (!prop.getValue().equals(doc.field(prop.getKey()))) continue;
                    result.add(item);
                }
            }
        }
        return result;
    }

    public void checkVertexClass(ODocument iVertex) {
        if (this.useCustomTypes && !iVertex.getSchemaClass().isSubClassOf(this.vertexBaseClass)) {
            throw new IllegalArgumentException("The document received is not a vertex. Found class '" + iVertex.getSchemaClass() + "'");
        }
    }

    public void checkVertexClass(String iVertexTypeName) {
        if (this.useCustomTypes && iVertexTypeName != null) {
            OClass cls = this.getMetadata().getSchema().getClass(iVertexTypeName);
            if (cls == null) {
                throw new IllegalArgumentException("The class '" + iVertexTypeName + "' was not found");
            }
            if (!cls.isSubClassOf(this.vertexBaseClass)) {
                throw new IllegalArgumentException("The class '" + iVertexTypeName + "' does not extend the vertex type");
            }
        }
    }

    public void checkVertexClass(OClass iVertexType) {
        if (this.useCustomTypes && iVertexType != null && !iVertexType.isSubClassOf(this.vertexBaseClass)) {
            throw new IllegalArgumentException("The class '" + iVertexType + "' does not extend the vertex type");
        }
    }

    public void checkEdgeClass(ODocument iEdge) {
        if (this.useCustomTypes && !iEdge.getSchemaClass().isSubClassOf(this.edgeBaseClass)) {
            throw new IllegalArgumentException("The document received is not an edge. Found class '" + iEdge.getSchemaClass() + "'");
        }
    }

    public void checkEdgeClass(String iEdgeTypeName) {
        if (this.useCustomTypes && iEdgeTypeName != null) {
            OClass cls = this.getMetadata().getSchema().getClass(iEdgeTypeName);
            if (cls == null) {
                throw new IllegalArgumentException("The class '" + iEdgeTypeName + "' was not found");
            }
            if (!cls.isSubClassOf(this.edgeBaseClass)) {
                throw new IllegalArgumentException("The class '" + iEdgeTypeName + "' does not extend the edge type");
            }
        }
    }

    public void checkEdgeClass(OClass iEdgeType) {
        if (this.useCustomTypes && iEdgeType != null && !iEdgeType.isSubClassOf(this.edgeBaseClass)) {
            throw new IllegalArgumentException("The class '" + iEdgeType + "' does not extend the edge type");
        }
    }

    public boolean isUseCustomTypes() {
        return this.useCustomTypes;
    }

    public void setUseCustomTypes(boolean useCustomTypes) {
        this.useCustomTypes = useCustomTypes;
    }

    public boolean isVertex(ODocument iRecord) {
        return iRecord != null ? iRecord.getSchemaClass().isSubClassOf(this.vertexBaseClass) : false;
    }

    public boolean isEdge(ODocument iRecord) {
        return iRecord != null ? iRecord.getSchemaClass().isSubClassOf(this.edgeBaseClass) : false;
    }

    protected boolean beginBlock() {
        if (this.safeMode && !(this.getTransaction() instanceof OTransactionNoTx)) {
            this.begin();
            return true;
        }
        return false;
    }

    protected void commitBlock(boolean iOpenTxInSafeMode) {
        if (iOpenTxInSafeMode) {
            this.commit();
        }
    }

    protected void rollbackBlock(boolean iOpenTxInSafeMode) {
        if (iOpenTxInSafeMode) {
            this.rollback();
        }
    }

    protected boolean checkEdge(ODocument iEdge, String[] iLabels, String[] iClassNames) {
        String c;
        int n;
        int n2;
        String[] stringArray;
        boolean good = true;
        if (iClassNames != null) {
            good = false;
            stringArray = iClassNames;
            n2 = iClassNames.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                if (c.equals(iEdge.getClassName())) {
                    good = true;
                    break;
                }
                ++n;
            }
        }
        if (good && iLabels != null) {
            good = false;
            stringArray = iLabels;
            n2 = iLabels.length;
            n = 0;
            while (n < n2) {
                c = stringArray[n];
                if (c.equals(iEdge.field(LABEL))) {
                    good = true;
                    break;
                }
                ++n;
            }
        }
        return good;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void checkForGraphSchema() {
        this.getMetadata().getSchema().getOrCreateClass("ORIDs");
        this.vertexBaseClass = this.getMetadata().getSchema().getClass(VERTEX_CLASS_NAME);
        this.edgeBaseClass = this.getMetadata().getSchema().getClass(EDGE_CLASS_NAME);
        if (this.vertexBaseClass == null) {
            this.vertexBaseClass = this.getMetadata().getSchema().createClass(VERTEX_CLASS_NAME);
            this.vertexBaseClass.setShortName("V");
            this.vertexBaseClass.setOverSize(2.0f);
            if (this.edgeBaseClass == null) {
                this.edgeBaseClass = this.getMetadata().getSchema().createClass(EDGE_CLASS_NAME);
                this.edgeBaseClass.setShortName("E");
            }
            this.vertexBaseClass.createProperty("in", OType.LINKSET, this.edgeBaseClass);
            this.vertexBaseClass.createProperty("out", OType.LINKSET, this.edgeBaseClass);
            this.edgeBaseClass.createProperty("in", OType.LINK, this.vertexBaseClass);
            this.edgeBaseClass.createProperty("out", OType.LINK, this.vertexBaseClass);
        } else if (this.vertexBaseClass.existsProperty(VERTEX_FIELD_OUT_EDGES)) {
            OGraphDatabaseMigration.migrate(this);
        }
    }
}

