/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OGraphDatabaseMigration {
    public static void main(String[] iArgs) {
        if (iArgs.length < 1) {
            System.err.println("Error: wrong parameters. Syntax: <database-url> [<user> <password>]");
            return;
        }
        String dbURL = iArgs[0];
        String user = iArgs.length > 1 ? iArgs[1] : null;
        String password = iArgs.length > 2 ? iArgs[2] : null;
        OGraphDatabaseMigration.migrate(dbURL, user, password);
    }

    public static void migrate(String dbURL, String user, String password) {
        OGraphDatabaseMigration.migrate((OGraphDatabase)new OGraphDatabase(dbURL).open(user, password));
    }

    public static void migrate(OGraphDatabase db) {
        System.out.println("Migration of database started...");
        long start = System.currentTimeMillis();
        try {
            if (db.getVertexBaseClass().existsProperty("outEdges")) {
                db.getVertexBaseClass().dropProperty("outEdges");
                db.getVertexBaseClass().createProperty("out", OType.LINKSET, db.getEdgeBaseClass());
            }
            if (db.getVertexBaseClass().existsProperty("inEdges")) {
                db.getVertexBaseClass().dropProperty("inEdges");
                db.getVertexBaseClass().createProperty("in", OType.LINKSET, db.getEdgeBaseClass());
            }
            long convertedVertices = 0L;
            for (ODocument doc : db.browseVertices()) {
                boolean converted = false;
                if (doc.containsField("inEdges")) {
                    doc.field("in", doc.field("inEdges"));
                    doc.removeField("inEdges");
                    converted = true;
                }
                if (doc.containsField("outEdges")) {
                    doc.field("out", doc.field("outEdges"));
                    doc.removeField("outEdges");
                    converted = true;
                }
                if (!converted) continue;
                doc.save();
                ++convertedVertices;
            }
            System.out.println(String.format("Migration complete in %d seconds. Vertices converted: %d", (System.currentTimeMillis() - start) / 1000L, convertedVertices));
        }
        finally {
            db.close();
        }
    }
}

