/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODataSegmentStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.ODefaultDataSegmentStrategy;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.hook.OHookThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.OUserTrigger;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabaseRecordAbstract
extends ODatabaseWrapperAbstract<ODatabaseRaw>
implements ODatabaseRecord {
    private OMetadata metadata;
    private OUser user;
    private static final String DEF_RECORD_FORMAT = "csv";
    private byte recordType;
    private String recordFormat;
    private Set<ORecordHook> hooks = new HashSet<ORecordHook>();
    private final Set<ORecordHook> unmodifiableHooks;
    private boolean retainRecords = true;
    private OLevel1RecordCache level1Cache;
    private boolean mvcc;
    private boolean validation;
    private ODictionary<ORecordInternal<?>> dictionary;
    private ODataSegmentStrategy dataSegmentStrategy = new ODefaultDataSegmentStrategy();

    public ODatabaseRecordAbstract(String iURL, byte iRecordType) {
        super(new ODatabaseRaw(iURL));
        ((ODatabaseRaw)this.underlying).setOwner(this);
        this.unmodifiableHooks = Collections.unmodifiableSet(this.hooks);
        this.databaseOwner = this;
        this.recordType = iRecordType;
        this.level1Cache = new OLevel1RecordCache();
        this.mvcc = OGlobalConfiguration.DB_MVCC.getValueAsBoolean();
        this.validation = OGlobalConfiguration.DB_VALIDATION.getValueAsBoolean();
        this.setCurrentDatabaseinThreadLocal();
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.open(iUserName, iUserPassword);
            this.level1Cache.startup();
            this.metadata = new OMetadata();
            this.metadata.load();
            this.recordFormat = DEF_RECORD_FORMAT;
            if (this.getStorage() instanceof OStorageEmbedded) {
                Set<ORole> roles;
                this.user = this.getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
                if (this.user != null && ((roles = this.user.getRoles()) == null || roles.isEmpty() || roles.iterator().next() == null)) {
                    for (ODatabaseListener l : ((ODatabaseRaw)this.underlying).getListeners()) {
                        if (!l.onCorruptionRepairDatabase(this, "Security metadata is broken: current user '" + this.user.getName() + "' has no roles defined", "The 'admin' user will be reinstalled with default role ('admin') and password 'admin'")) continue;
                        this.user = null;
                        this.user = this.metadata.getSecurity().repair();
                        break;
                    }
                }
                this.registerHook(new OUserTrigger());
                this.registerHook(new OClassIndexManager());
            } else {
                this.user = new OUser(iUserName, OUser.encryptPassword(iUserPassword)).addRole(new ORole("passthrough", null, ORole.ALLOW_MODES.ALLOW_ALL_BUT));
            }
            this.checkSecurity("database", ORole.PERMISSION_READ);
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
        }
        catch (OException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create() {
        this.setCurrentDatabaseinThreadLocal();
        try {
            super.create();
            this.level1Cache.startup();
            this.getStorage().getConfiguration().update();
            if (this.getStorage() instanceof OStorageEmbedded) {
                this.registerHook(new OUserTrigger());
                this.registerHook(new OClassIndexManager());
            }
            this.metadata = new OMetadata();
            this.metadata.create();
            this.user = this.getMetadata().getSecurity().getUser("admin");
            if (!this.metadata.getSchema().existsClass("ORIDs")) {
                this.metadata.getSchema().createClass("ORIDs");
            }
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot create database", e);
        }
        return (DB)this;
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkSecurity("database", ORole.PERMISSION_DELETE);
        super.drop();
    }

    @Override
    public void close() {
        this.setCurrentDatabaseinThreadLocal();
        if (this.metadata != null) {
            this.metadata.close();
            this.metadata = null;
        }
        super.close();
        this.hooks.clear();
        this.dictionary = null;
        this.user = null;
        this.level1Cache.shutdown();
    }

    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = this.metadata.getIndexManager().getDictionary();
        }
        return this.dictionary;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET getRecord(OIdentifiable iIdentifiable) {
        if (iIdentifiable instanceof ORecord) {
            return (RET)((ORecordInternal)iIdentifiable);
        }
        return (RET)this.load(iIdentifiable.getIdentity());
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return this.load(iRecord, (String)null);
    }

    @Override
    public void reload() {
        this.metadata.reload();
        super.reload();
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, null, true);
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, true);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return this.executeReadRecord((ORecordId)iRecordId, null, null, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.executeReadRecord((ORecordId)iRecordId, null, iFetchPlan, iIgnoreCache);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent) {
        return this.executeSaveRecord(iContent, null, iContent.getVersion(), iContent.getRecordType(), ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return this.executeSaveRecord(iContent, null, iContent.getVersion(), iContent.getRecordType(), iMode, iCallback);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName) {
        return this.executeSaveRecord(iContent, iClusterName, iContent.getVersion(), iContent.getRecordType(), ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return this.executeSaveRecord(iContent, iClusterName, iContent.getVersion(), iContent.getRecordType(), iMode, iCallback);
    }

    public ODatabaseRecord delete(ORID iRecord) {
        this.executeDeleteRecord(iRecord, -1, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
        return this;
    }

    public ODatabaseRecord delete(ORID iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.executeDeleteRecord(iRecord, -1, true, iMode);
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord) {
        this.executeDeleteRecord(iRecord, -1, true, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.executeDeleteRecord(iRecord, -1, true, iMode);
        return this;
    }

    @Override
    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iClass) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId);
    }

    public ORecordIteratorCluster<?> browseCluster(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        int clusterId = this.getClusterIdByName(iClusterName);
        return new ORecordIteratorCluster(this, this, clusterId);
    }

    @Override
    public OCommandRequest command(OCommandRequest iCommand) {
        this.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.setCurrentDatabaseinThreadLocal();
        OCommandRequestInternal command = (OCommandRequestInternal)iCommand;
        try {
            command.reset();
            return command;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on command execution", e);
        }
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<? extends Object> iCommand, Object ... iArgs) {
        this.setCurrentDatabaseinThreadLocal();
        iCommand.reset();
        return (RET)((List)iCommand.execute(iArgs));
    }

    @Override
    public byte getRecordType() {
        return this.recordType;
    }

    @Override
    public <RET> RET newInstance() {
        return (RET)Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        int i = 0;
        while (i < iClusterIds.length) {
            String name = this.getClusterNameById(iClusterIds[i]);
            this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)name);
            ++i;
        }
        return super.countClusterElements(iClusterIds);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        String name = this.getClusterNameById(iClusterId);
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)name);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(name);
    }

    @Override
    public long countClusterElements(String iClusterName) {
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        this.setCurrentDatabaseinThreadLocal();
        return super.countClusterElements(iClusterName);
    }

    @Override
    public OMetadata getMetadata() {
        this.checkOpeness();
        return this.metadata;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResource, int iOperation) {
        if (this.user != null) {
            try {
                this.user.allow(iResource, iOperation);
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', operation '%s'", this.getUser(), iResource, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                Object[] objectArray = iResourcesSpecific;
                int n = iResourcesSpecific.length;
                int n2 = 0;
                while (n2 < n) {
                    Object target = objectArray[n2];
                    if (target != null) {
                        keyBuffer.setLength(0);
                        keyBuffer.append(iResourceGeneric);
                        keyBuffer.append('.');
                        keyBuffer.append(target.toString());
                        String key = keyBuffer.toString();
                        if (this.user.isRuleDefined(key)) {
                            ruleFound = true;
                            this.user.allow(key, iOperation);
                        }
                    }
                    ++n2;
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target(s) '%s', operation '%s'", this.getUser(), iResourceGeneric, Arrays.toString(iResourcesSpecific), iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseRecord> DB checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        if (this.user != null) {
            try {
                StringBuilder keyBuffer = new StringBuilder();
                boolean ruleFound = false;
                if (iResourceSpecific != null) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append(iResourceSpecific.toString());
                    String key = keyBuffer.toString();
                    if (this.user.isRuleDefined(key)) {
                        ruleFound = true;
                        this.user.allow(key, iOperation);
                    }
                }
                if (!ruleFound) {
                    keyBuffer.setLength(0);
                    keyBuffer.append(iResourceGeneric);
                    keyBuffer.append('.');
                    keyBuffer.append("*");
                    this.user.allow(keyBuffer.toString(), iOperation);
                }
            }
            catch (OSecurityAccessException e) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "[checkSecurity] User '%s' tried to access to the reserved resource '%s', target '%s', operation '%s'", this.getUser(), iResourceGeneric, iResourceSpecific, iOperation);
                }
                throw e;
            }
        }
        return (DB)this;
    }

    public <RET extends ORecordInternal<?>> RET executeReadRecord(ORecordId iRid, ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        ORawBuffer recordBuffer;
        block12: {
            ORecordInternal<?> record;
            block11: {
                this.checkOpeness();
                this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)this.getClusterNameById(iRid.getClusterId()));
                record = this.getTransaction().getRecord(iRid);
                if (record != OTransactionRealAbstract.DELETED_RECORD) break block11;
                return null;
            }
            if (record == null && !iIgnoreCache) {
                record = this.getLevel1Cache().findRecord(iRid);
            }
            if (record != null) {
                if (iRecord != null) {
                    iRecord.fromStream(record.toStream());
                    record = iRecord;
                }
                OFetchHelper.checkFetchPlanValid(iFetchPlan);
                this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, record);
                if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record.reload();
                }
                this.callbackHooks(ORecordHook.TYPE.AFTER_READ, record);
                return (RET)record;
            }
            recordBuffer = ((ODatabaseRaw)this.underlying).read(iRid, iFetchPlan, iIgnoreCache);
            if (recordBuffer != null) break block12;
            return null;
        }
        try {
            if (iRecord == null || iRecord.getRecordType() != recordBuffer.recordType) {
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(recordBuffer.recordType);
            }
            iRecord.fill(iRid, recordBuffer.version, recordBuffer.buffer, false);
            this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord);
            iRecord.fromStream(recordBuffer.buffer);
            iRecord.setInternalStatus(ORecordElement.STATUS.LOADED);
            this.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
            if (!iIgnoreCache) {
                this.getLevel1Cache().updateRecord(iRecord);
            }
            return (RET)iRecord;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on retrieving record " + iRid, e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET extends ORecordInternal<?>> RET executeSaveRecord(ORecordInternal<?> iRecord, String iClusterName, int iVersion, byte iRecordType, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        this.checkOpeness();
        if (!iRecord.isDirty()) {
            return (RET)iRecord;
        }
        ORecordId rid = (ORecordId)iRecord.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        this.setCurrentDatabaseinThreadLocal();
        try {
            boolean wasNew = rid.isNew();
            byte[] stream = iRecord.toStream();
            boolean isNew = rid.isNew();
            if (isNew) {
                iRecord.onBeforeIdentityChanged(rid);
            } else if (stream == null || stream.length == 0) {
                return (RET)iRecord;
            }
            if (isNew && rid.clusterId < 0) {
                int n = rid.clusterId = iClusterName != null ? this.getClusterIdByName(iClusterName) : this.getDefaultClusterId();
            }
            if (rid.clusterId > -1 && iClusterName == null) {
                iClusterName = this.getClusterNameById(rid.clusterId);
            }
            if (stream != null && stream.length > 0) {
                if (wasNew) {
                    this.checkSecurity("database.cluster", ORole.PERMISSION_CREATE, (Object)iClusterName);
                    if (this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord)) {
                        stream = iRecord.toStream();
                    }
                } else {
                    this.checkSecurity("database.cluster", ORole.PERMISSION_UPDATE, (Object)iClusterName);
                    if (this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord)) {
                        stream = iRecord.toStream();
                    }
                }
                if (!iRecord.isDirty()) {
                    this.getLevel1Cache().updateRecord(iRecord);
                    return (RET)iRecord;
                }
            }
            int realVersion = iVersion == -1 ? -1 : iRecord.getVersion();
            int dataSegmentId = this.dataSegmentStrategy.assignDataSegmentId(this, iRecord);
            int version = ((ODatabaseRaw)this.underlying).save(dataSegmentId, rid, stream, realVersion, iRecord.getRecordType(), iMode.ordinal(), iCallback);
            if (isNew) {
                ((ORecordId)iRecord.getIdentity()).copyFrom(rid);
                iRecord.onAfterIdentityChanged(iRecord);
                iRecord.fill(rid, version, stream, stream == null || stream.length == 0);
            } else {
                iRecord.fill(rid, version, stream, stream == null || stream.length == 0);
            }
            this.callbackHooks(wasNew ? ORecordHook.TYPE.AFTER_CREATE : ORecordHook.TYPE.AFTER_UPDATE, iRecord);
            if (stream != null && stream.length > 0) {
                this.getLevel1Cache().updateRecord(iRecord);
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on saving record in cluster #" + iRecord.getIdentity().getClusterId(), t);
        }
        return (RET)iRecord;
    }

    public void executeDeleteRecord(OIdentifiable iRecord, int iVersion, boolean iRequired, ODatabaseComplex.OPERATION_MODE iMode) {
        this.checkOpeness();
        ORecordId rid = (ORecordId)iRecord.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        this.checkSecurity("database.cluster", ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.clusterId));
        this.setCurrentDatabaseinThreadLocal();
        try {
            Object rec = iRecord.getRecord();
            this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
            ((ODatabaseRaw)this.underlying).delete(rid, iVersion, iRequired, (byte)iMode.ordinal());
            this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
            this.getLevel1Cache().deleteRecord(rid);
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on deleting record in cluster #" + iRecord.getIdentity().getClusterId(), t);
        }
    }

    @Override
    public ODatabaseComplex<?> getDatabaseOwner() {
        ODatabaseComplex<?> current = this.databaseOwner;
        while (current != null && current != this && current.getDatabaseOwner() != current) {
            current = current.getDatabaseOwner();
        }
        return current;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> setDatabaseOwner(ODatabaseComplex<?> iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public boolean isRetainRecords() {
        return this.retainRecords;
    }

    @Override
    public ODatabaseRecord setRetainRecords(boolean retainRecords) {
        this.retainRecords = retainRecords;
        return this;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        String cmd = String.format("alter database status %s", status.toString());
        this.command(new OCommandSQL(cmd)).execute(new Object[0]);
        return (DB)this;
    }

    public void setStatusInternal(ODatabase.STATUS status) {
        ((ODatabaseRaw)this.underlying).setStatus(status);
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case STATUS: {
                this.setStatusInternal(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
            }
        }
    }

    @Override
    public OUser getUser() {
        return this.user;
    }

    @Override
    public boolean isMVCC() {
        return this.mvcc;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB setMVCC(boolean mvcc) {
        this.mvcc = mvcc;
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB registerHook(ORecordHook iHookImpl) {
        this.hooks.add(iHookImpl);
        return (DB)this;
    }

    @Override
    public <DB extends ODatabaseComplex<?>> DB unregisterHook(ORecordHook iHookImpl) {
        this.hooks.remove(iHookImpl);
        return (DB)this;
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        return this.level1Cache;
    }

    @Override
    public Set<ORecordHook> getHooks() {
        return this.unmodifiableHooks;
    }

    @Override
    public boolean callbackHooks(ORecordHook.TYPE iType, OIdentifiable id) {
        if (!OHookThreadLocal.INSTANCE.push(id)) {
            return false;
        }
        try {
            Object rec = id.getRecord();
            if (rec == null) {
                return false;
            }
            boolean recordChanged = false;
            for (ORecordHook hook : this.hooks) {
                if (!hook.onTrigger(iType, (ORecord<?>)rec)) continue;
                recordChanged = true;
            }
            boolean bl = recordChanged;
            return bl;
        }
        finally {
            OHookThreadLocal.INSTANCE.pop(id);
        }
    }

    protected ORecordSerializer resolveFormat(Object iObject) {
        return ORecordSerializerFactory.instance().getFormatForObject(iObject, this.recordFormat);
    }

    @Override
    protected void checkOpeness() {
        if (this.isClosed()) {
            throw new ODatabaseException("Database '" + this.getURL() + "' is closed");
        }
    }

    protected void setCurrentDatabaseinThreadLocal() {
        ODatabaseRecordThreadLocal.INSTANCE.set(this);
    }

    @Override
    public boolean isValidationEnabled() {
        return !this.getStatus().equals((Object)ODatabase.STATUS.IMPORTING) && this.validation;
    }

    @Override
    public <DB extends ODatabaseRecord> DB setValidationEnabled(boolean iEnabled) {
        this.validation = iEnabled;
        return (DB)this;
    }

    @Override
    public ODataSegmentStrategy getDataSegmentStrategy() {
        return this.dataSegmentStrategy;
    }

    @Override
    public void setDataSegmentStrategy(ODataSegmentStrategy dataSegmentStrategy) {
        this.dataSegmentStrategy = dataSegmentStrategy;
    }
}

