/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OLazyIteratorListWrapper;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.ORecordLazyListener;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordMultiValueHelper;
import com.orientechnologies.orient.core.db.record.ORecordTrackedList;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordLazyList
extends ORecordTrackedList
implements ORecordLazyMultiValue {
    protected ORecordLazyListener listener;
    protected final byte recordType;
    protected ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
    protected StringBuilder stream;
    protected boolean autoConvertToRecord = true;
    protected boolean marshalling = false;
    protected boolean ridOnly = false;

    public ORecordLazyList() {
        super((ORecordInternal<?>)null);
        this.recordType = (byte)100;
    }

    public ORecordLazyList(ODocument iSourceRecord) {
        super(iSourceRecord);
        if (iSourceRecord != null) {
            this.recordType = iSourceRecord.getRecordType();
            if (!iSourceRecord.isLazyLoad()) {
                this.autoConvertToRecord = false;
            }
        } else {
            this.recordType = (byte)100;
        }
    }

    public ORecordLazyList(ODocument iSourceRecord, Collection<? extends OIdentifiable> iOrigin) {
        this(iSourceRecord);
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        Iterator<? extends OIdentifiable> it = c instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)((Object)c)).rawIterator() : c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (this.stream == null) {
            return super.isEmpty();
        }
        return this.stream.length() == 0;
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        this.lazyLoad(false);
        OLazyIterator<OIdentifiable> subIterator = new OLazyIterator<OIdentifiable>(){
            private int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos < ORecordLazyList.this.size() - 1;
            }

            @Override
            public OIdentifiable next() {
                return ORecordLazyList.this.rawGet(++this.pos);
            }

            @Override
            public void remove() {
                ORecordLazyList.this.remove(this.pos);
            }

            @Override
            public OIdentifiable update(OIdentifiable iValue) {
                return ORecordLazyList.this.set(this.pos, iValue);
            }
        };
        return new OLazyRecordIterator(this.sourceRecord, (Iterator<? extends OIdentifiable>)subIterator, false);
    }

    public OIdentifiable rawGet(int index) {
        this.lazyLoad(false);
        return (OIdentifiable)super.get(index);
    }

    @Override
    public OLazyIterator<OIdentifiable> iterator() {
        this.lazyLoad(false);
        return new OLazyRecordIterator(this.sourceRecord, new OLazyIteratorListWrapper(super.listIterator()), this.autoConvertToRecord);
    }

    @Override
    public boolean contains(Object o) {
        if (OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean() && this.getStreamedContent() != null) {
            return this.getStreamedContent().indexOf(((OIdentifiable)o).getIdentity().toString()) > -1;
        }
        this.lazyLoad(false);
        return super.contains(o);
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (e != null) {
            if ((this.ridOnly || this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean()) && !e.getIdentity().isNew() && e instanceof ODocument && !((ODocument)e).isDirty()) {
                e = e.getIdentity();
            } else {
                this.contentType = ORecordMultiValueHelper.updateContentType(this.contentType, e);
            }
        }
        this.lazyLoad(true);
        return super.add(e);
    }

    @Override
    public void add(int index, OIdentifiable e) {
        if (e != null) {
            if ((this.ridOnly || this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean()) && !e.getIdentity().isNew() && e instanceof ODocument && !((ODocument)e).isDirty()) {
                e = e.getIdentity();
            } else {
                this.contentType = ORecordMultiValueHelper.updateContentType(this.contentType, e);
            }
        }
        this.lazyLoad(true);
        super.add(index, e);
    }

    @Override
    public OIdentifiable set(int index, OIdentifiable e) {
        this.lazyLoad(true);
        if (e != null) {
            if ((this.ridOnly || this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean()) && !e.getIdentity().isNew() && e instanceof ODocument && !((ODocument)e).isDirty()) {
                e = e.getIdentity();
            } else {
                this.contentType = ORecordMultiValueHelper.updateContentType(this.contentType, e);
            }
        }
        return super.set(index, e);
    }

    @Override
    public OIdentifiable get(int index) {
        this.lazyLoad(false);
        if (this.autoConvertToRecord) {
            this.convertLink2Record(index);
        }
        return (OIdentifiable)super.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.lazyLoad(false);
        return super.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.lazyLoad(false);
        return super.lastIndexOf(o);
    }

    @Override
    public OIdentifiable remove(int iIndex) {
        this.lazyLoad(true);
        return (OIdentifiable)super.remove(iIndex);
    }

    @Override
    public boolean remove(Object iElement) {
        boolean result;
        if (OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean() && this.getStreamedContent() != null) {
            String rid;
            StringBuilder stream = this.getStreamedContent();
            int pos = stream.indexOf(rid = ((OIdentifiable)iElement).getIdentity().toString());
            if (pos > -1) {
                this.fireCollectionChangedEvent(new OMultiValueChangeEvent<Integer, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, pos, null, (OIdentifiable)iElement));
                if (pos > 0) {
                    --pos;
                }
                stream.delete(pos, pos + rid.length() + 1);
                if (stream.length() == 0) {
                    this.setStreamedContent(null);
                }
                result = true;
            } else {
                result = false;
            }
        } else {
            this.lazyLoad(true);
            result = super.remove(iElement);
        }
        if (this.isEmpty()) {
            this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
        }
        return result;
    }

    @Override
    public void clear() {
        this.lazyLoad(true);
        super.clear();
        this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.EMPTY;
        this.stream = null;
    }

    @Override
    public int size() {
        this.lazyLoad(false);
        return super.size();
    }

    @Override
    public <RET> RET setDirty() {
        if (!this.marshalling) {
            return super.setDirty();
        }
        return (RET)this;
    }

    @Override
    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<Integer, OIdentifiable> event) {
        if (!this.marshalling) {
            super.fireCollectionChangedEvent(event);
        }
    }

    @Override
    public Object[] toArray() {
        this.convertLinks2Records();
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.lazyLoad(false);
        this.convertLinks2Records();
        return super.toArray(a);
    }

    @Override
    public void convertLinks2Records() {
        this.lazyLoad(false);
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS || !this.autoConvertToRecord) {
            return;
        }
        int i = 0;
        while (i < this.size()) {
            try {
                this.convertLink2Record(i);
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
            ++i;
        }
        this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS;
    }

    @Override
    public boolean convertRecords2Links() {
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS || this.sourceRecord == null) {
            return true;
        }
        boolean allConverted = true;
        int i = 0;
        while (i < super.size()) {
            try {
                if (!this.convertRecord2Link(i)) {
                    allConverted = false;
                }
            }
            catch (ORecordNotFoundException oRecordNotFoundException) {
                // empty catch block
            }
            ++i;
        }
        if (allConverted) {
            this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS;
        }
        return allConverted;
    }

    private void convertLink2Record(int iIndex) {
        if (this.ridOnly || !this.autoConvertToRecord) {
            return;
        }
        OIdentifiable o = (OIdentifiable)super.get(iIndex);
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RECORDS && !o.getIdentity().isNew()) {
            return;
        }
        if (o != null && o instanceof ORecordId) {
            ORecordId rid = (ORecordId)o;
            this.marshalling = true;
            try {
                try {
                    super.set(iIndex, rid.getRecord());
                }
                catch (ORecordNotFoundException oRecordNotFoundException) {
                    this.marshalling = false;
                }
            }
            finally {
                this.marshalling = false;
            }
        }
    }

    private boolean convertRecord2Link(int iIndex) {
        if (this.contentType == ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS) {
            return true;
        }
        Object o = super.get(iIndex);
        if (o != null) {
            if (o instanceof ORecord && !((ORecord)o).isDirty()) {
                this.marshalling = true;
                try {
                    super.set(iIndex, ((ORecord)o).getIdentity());
                    return true;
                }
                catch (ORecordNotFoundException oRecordNotFoundException) {
                }
                finally {
                    this.marshalling = false;
                }
            } else if (o instanceof ORID) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToDocument) {
        this.autoConvertToRecord = convertToDocument;
    }

    @Override
    public String toString() {
        if (this.stream == null) {
            return ORecordMultiValueHelper.toString(this);
        }
        return "[NOT LOADED: " + this.stream + ']';
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public ORecordLazyList copy(ODocument iSourceRecord) {
        ORecordLazyList copy = new ORecordLazyList(iSourceRecord);
        copy.contentType = this.contentType;
        copy.stream = this.stream;
        copy.autoConvertToRecord = this.autoConvertToRecord;
        int tot = super.size();
        int i = 0;
        while (i < tot) {
            copy.add(this.rawGet(i));
            ++i;
        }
        return copy;
    }

    public Iterator<OIdentifiable> newItemsIterator() {
        return null;
    }

    public ORecordLazyList setStreamedContent(StringBuilder iStream) {
        if (iStream == null || iStream.length() == 0) {
            this.stream = null;
        } else {
            this.stream = iStream;
            int prevModCount = this.modCount;
            this.reset();
            this.modCount = prevModCount;
        }
        this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS;
        return this;
    }

    public StringBuilder getStreamedContent() {
        return this.stream;
    }

    public ORecordLazyListener getListener() {
        return this.listener;
    }

    public ORecordLazyList setListener(ORecordLazyListener listener) {
        this.listener = listener;
        return this;
    }

    public boolean lazyLoad(boolean iInvalidateStream) {
        if (this.stream == null) {
            return false;
        }
        this.marshalling = true;
        int currentModCount = this.modCount;
        List<String> items = OStringSerializerHelper.smartSplit(this.stream.toString(), ',', new char[0]);
        for (String item : items) {
            if (item.length() == 0) continue;
            super.add(new ORecordId(item));
        }
        this.modCount = currentModCount;
        this.marshalling = false;
        this.stream = null;
        this.contentType = ORecordMultiValueHelper.MULTIVALUE_CONTENT_TYPE.ALL_RIDS;
        if (this.listener != null) {
            this.listener.onLazyLoad();
        }
        return true;
    }

    public boolean isRidOnly() {
        return this.ridOnly;
    }

    public ORecordLazyList setRidOnly(boolean ridOnly) {
        this.ridOnly = ridOnly;
        return this;
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }
}

