/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OLazyRecordMultiIterator;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyListener;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordLazySet
implements Set<OIdentifiable>,
ORecordLazyMultiValue,
ORecordElement,
ORecordLazyListener {
    public static final ORecordLazySet EMPTY_SET = new ORecordLazySet();
    private static final Object NEWMAP_VALUE = new Object();
    protected final ORecordLazyList delegate;
    protected IdentityHashMap<ORecord<?>, Object> newItems;
    protected boolean sorted = true;

    public ORecordLazySet() {
        this.delegate = new ORecordLazyList().setListener(this);
    }

    public ORecordLazySet(ODocument iSourceRecord) {
        this.delegate = new ORecordLazyList(iSourceRecord).setListener(this);
    }

    public ORecordLazySet(ODocument iSourceRecord, ORecordLazySet iSource) {
        this.delegate = iSource.delegate.copy(iSourceRecord).setListener(this);
        this.sorted = iSource.sorted;
        if (iSource.newItems != null) {
            this.newItems = new IdentityHashMap(iSource.newItems);
        }
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
        this.delegate.onBeforeIdentityChanged(iRID);
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
        this.delegate.onAfterIdentityChanged(iRecord);
    }

    @Override
    public <RET> RET setDirty() {
        this.delegate.setDirty();
        return (RET)this;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        if (this.hasNewItems()) {
            this.lazyLoad(false);
            return new OLazyRecordMultiIterator(this.delegate.sourceRecord, new Object[]{this.delegate.iterator(), this.newItems.keySet().iterator()}, this.delegate.autoConvertToRecord);
        }
        return this.delegate.iterator();
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        if (this.hasNewItems()) {
            this.lazyLoad(false);
            return new OLazyRecordMultiIterator(this.delegate.sourceRecord, new Object[]{this.delegate.rawIterator(), this.newItems.keySet().iterator()}, false);
        }
        return this.delegate.rawIterator();
    }

    public Iterator<OIdentifiable> newItemsIterator() {
        if (this.hasNewItems()) {
            return new OLazyRecordIterator(this.delegate.sourceRecord, this.newItems.keySet().iterator(), false);
        }
        return null;
    }

    @Override
    public boolean convertRecords2Links() {
        this.savedAllNewItems();
        return this.delegate.convertRecords2Links();
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.delegate.isAutoConvertToRecord();
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.delegate.setAutoConvertToRecord(convertToRecord);
    }

    @Override
    public int size() {
        int tot = this.delegate.size();
        if (this.newItems != null) {
            tot += this.newItems.size();
        }
        return tot;
    }

    @Override
    public boolean isEmpty() {
        boolean empty = this.delegate.isEmpty();
        if (empty && this.newItems != null) {
            empty = this.newItems.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean contains(Object o) {
        boolean found;
        OIdentifiable obj = (OIdentifiable)o;
        if (OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean() && this.getStreamedContent() != null) {
            found = this.getStreamedContent().indexOf(obj.getIdentity().toString()) > -1;
        } else {
            this.lazyLoad(false);
            boolean bl = found = this.indexOf((OIdentifiable)o) > -1;
        }
        if (!found && this.hasNewItems()) {
            found = this.newItems.containsKey(o);
        }
        return found;
    }

    @Override
    public Object[] toArray() {
        Object[] result = this.delegate.toArray();
        if (this.newItems != null && !this.newItems.isEmpty()) {
            int start = result.length;
            result = Arrays.copyOf(result, start + this.newItems.size());
            for (ORecord<?> r : this.newItems.keySet()) {
                result[start++] = r;
            }
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] result = this.delegate.toArray(a);
        if (this.newItems != null && !this.newItems.isEmpty()) {
            int start = result.length;
            result = Arrays.copyOf(result, start + this.newItems.size());
            for (ORecord<?> r : this.newItems.keySet()) {
                result[start++] = r;
            }
        }
        return result;
    }

    @Override
    public boolean add(OIdentifiable e) {
        if (e.getIdentity().isNew()) {
            Object record = e.getRecord();
            if (this.newItems == null) {
                this.newItems = new IdentityHashMap();
            } else if (this.newItems.containsKey(record)) {
                return false;
            }
            this.newItems.put((ORecord<?>)record, NEWMAP_VALUE);
            this.setDirty();
            return true;
        }
        if (OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean() && this.getStreamedContent() != null) {
            String ridString = e.getIdentity().toString();
            StringBuilder buffer = this.getStreamedContent();
            if (buffer.indexOf(ridString) < 0) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                e.getIdentity().toString(buffer);
                this.setDirty();
                return true;
            }
            return false;
        }
        int pos = this.indexOf(e);
        if (pos < 0) {
            this.delegate.add(pos * -1 - 1, e);
            return true;
        }
        return false;
    }

    public int indexOf(OIdentifiable iElement) {
        if (this.delegate.isEmpty()) {
            return -1;
        }
        boolean prevConvert = this.delegate.isAutoConvertToRecord();
        if (prevConvert) {
            this.delegate.setAutoConvertToRecord(false);
        }
        int pos = Collections.binarySearch(this.delegate, iElement);
        if (prevConvert) {
            this.delegate.setAutoConvertToRecord(true);
        }
        return pos;
    }

    @Override
    public boolean remove(Object o) {
        if (OGlobalConfiguration.LAZYSET_WORK_ON_STREAM.getValueAsBoolean() && this.getStreamedContent() != null) {
            if (this.delegate.remove(o)) {
                return true;
            }
        } else {
            this.lazyLoad(true);
            int pos = this.indexOf((OIdentifiable)o);
            if (pos > -1) {
                this.delegate.remove(pos);
                return true;
            }
        }
        if (this.hasNewItems()) {
            boolean removed;
            boolean bl = removed = this.newItems.remove(o) != null;
            if (this.newItems.size() == 0) {
                this.newItems = null;
            }
            if (removed) {
                this.setDirty();
            }
            return removed;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.lazyLoad(false);
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        Iterator<? extends OIdentifiable> it = c instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)((Object)c)).rawIterator() : c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.hasNewItems()) {
            Collection<Object> v = this.newItems.values();
            v.retainAll(c);
            if (this.newItems.size() == 0) {
                this.newItems = null;
            }
        }
        return this.delegate.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.hasNewItems()) {
            Collection<Object> v = this.newItems.values();
            v.removeAll(c);
            if (this.newItems.size() == 0) {
                this.newItems = null;
            }
        }
        return this.delegate.removeAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        if (this.newItems != null) {
            this.newItems.clear();
            this.newItems = null;
        }
    }

    public byte getRecordType() {
        return this.delegate.getRecordType();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.delegate.toString());
        if (this.hasNewItems()) {
            for (ORecord<?> item : this.newItems.keySet()) {
                if (buffer.length() > 2) {
                    buffer.insert(buffer.length() - 1, ", ");
                }
                buffer.insert(buffer.length() - 1, item.toString());
            }
            return buffer.toString();
        }
        return buffer.toString();
    }

    public void sort() {
        if (!this.sorted && !this.delegate.isEmpty()) {
            boolean prevConvert = this.delegate.isAutoConvertToRecord();
            if (prevConvert) {
                this.delegate.setAutoConvertToRecord(false);
            }
            this.delegate.marshalling = true;
            Collections.sort(this.delegate);
            this.delegate.marshalling = false;
            if (prevConvert) {
                this.delegate.setAutoConvertToRecord(true);
            }
            this.sorted = true;
        }
    }

    public ORecordLazySet setStreamedContent(StringBuilder iStream) {
        this.delegate.setStreamedContent(iStream);
        return this;
    }

    public StringBuilder getStreamedContent() {
        return this.delegate.getStreamedContent();
    }

    public boolean lazyLoad(boolean iNotIdempotent) {
        if (this.delegate.lazyLoad(iNotIdempotent)) {
            this.sort();
            return true;
        }
        return false;
    }

    @Override
    public void convertLinks2Records() {
        this.delegate.convertLinks2Records();
    }

    private boolean hasNewItems() {
        return this.newItems != null && !this.newItems.isEmpty();
    }

    public void savedAllNewItems() {
        if (this.hasNewItems()) {
            for (ORecord<?> record : this.newItems.keySet()) {
                if (!record.getIdentity().isNew() && this.getStreamedContent() != null && this.getStreamedContent().indexOf(record.getIdentity().toString()) != -1) continue;
                this.add(record.getIdentity());
            }
            this.newItems.clear();
            this.newItems = null;
        }
    }

    public ORecordLazySet copy(ODocument iSourceRecord) {
        return new ORecordLazySet(iSourceRecord, this);
    }

    @Override
    public void onLazyLoad() {
        this.sorted = false;
        this.sort();
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.delegate.getInternalStatus();
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.delegate.setInternalStatus(iStatus);
    }

    public boolean isRidOnly() {
        return this.delegate.isRidOnly();
    }

    public ORecordLazySet setRidOnly(boolean ridOnly) {
        this.delegate.setRidOnly(ridOnly);
        return this;
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }
}

