/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseCompare
extends ODatabaseImpExpAbstract {
    private OStorage storage1;
    private OStorage storage2;
    private ODatabaseDocumentTx databaseDocumentTxOne;
    private ODatabaseDocumentTx databaseDocumentTxTwo;
    private boolean compareEntriesForAutomaticIndexes = false;
    private int differences = 0;

    public ODatabaseCompare(String iDb1URL, String iDb2URL, OCommandOutputListener iListener) throws IOException {
        super(null, null, iListener);
        this.listener.onMessage("\nComparing two local databases:\n1) " + iDb1URL + "\n2) " + iDb2URL + "\n");
        this.storage1 = Orient.instance().loadStorage(iDb1URL);
        this.storage1.open(null, null, null);
        this.storage2 = Orient.instance().loadStorage(iDb2URL);
        this.storage2.open(null, null, null);
    }

    public ODatabaseCompare(String iDb1URL, String iDb2URL, String userName, String userPassword, OCommandOutputListener iListener) throws IOException {
        super(null, null, iListener);
        this.listener.onMessage("\nComparing two local databases:\n1) " + iDb1URL + "\n2) " + iDb2URL + "\n");
        this.databaseDocumentTxOne = new ODatabaseDocumentTx(iDb1URL);
        this.databaseDocumentTxOne.open(userName, userPassword);
        this.databaseDocumentTxTwo = new ODatabaseDocumentTx(iDb2URL);
        this.databaseDocumentTxTwo.open(userName, userPassword);
        this.storage1 = this.databaseDocumentTxOne.getStorage();
        this.storage2 = this.databaseDocumentTxTwo.getStorage();
        this.excludeClusters.add("orids");
        this.excludeClusters.add("index");
    }

    public boolean isCompareEntriesForAutomaticIndexes() {
        return this.compareEntriesForAutomaticIndexes;
    }

    public void setCompareEntriesForAutomaticIndexes(boolean compareEntriesForAutomaticIndexes) {
        this.compareEntriesForAutomaticIndexes = compareEntriesForAutomaticIndexes;
    }

    public boolean compare() {
        if (this.isDocumentDatabases() && (this.databaseDocumentTxOne == null || this.databaseDocumentTxTwo == null)) {
            this.listener.onMessage("\nPassed in URLs are related to document databases but credentials were not provided to open them. Please provide user name + password for databases to compare");
            return false;
        }
        if (!(this.isDocumentDatabases() || this.databaseDocumentTxOne == null && this.databaseDocumentTxTwo == null)) {
            this.listener.onMessage("\nPassed in URLs are not related to document databases but credentials were provided to open them. Please do not provide user name + password for databases to compare");
            return false;
        }
        try {
            this.compareClusters();
            this.compareRecords();
            if (this.isDocumentDatabases()) {
                this.compareIndexes();
            }
            if (this.differences == 0) {
                this.listener.onMessage("\n\nDatabases match.");
                return true;
            }
            this.listener.onMessage("\n\nDatabases do not match. Found " + this.differences + " difference(s).");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ODatabaseExportException("Error on compare of database '" + this.storage1.getName() + "' against '" + this.storage2.getName() + "'", e);
        }
        finally {
            this.storage1.close();
            this.storage2.close();
        }
    }

    private void compareIndexes() {
        this.listener.onMessage("\nStarting index comparison:");
        boolean ok = true;
        final OIndexManager indexManagerOne = ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<OIndexManager>(){

            @Override
            public OIndexManager call() {
                return ODatabaseCompare.this.databaseDocumentTxOne.getMetadata().getIndexManager();
            }
        });
        final OIndexManager indexManagerTwo = ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<OIndexManager>(){

            @Override
            public OIndexManager call() {
                return ODatabaseCompare.this.databaseDocumentTxTwo.getMetadata().getIndexManager();
            }
        });
        final Collection indexesOne = (Collection)ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Collection<? extends OIndex<?>>>(){

            @Override
            public Collection<? extends OIndex<?>> call() {
                return indexManagerOne.getIndexes();
            }
        });
        int indexesSizeOne = ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<Integer>(){

            @Override
            public Integer call() {
                return indexesOne.size();
            }
        });
        int indexesSizeTwo = ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<Integer>(){

            @Override
            public Integer call() {
                return indexManagerTwo.getIndexes().size();
            }
        });
        if (indexesSizeOne != indexesSizeTwo) {
            ok = false;
            this.listener.onMessage("\n- ERR: Amount of indexes are different.");
            this.listener.onMessage("\n--- DB1: " + indexesSizeOne);
            this.listener.onMessage("\n--- DB2: " + indexesSizeTwo);
            this.listener.onMessage("\n");
            ++this.differences;
        }
        final Iterator iteratorOne = (Iterator)ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Iterator<? extends OIndex<?>>>(){

            @Override
            public Iterator<? extends OIndex<?>> call() {
                return indexesOne.iterator();
            }
        });
        while (ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Boolean>(){

            @Override
            public Boolean call() {
                return iteratorOne.hasNext();
            }
        }).booleanValue()) {
            long indexTwoSize;
            final OIndex indexOne = (OIndex)ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<OIndex<?>>(){

                @Override
                public OIndex<?> call() {
                    return (OIndex)iteratorOne.next();
                }
            });
            final OIndex indexTwo = (OIndex)ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<OIndex<?>>(){

                @Override
                public OIndex<?> call() {
                    return indexManagerTwo.getIndex(indexOne.getName());
                }
            });
            if (indexTwo == null) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index " + indexOne.getName() + " is absent in DB2.");
                ++this.differences;
                continue;
            }
            if (!indexOne.getType().equals(indexTwo.getType())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index types for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOne.getType());
                this.listener.onMessage("\n--- DB2: " + indexTwo.getType());
                this.listener.onMessage("\n");
                ++this.differences;
                continue;
            }
            if (!indexOne.getClusters().equals(indexTwo.getClusters())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Clusters to index for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOne.getClusters());
                this.listener.onMessage("\n--- DB2: " + indexTwo.getClusters());
                this.listener.onMessage("\n");
                ++this.differences;
                continue;
            }
            if (indexOne.getDefinition() == null && indexTwo.getDefinition() != null) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index definition for index " + indexOne.getName() + " for DB2 is not null.");
                ++this.differences;
                continue;
            }
            if (indexOne.getDefinition() != null && indexTwo.getDefinition() == null) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index definition for index " + indexOne.getName() + " for DB2 is null.");
                ++this.differences;
                continue;
            }
            if (indexOne.getDefinition() != null && !indexOne.getDefinition().equals(indexTwo.getDefinition())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Index definitions for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOne.getDefinition());
                this.listener.onMessage("\n--- DB2: " + indexTwo.getDefinition());
                this.listener.onMessage("\n");
                ++this.differences;
                continue;
            }
            long indexOneSize = ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Long>(){

                @Override
                public Long call() {
                    return indexOne.getSize();
                }
            });
            if (indexOneSize != (indexTwoSize = ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<Long>(){

                @Override
                public Long call() {
                    return indexTwo.getSize();
                }
            }).longValue())) {
                ok = false;
                this.listener.onMessage("\n- ERR: Amount of entries for index " + indexOne.getName() + " are different.");
                this.listener.onMessage("\n--- DB1: " + indexOneSize);
                this.listener.onMessage("\n--- DB2: " + indexTwoSize);
                this.listener.onMessage("\n");
                ++this.differences;
            }
            if (!this.compareEntriesForAutomaticIndexes && indexOne.isAutomatic()) continue;
            final Iterator<Map.Entry<Object, Object>> indexIteratorOne = ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Iterator<Map.Entry<Object, Object>>>(){

                @Override
                public Iterator<Map.Entry<Object, Object>> call() {
                    return indexOne.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call() {
                    return indexIteratorOne.hasNext();
                }
            }).booleanValue()) {
                final Map.Entry<Object, Object> indexOneEntry = ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Map.Entry<Object, Object>>(){

                    @Override
                    public Map.Entry<Object, Object> call() {
                        return (Map.Entry)indexIteratorOne.next();
                    }
                });
                final Object key = ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return indexOneEntry.getKey();
                    }
                });
                Object indexOneValue = ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return indexOneEntry.getValue();
                    }
                });
                Object indexTwoValue = ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<Object>(){

                    @Override
                    public Object call() {
                        return indexTwo.get(key);
                    }
                });
                if (indexTwoValue == null) {
                    ok = false;
                    this.listener.onMessage("\n- ERR: Entree with key " + key + " is absent in index " + indexOne.getName() + " for DB2.");
                    ++this.differences;
                    continue;
                }
                if (indexOneValue instanceof Set && indexTwoValue instanceof Set) {
                    Set indexOneValueSet = (Set)indexOneValue;
                    Set indexTwoValueSet = (Set)indexTwoValue;
                    if (ODocumentHelper.compareSets(this.databaseDocumentTxOne, indexOneValueSet, this.databaseDocumentTxTwo, indexTwoValueSet)) continue;
                    ok = false;
                    this.reportIndexDiff(indexOne, key, indexOneValue, indexTwoValue);
                    continue;
                }
                if (indexOneValue.equals(indexTwoValue)) continue;
                ok = false;
                this.reportIndexDiff(indexOne, key, indexOneValue, indexTwoValue);
            }
        }
        if (ok) {
            this.listener.onMessage("OK");
        }
    }

    private boolean compareClusters() {
        this.listener.onMessage("\nStarting shallow comparison of clusters:");
        this.listener.onMessage("\nChecking the number of clusters...");
        if (this.storage1.getClusterNames().size() != this.storage1.getClusterNames().size()) {
            this.listener.onMessage("ERR: cluster sizes are different: " + this.storage1.getClusterNames().size() + " <-> " + this.storage1.getClusterNames().size());
            ++this.differences;
        }
        for (String clusterName : this.storage1.getClusterNames()) {
            if (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName)) continue;
            boolean ok = true;
            int cluster2Id = this.storage2.getClusterIdByName(clusterName);
            this.listener.onMessage("\n- Checking cluster " + String.format("%-25s: ", "'" + clusterName + "'"));
            if (cluster2Id == -1) {
                this.listener.onMessage("ERR: cluster name " + clusterName + " was not found on database " + this.storage2);
                ++this.differences;
                ok = false;
            }
            if (cluster2Id != this.storage1.getClusterIdByName(clusterName)) {
                this.listener.onMessage("ERR: cluster id is different for cluster " + clusterName + ": " + this.storage1.getClusterIdByName(clusterName) + " <-> " + cluster2Id);
                ++this.differences;
                ok = false;
            }
            if (this.storage1.count(cluster2Id) != this.storage2.count(cluster2Id)) {
                this.listener.onMessage("ERR: number of records different in cluster '" + clusterName + "' (id=" + cluster2Id + "): " + this.storage1.count(cluster2Id) + " <-> " + this.storage2.count(cluster2Id));
                ++this.differences;
                ok = false;
            }
            if (!ok) continue;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\n\nShallow analysis done.");
        return true;
    }

    private boolean compareRecords() {
        this.listener.onMessage("\nStarting deep comparison record by record. This may take a few minutes. Wait please...");
        for (String clusterName : this.storage1.getClusterNames()) {
            if (this.includeClusters != null ? !this.includeClusters.contains(clusterName) : this.excludeClusters != null && this.excludeClusters.contains(clusterName)) continue;
            int clusterId = this.storage1.getClusterIdByName(clusterName);
            long db1Max = this.storage1.getClusterDataRange(clusterId)[1];
            long db2Max = this.storage2.getClusterDataRange(clusterId)[1];
            final ODocument doc1 = new ODocument();
            final ODocument doc2 = new ODocument();
            ORecordId rid = new ORecordId(clusterId);
            long clusterMax = Math.max(db1Max, db2Max);
            int i = 0;
            while ((long)i <= clusterMax) {
                rid.clusterPosition = i;
                if (!(this.isDocumentDatabases() && rid.equals(new ORecordId(this.storage1.getConfiguration().indexMgrRecordId)) && rid.equals(new ORecordId(this.storage2.getConfiguration().indexMgrRecordId)))) {
                    ORawBuffer buffer2;
                    final ORawBuffer buffer1 = (long)i <= db1Max ? this.storage1.readRecord(rid, null, true, null) : null;
                    ORawBuffer oRawBuffer = buffer2 = (long)i <= db2Max ? this.storage2.readRecord(rid, null, true, null) : null;
                    if (buffer1 != null || buffer2 != null) {
                        if (buffer1 == null && buffer2 != null) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " is null in DB1");
                            ++this.differences;
                        } else if (buffer1 != null && buffer2 == null) {
                            this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " is null in DB2");
                            ++this.differences;
                        } else {
                            if (buffer1.recordType != buffer2.recordType) {
                                this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " recordType is different: " + (char)buffer1.recordType + " <-> " + (char)buffer2.recordType);
                                ++this.differences;
                            }
                            if (buffer1.buffer != null || buffer2.buffer != null) {
                                if (buffer1.buffer == null && buffer2.buffer != null) {
                                    this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content is different: null <-> " + buffer2.buffer.length);
                                    ++this.differences;
                                } else if (buffer1.buffer != null && buffer2.buffer == null) {
                                    this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content is different: " + buffer1.buffer.length + " <-> null");
                                    ++this.differences;
                                } else if (buffer1.recordType == 100) {
                                    ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Object>(){

                                        @Override
                                        public Object call() {
                                            doc1.reset();
                                            doc1.fromStream(buffer1.buffer);
                                            return null;
                                        }
                                    });
                                    ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<Object>(){

                                        @Override
                                        public Object call() {
                                            doc2.reset();
                                            doc2.fromStream(buffer2.buffer);
                                            return null;
                                        }
                                    });
                                    if (rid.toString().equals(this.storage1.getConfiguration().schemaRecordId) && rid.toString().equals(this.storage2.getConfiguration().schemaRecordId)) {
                                        ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<Object>(){

                                            @Override
                                            public Object call() {
                                                ODatabaseCompare.this.convertSchemaDoc(doc1);
                                                return null;
                                            }
                                        });
                                        ODocumentHelper.makeDbCall(this.databaseDocumentTxTwo, new ODocumentHelper.ODbRelatedCall<Object>(){

                                            @Override
                                            public Object call() {
                                                ODatabaseCompare.this.convertSchemaDoc(doc2);
                                                return null;
                                            }
                                        });
                                    }
                                    if (!ODocumentHelper.hasSameContentOf(doc1, this.databaseDocumentTxOne, doc2, this.databaseDocumentTxTwo)) {
                                        this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " document content is different");
                                        this.listener.onMessage("\n--- REC1: " + new String(buffer1.buffer));
                                        this.listener.onMessage("\n--- REC2: " + new String(buffer2.buffer));
                                        this.listener.onMessage("\n");
                                        ++this.differences;
                                    }
                                } else if (buffer1.buffer.length != buffer2.buffer.length) {
                                    String rec1 = new String(buffer1.buffer).trim();
                                    String rec2 = new String(buffer2.buffer).trim();
                                    if (rec1.length() != rec2.length()) {
                                        this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content length is different: " + buffer1.buffer.length + " <-> " + buffer2.buffer.length);
                                        if (buffer1.recordType == 100 || buffer1.recordType == 102) {
                                            this.listener.onMessage("\n--- REC1: " + rec1);
                                        }
                                        if (buffer2.recordType == 100 || buffer2.recordType == 102) {
                                            this.listener.onMessage("\n--- REC2: " + rec2);
                                        }
                                        this.listener.onMessage("\n");
                                        ++this.differences;
                                    }
                                } else {
                                    int b = 0;
                                    while (b < buffer1.buffer.length) {
                                        if (buffer1.buffer[b] != buffer2.buffer[b]) {
                                            this.listener.onMessage("\n- ERR: RID=" + clusterId + ":" + i + " content is different at byte #" + b + ": " + buffer1.buffer[b] + " <-> " + buffer2.buffer[b]);
                                            this.listener.onMessage("\n--- REC1: " + new String(buffer1.buffer));
                                            this.listener.onMessage("\n--- REC2: " + new String(buffer2.buffer));
                                            this.listener.onMessage("\n");
                                            ++this.differences;
                                            break;
                                        }
                                        ++b;
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private void convertSchemaDoc(ODocument document) {
        if (document.field("classes") != null) {
            document.setFieldType("classes", OType.EMBEDDEDSET);
            for (ODocument classDoc : (Set)document.field("classes")) {
                classDoc.setFieldType("properties", OType.EMBEDDEDSET);
            }
        }
    }

    private boolean isDocumentDatabases() {
        return this.storage1.getConfiguration().schemaRecordId != null && this.storage2.getConfiguration().schemaRecordId != null;
    }

    private void reportIndexDiff(OIndex<?> indexOne, Object key, final Object indexOneValue, final Object indexTwoValue) {
        this.listener.onMessage("\n- ERR: Entree values for key '" + key + "' are different for index " + indexOne.getName());
        this.listener.onMessage("\n--- DB1: " + ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<String>(){

            @Override
            public String call() {
                return indexOneValue.toString();
            }
        }));
        this.listener.onMessage("\n--- DB2: " + ODocumentHelper.makeDbCall(this.databaseDocumentTxOne, new ODocumentHelper.ODbRelatedCall<String>(){

            @Override
            public String call() {
                return indexTwoValue.toString();
            }
        }));
        this.listener.onMessage("\n");
        ++this.differences;
    }
}

