/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabaseImpExpAbstract {
    protected ODatabaseRecord database;
    protected String fileName;
    protected boolean includeInfo = true;
    protected Set<String> includeClusters;
    protected Set<String> excludeClusters;
    protected Set<String> includeClasses;
    protected Set<String> excludeClasses;
    protected boolean includeSchema = true;
    protected boolean includeSecurity = false;
    protected boolean includeRecords = true;
    protected boolean includeIndexDefinitions = true;
    protected boolean includeManualIndexes = true;
    protected OCommandOutputListener listener;
    protected static final String DEFAULT_EXT = ".json";

    public ODatabaseImpExpAbstract(ODatabaseRecord iDatabase, String iFileName, OCommandOutputListener iListener) {
        this.database = iDatabase;
        this.fileName = iFileName;
        if (this.fileName != null && this.fileName.indexOf(46) == -1) {
            this.fileName = String.valueOf(this.fileName) + DEFAULT_EXT;
        }
        this.listener = iListener;
        this.excludeClusters = new LinkedHashSet<String>();
        this.excludeClusters.add("index");
    }

    public Set<String> getIncludeClusters() {
        return this.includeClusters;
    }

    public void setIncludeClusters(Set<String> includeClusters) {
        this.includeClusters = includeClusters;
    }

    public Set<String> getExcludeClusters() {
        return this.excludeClusters;
    }

    public void setExcludeClusters(Set<String> excludeClusters) {
        this.excludeClusters = excludeClusters;
    }

    public Set<String> getIncludeClasses() {
        return this.includeClasses;
    }

    public void setIncludeClasses(Set<String> includeClasses) {
        this.includeClasses = includeClasses;
    }

    public Set<String> getExcludeClasses() {
        return this.excludeClasses;
    }

    public void setExcludeClasses(Set<String> excludeClasses) {
        this.excludeClasses = excludeClasses;
    }

    public OCommandOutputListener getListener() {
        return this.listener;
    }

    public void setListener(OCommandOutputListener listener) {
        this.listener = listener;
    }

    public ODatabaseRecord getDatabase() {
        return this.database;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean isIncludeRecords() {
        return this.includeRecords;
    }

    public void setIncludeRecords(boolean includeRecords) {
        this.includeRecords = includeRecords;
    }

    public boolean isIncludeIndexDefinitions() {
        return this.includeIndexDefinitions;
    }

    public void setIncludeIndexDefinitions(boolean includeIndexDefinitions) {
        this.includeIndexDefinitions = includeIndexDefinitions;
    }

    public boolean isIncludeManualIndexes() {
        return this.includeManualIndexes;
    }

    public void setIncludeManualIndexes(boolean includeManualIndexes) {
        this.includeManualIndexes = includeManualIndexes;
    }
}

