/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.entity;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.entity.OEntityManagerClassHandler;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OEntityManager {
    private static Map<String, OEntityManager> databaseInstances = new HashMap<String, OEntityManager>();
    private OEntityManagerClassHandler classHandler = new OEntityManagerClassHandler();

    protected OEntityManager() {
        OLogManager.instance().debug((Object)this, "Registering entity manager", new Object[0]);
        this.classHandler.registerEntityClass(OUser.class);
        this.classHandler.registerEntityClass(ORole.class);
    }

    public static synchronized OEntityManager getEntityManagerByDatabaseURL(String iURL) {
        OEntityManager instance = databaseInstances.get(iURL);
        if (instance == null) {
            instance = new OEntityManager();
            databaseInstances.put(iURL, instance);
        }
        return instance;
    }

    public synchronized Object createPojo(String iClassName) throws OConfigurationException {
        if (iClassName == null) {
            throw new IllegalArgumentException("Cannot create the object: class name is empty");
        }
        Class<?> entityClass = this.classHandler.getEntityClass(iClassName);
        try {
            if (entityClass != null) {
                return this.createInstance(entityClass);
            }
        }
        catch (Exception e) {
            throw new OConfigurationException("Error while creating new pojo of class '" + iClassName + "'", e);
        }
        try {
            return this.createInstance(Class.forName(iClassName));
        }
        catch (Exception e) {
            throw new OConfigurationException("The class '" + iClassName + "' was not found between the entity classes. Ensure registerEntityClasses(package) has been called first.", e);
        }
    }

    public synchronized Class<?> getEntityClass(String iClassName) {
        return this.classHandler.getEntityClass(iClassName);
    }

    public synchronized void registerEntityClass(Class<?> iClass) {
        this.classHandler.registerEntityClass(iClass);
    }

    public synchronized void registerEntityClasses(String iPackageName) {
        this.registerEntityClasses(iPackageName, Thread.currentThread().getContextClassLoader());
    }

    public synchronized void registerEntityClasses(String iPackageName, ClassLoader iClassLoader) {
        OLogManager.instance().debug((Object)this, "Discovering entity classes inside package: %s", iPackageName);
        List<Class<?>> classes = null;
        try {
            classes = OReflectionHelper.getClassesForPackage(iPackageName, iClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new OException(classNotFoundException);
        }
        for (Class<?> clazz : classes) {
            this.classHandler.registerEntityClass(clazz);
        }
        if (OLogManager.instance().isDebugEnabled()) {
            for (Map.Entry entry : this.classHandler.getClassesEntrySet()) {
                OLogManager.instance().debug((Object)this, "Loaded entity class '%s' from: %s", entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void setClassHandler(OEntityManagerClassHandler iClassHandler) {
        for (Map.Entry<String, Class<?>> entry : this.classHandler.getClassesEntrySet()) {
            iClassHandler.registerEntityClass(entry.getValue());
        }
        this.classHandler = iClassHandler;
    }

    protected Object createInstance(Class<?> iClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.classHandler.createInstance(iClass);
    }
}

