/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OEntityManagerClassHandler {
    private Map<String, Class<?>> entityClasses = new HashMap();

    public synchronized Class<?> getEntityClass(String iClassName) {
        return this.entityClasses.get(iClassName);
    }

    public synchronized void registerEntityClass(Class<?> iClass) {
        this.entityClasses.put(iClass.getSimpleName(), iClass);
    }

    public synchronized void registerEntityClass(String iClassName, Class<?> iClass) {
        this.entityClasses.put(iClassName, iClass);
    }

    public synchronized void deregisterEntityClass(String iClassName) {
        this.entityClasses.remove(iClassName);
    }

    public synchronized void deregisterEntityClass(Class<?> iClass) {
        this.entityClasses.remove(iClass.getSimpleName());
    }

    public synchronized Set<Map.Entry<String, Class<?>>> getClassesEntrySet() {
        return this.entityClasses.entrySet();
    }

    public synchronized Object createInstance(Class<?> iClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> defaultConstructor = null;
        Constructor<?>[] constructorArray = iClass.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            if (c.getParameterTypes().length == 0) {
                defaultConstructor = c;
                break;
            }
            ++n2;
        }
        if (defaultConstructor == null) {
            throw new IllegalArgumentException("Cannot create an object of class '" + iClass.getName() + "' because it has no default constructor. Please define the method: " + iClass.getSimpleName() + "()");
        }
        if (!defaultConstructor.isAccessible()) {
            defaultConstructor.setAccessible(true);
        }
        return defaultConstructor.newInstance(new Object[0]);
    }
}

