/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFetchHelper {
    public static final String ROOT_FETCH = "*";

    public static Map<String, Integer> buildFetchPlan(String iFetchPlan) {
        List<String> planParts;
        HashMap<String, Integer> fetchPlan = new HashMap<String, Integer>();
        fetchPlan.put(ROOT_FETCH, 0);
        if (iFetchPlan != null && !(planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0])).isEmpty()) {
            for (String planPart : planParts) {
                List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                fetchPlan.put(parts.get(0), Integer.parseInt(parts.get(1)));
            }
        }
        return fetchPlan;
    }

    public static void fetch(ORecordInternal<?> iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, OFetchListener iListener, OFetchContext iContext) {
        try {
            if (iRootRecord instanceof ORecordSchemaAware) {
                ORecordSchemaAware record = (ORecordSchemaAware)iRootRecord;
                HashMap<ORID, Integer> parsedRecords = new HashMap<ORID, Integer>();
                parsedRecords.put(iRootRecord.getIdentity(), 0);
                OFetchHelper.processRecordRidMap(record, iFetchPlan, 0, 0, -1, parsedRecords, "", iContext);
                OFetchHelper.processRecord(record, iUserObject, iFetchPlan, 0, 0, -1, parsedRecords, "", iListener, iContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, iRootRecord.getIdentity());
        }
    }

    public static void checkFetchPlanValid(String iFetchPlan) {
        if (iFetchPlan != null && !iFetchPlan.isEmpty()) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (!planParts.isEmpty()) {
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    if (parts.size() == 2) continue;
                    throw new IllegalArgumentException("Fetch plan '" + iFetchPlan + "' is invalid");
                }
            } else {
                throw new IllegalArgumentException("Fetch plan '" + iFetchPlan + "' is invalid");
            }
        }
    }

    public static boolean isFetchPlanValid(String iFetchPlan) {
        if (iFetchPlan != null && !iFetchPlan.isEmpty()) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (!planParts.isEmpty()) {
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    if (parts.size() == 2) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static int getDepthLevel(Map<String, Integer> iFetchPlan, String iFieldPath) {
        Integer depthLevel = iFetchPlan.get(ROOT_FETCH);
        for (String fieldFetchDefinition : iFetchPlan.keySet()) {
            if (iFieldPath.startsWith(fieldFetchDefinition)) {
                depthLevel = iFetchPlan.get(fieldFetchDefinition);
                break;
            }
            if (!fieldFetchDefinition.startsWith(iFieldPath)) continue;
            depthLevel = 1;
            break;
        }
        return depthLevel;
    }

    public static void processRecordRidMap(ORecordSchemaAware<?> record, Map<String, Integer> iFetchPlan, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        if (iFetchPlan == null) {
            return;
        }
        String[] stringArray = record.fieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            String fieldPath = !iFieldPathFromRoot.isEmpty() ? String.valueOf(iFieldPathFromRoot) + "." + fieldName : fieldName;
            int depthLevel = iFieldDepthLevel > -1 ? iFieldDepthLevel : OFetchHelper.getDepthLevel(iFetchPlan, fieldPath);
            Object fieldValue = record.field(fieldName);
            if (fieldValue != null && (fieldValue instanceof OIdentifiable || fieldValue instanceof Collection && ((Collection)fieldValue).size() != 0 && ((Collection)fieldValue).iterator().next() instanceof OIdentifiable || fieldValue instanceof Map && ((Map)fieldValue).size() != 0 && ((Map)fieldValue).values().iterator().next() instanceof OIdentifiable)) {
                try {
                    if (fieldValue instanceof ODocument && (((ODocument)fieldValue).isEmbedded() || !((ODocument)fieldValue).getIdentity().isValid()) && iContext.fetchEmbeddedDocuments() || iFetchPlan.containsKey(fieldPath) || depthLevel <= -1 || iCurrentLevel < depthLevel) {
                        OFetchHelper.fetchRidMap(record, iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot + 1, iFieldDepthLevel, parsedRecords, fieldPath, iContext);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, record.getIdentity());
                }
            }
            ++n2;
        }
    }

    private static void fetchRidMap(ORecordSchemaAware<?> iRootRecord, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof ODocument) {
            OFetchHelper.fetchDocumentRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (fieldValue instanceof Collection) {
            OFetchHelper.fetchCollectionRidMap(iRootRecord.getDatabase(), iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (fieldValue.getClass().isArray()) {
            OFetchHelper.fetchArrayRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (fieldValue instanceof Map) {
            OFetchHelper.fetchMapRidMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void fetchDocumentRidMap(Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        OFetchHelper.updateRidMap(iFetchPlan, (ODocument)fieldValue, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
    }

    private static void fetchCollectionRidMap(ODatabaseRecord iDatabase, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        Collection linked = (Collection)fieldValue;
        for (OIdentifiable d : linked) {
            if (d instanceof ORecordId) {
                d = (OIdentifiable)iDatabase.load((ORecordId)d);
            }
            OFetchHelper.updateRidMap(iFetchPlan, (ODocument)d, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void fetchArrayRidMap(Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        if (fieldValue instanceof ODocument[]) {
            ODocument[] linked;
            ODocument[] oDocumentArray = linked = (ODocument[])fieldValue;
            int n = linked.length;
            int n2 = 0;
            while (n2 < n) {
                ODocument d = oDocumentArray[n2];
                OFetchHelper.updateRidMap(iFetchPlan, d, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
                ++n2;
            }
        }
    }

    private static void fetchMapRidMap(Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        Map linked = (Map)fieldValue;
        for (ODocument d : linked.values()) {
            OFetchHelper.updateRidMap(iFetchPlan, d, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void updateRidMap(Map<String, Integer> iFetchPlan, ODocument fieldValue, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchContext iContext) throws IOException {
        Integer fetchedLevel = parsedRecords.get(fieldValue.getIdentity());
        int currentLevel = iCurrentLevel + 1;
        int fieldDepthLevel = iFieldDepthLevel;
        if (iFetchPlan.containsKey(iFieldPathFromRoot)) {
            currentLevel = 1;
            fieldDepthLevel = iFetchPlan.get(iFieldPathFromRoot);
        }
        if (fetchedLevel == null) {
            parsedRecords.put(fieldValue.getIdentity(), iLevelFromRoot);
            OFetchHelper.processRecordRidMap(fieldValue, iFetchPlan, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        } else if (!fieldValue.getIdentity().isValid() && fetchedLevel < iLevelFromRoot || fetchedLevel > iLevelFromRoot) {
            parsedRecords.put(fieldValue.getIdentity(), iLevelFromRoot);
            OFetchHelper.processRecordRidMap(fieldValue, iFetchPlan, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iContext);
        }
    }

    private static void processRecord(ORecordSchemaAware<?> record, Object iUserObject, Map<String, Integer> iFetchPlan, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        iContext.onBeforeFetch(record);
        String[] stringArray = record.fieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            String fieldPath = !iFieldPathFromRoot.isEmpty() ? String.valueOf(iFieldPathFromRoot) + "." + fieldName : fieldName;
            int depthLevel = iFieldDepthLevel > -1 ? iFieldDepthLevel : OFetchHelper.getDepthLevel(iFetchPlan, fieldPath);
            Object fieldValue = record.field(fieldName);
            if (!(fieldValue != null && (fieldValue instanceof OIdentifiable || fieldValue instanceof Collection && ((Collection)fieldValue).size() != 0 && ((Collection)fieldValue).iterator().next() instanceof OIdentifiable || fieldValue instanceof Map && ((Map)fieldValue).size() != 0 && ((Map)fieldValue).values().iterator().next() instanceof OIdentifiable))) {
                iContext.onBeforeStandardField(fieldValue, fieldName, iUserObject);
                iListener.processStandardField(record, fieldValue, fieldName, iContext, iUserObject);
                iContext.onAfterStandardField(fieldValue, fieldName, iUserObject);
            } else {
                try {
                    if (!(fieldValue instanceof ODocument) || (((ODocument)fieldValue).isEmbedded() || !((ODocument)fieldValue).getIdentity().isValid()) && iContext.fetchEmbeddedDocuments() || iFetchPlan.containsKey(fieldPath) || depthLevel <= -1 || iCurrentLevel <= depthLevel) {
                        OFetchHelper.fetch(record, iUserObject, iFetchPlan, fieldValue, fieldName, iCurrentLevel, iLevelFromRoot + 1, iFieldDepthLevel, parsedRecords, depthLevel, fieldPath, iListener, iContext);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, record.getIdentity());
                }
            }
            ++n2;
        }
        iContext.onAfterFetch(record);
    }

    private static void fetch(ORecordSchemaAware<?> iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, int depthLevel, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        int currentLevel = iCurrentLevel + 1;
        int fieldDepthLevel = iFieldDepthLevel;
        if (iFetchPlan.containsKey(iFieldPathFromRoot)) {
            currentLevel = 0;
            fieldDepthLevel = iFetchPlan.get(iFieldPathFromRoot);
        }
        if (fieldValue == null) {
            iListener.processStandardField(iRootRecord, null, fieldName, iContext, iUserObject);
        } else if (fieldValue instanceof OIdentifiable) {
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).getClassName() != null && ((ODocument)fieldValue).getClassName().equals("ORIDs")) {
                OFetchHelper.fetchCollection(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
            } else {
                OFetchHelper.fetchDocument(iRootRecord, iUserObject, iFetchPlan, (OIdentifiable)fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
            }
        } else if (fieldValue instanceof Collection) {
            OFetchHelper.fetchCollection(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
        } else if (fieldValue.getClass().isArray()) {
            OFetchHelper.fetchArray(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
        } else if (fieldValue instanceof Map) {
            OFetchHelper.fetchMap(iRootRecord, iUserObject, iFetchPlan, fieldValue, fieldName, currentLevel, iLevelFromRoot, fieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
        }
    }

    private static void fetchMap(ORecordSchemaAware<?> iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        Map linked = (Map)fieldValue;
        iContext.onBeforeMap(iRootRecord, fieldName, iUserObject);
        for (String key : linked.keySet()) {
            ODocument d = (ODocument)linked.get(key);
            Integer fieldDepthLevel = parsedRecords.get(d.getIdentity());
            if (!d.getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
                OFetchHelper.removeParsedFromMap(parsedRecords, d);
                iContext.onBeforeDocument(iRootRecord, d, key, iUserObject);
                Object userObject = iListener.fetchLinkedMapEntry(iRootRecord, iUserObject, fieldName, key, d, iContext);
                OFetchHelper.processRecord(d, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
                iContext.onAfterDocument(iRootRecord, d, key, iUserObject);
                continue;
            }
            iListener.parseLinkedCollectionValue(iRootRecord, d, iUserObject, key, iContext);
        }
        iContext.onAfterMap(iRootRecord, fieldName, iUserObject);
    }

    private static void fetchArray(ORecordSchemaAware<?> iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        if (fieldValue instanceof ODocument[]) {
            OIdentifiable[] linked = (ODocument[])fieldValue;
            iContext.onBeforeArray(iRootRecord, fieldName, iUserObject, linked);
            OIdentifiable[] oIdentifiableArray = linked;
            int n = linked.length;
            int n2 = 0;
            while (n2 < n) {
                OIdentifiable d = oIdentifiableArray[n2];
                Integer fieldDepthLevel = parsedRecords.get(((ORecordAbstract)d).getIdentity());
                if (!((ORecordAbstract)d).getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
                    OFetchHelper.removeParsedFromMap(parsedRecords, d);
                    iContext.onBeforeDocument(iRootRecord, (ORecordSchemaAware<?>)d, fieldName, iUserObject);
                    Object userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, (ORecordSchemaAware<?>)d, iContext);
                    OFetchHelper.processRecord(d, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
                    iContext.onAfterDocument(iRootRecord, (ORecordSchemaAware<?>)d, fieldName, iUserObject);
                } else {
                    iListener.parseLinkedCollectionValue(iRootRecord, d, iUserObject, fieldName, iContext);
                }
                ++n2;
            }
            iContext.onAfterArray(iRootRecord, fieldName, iUserObject);
        } else {
            iListener.processStandardField(iRootRecord, fieldValue, fieldName, iContext, iUserObject);
        }
    }

    private static void fetchCollection(ORecordSchemaAware<?> iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        Collection<OIdentifiable> linked = fieldValue instanceof ODocument ? new OMVRBTreeRIDSet().fromDocument((ODocument)fieldValue) : (Collection<OIdentifiable>)fieldValue;
        iContext.onBeforeCollection(iRootRecord, fieldName, iUserObject, linked);
        for (OIdentifiable d : linked) {
            Integer fieldDepthLevel = parsedRecords.get(d.getIdentity());
            if (!d.getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
                OFetchHelper.removeParsedFromMap(parsedRecords, d);
                d = d.getRecord();
                if (!(d instanceof ODocument)) {
                    iListener.processStandardField(null, d, fieldName, iContext, iUserObject);
                    continue;
                }
                iContext.onBeforeDocument(iRootRecord, (ODocument)d, fieldName, iUserObject);
                Object userObject = iListener.fetchLinkedCollectionValue(iRootRecord, iUserObject, fieldName, (ODocument)d, iContext);
                OFetchHelper.processRecord((ODocument)d, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
                iContext.onAfterDocument(iRootRecord, (ODocument)d, fieldName, iUserObject);
                continue;
            }
            iListener.parseLinkedCollectionValue(iRootRecord, d, iUserObject, fieldName, iContext);
        }
        iContext.onAfterCollection(iRootRecord, fieldName, iUserObject);
    }

    private static void fetchDocument(ORecordSchemaAware<?> iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, OIdentifiable fieldValue, String fieldName, int iCurrentLevel, int iLevelFromRoot, int iFieldDepthLevel, Map<ORID, Integer> parsedRecords, String iFieldPathFromRoot, OFetchListener iListener, OFetchContext iContext) throws IOException {
        Integer fieldDepthLevel = parsedRecords.get(fieldValue.getIdentity());
        if (!fieldValue.getIdentity().isValid() || fieldDepthLevel != null && fieldDepthLevel == iLevelFromRoot) {
            OFetchHelper.removeParsedFromMap(parsedRecords, fieldValue);
            ODocument linked = (ODocument)fieldValue;
            iContext.onBeforeDocument(iRootRecord, linked, fieldName, iUserObject);
            Object userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, linked, iContext);
            OFetchHelper.processRecord(linked, userObject, iFetchPlan, iCurrentLevel, iLevelFromRoot, iFieldDepthLevel, parsedRecords, iFieldPathFromRoot, iListener, iContext);
            iContext.onAfterDocument(iRootRecord, linked, fieldName, iUserObject);
        } else {
            iListener.parseLinked(iRootRecord, fieldValue, iUserObject, fieldName, iContext);
        }
    }

    protected static void removeParsedFromMap(Map<ORID, Integer> parsedRecords, OIdentifiable d) {
        if (d.getIdentity().isValid()) {
            parsedRecords.remove(d.getIdentity());
        }
    }
}

