/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODocumentFieldsHashSet
extends AbstractSet<ODocument> {
    private final LinkedHashSet<ODocumentWrapper> hashSet = new LinkedHashSet();

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof ODocument)) {
            return false;
        }
        return this.hashSet.contains(new ODocumentWrapper((ODocument)o));
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof ODocument)) {
            return false;
        }
        return this.hashSet.remove(new ODocumentWrapper((ODocument)o));
    }

    @Override
    public boolean add(ODocument document) {
        return this.hashSet.add(new ODocumentWrapper(document));
    }

    @Override
    public boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    @Override
    public void clear() {
        this.hashSet.clear();
    }

    @Override
    public Iterator<ODocument> iterator() {
        final Iterator iterator = this.hashSet.iterator();
        return new Iterator<ODocument>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public ODocument next() {
                return ((ODocumentWrapper)iterator.next()).document;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    private static final class ODocumentWrapper {
        private final ODocument document;

        private ODocumentWrapper(ODocument document) {
            this.document = document;
        }

        public int hashCode() {
            int hashCode = this.document.getIdentity().hashCode();
            Object[] objectArray = this.document.fieldValues();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object field = objectArray[n2];
                hashCode = 31 * hashCode + field.hashCode();
                ++n2;
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            String[] anotherFieldNames;
            if (obj == null) {
                return false;
            }
            if (obj == this.document) {
                return true;
            }
            if (obj.getClass() != this.document.getClass()) {
                return false;
            }
            ODocument anotherDocument = (ODocument)obj;
            if (!this.document.getIdentity().equals(anotherDocument.getIdentity())) {
                return false;
            }
            String[] filedNames = this.document.fieldNames();
            if (filedNames.length != (anotherFieldNames = anotherDocument.fieldNames()).length) {
                return false;
            }
            String[] stringArray = filedNames;
            int n = filedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                Object fieldValue = this.document.field(fieldName);
                Object anotherFieldValue = anotherDocument.field(fieldName);
                if (fieldValue == null && anotherFieldValue != null) {
                    return false;
                }
                if (fieldValue != null && !fieldValue.equals(anotherFieldValue)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public String toString() {
            return this.document.toString();
        }
    }
}

