/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareDictionary;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexManagerAbstract
extends ODocumentWrapperNoClass
implements OIndexManager,
OCloseable {
    public static final String CONFIG_INDEXES = "indexes";
    public static final String DICTIONARY_NAME = "dictionary";
    protected Map<String, OIndexInternal<?>> indexes = new ConcurrentHashMap();
    protected final Map<String, Map<OMultiKey, Set<OIndex<?>>>> classPropertyIndex = new HashMap();
    protected String defaultClusterName = "index";
    protected ReadWriteLock lock = new ReentrantReadWriteLock();

    public OIndexManagerAbstract(ODatabaseRecord iDatabase) {
        super(new ODocument());
    }

    protected abstract OIndex<?> getIndexInstance(OIndex<?> var1);

    protected void acquireSharedLock() {
        this.lock.readLock().lock();
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() {
        this.lock.writeLock().lock();
    }

    protected void releaseExclusiveLock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public OIndexManagerAbstract load() {
        this.acquireExclusiveLock();
        try {
            if (this.getDatabase().getStorage().getConfiguration().indexMgrRecordId == null) {
                this.create();
            }
            this.indexes.clear();
            this.classPropertyIndex.clear();
            ((ORecordId)this.document.getIdentity()).fromString(this.getDatabase().getStorage().getConfiguration().indexMgrRecordId);
            super.reload("*:-1 index:0");
            OIndexManagerAbstract oIndexManagerAbstract = this;
            return oIndexManagerAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        this.acquireExclusiveLock();
        try {
            Object RET = super.reload();
            return RET;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        this.acquireExclusiveLock();
        try {
            Object RET = super.save();
            return RET;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create() {
        this.acquireExclusiveLock();
        try {
            this.save("internal");
            this.getDatabase().getStorage().getConfiguration().indexMgrRecordId = this.document.getIdentity().toString();
            this.getDatabase().getStorage().getConfiguration().update();
            this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void flush() {
        for (OIndexInternal<?> idx : this.indexes.values()) {
            idx.flush();
        }
    }

    @Override
    public Collection<? extends OIndex<?>> getIndexes() {
        Collection<OIndexInternal<?>> rawResult = this.indexes.values();
        ArrayList result = new ArrayList(rawResult.size());
        for (OIndexInternal<?> index : rawResult) {
            result.add(this.preProcessBeforeReturn(index));
        }
        return result;
    }

    @Override
    public OIndex<?> getIndex(String iName) {
        OIndexInternal<?> index = this.indexes.get(iName.toLowerCase());
        if (index == null) {
            return null;
        }
        return this.preProcessBeforeReturn(index);
    }

    public boolean existsIndex(String iName) {
        return this.indexes.containsKey(iName.toLowerCase());
    }

    @Override
    public String getDefaultClusterName() {
        this.acquireSharedLock();
        try {
            String string = this.defaultClusterName;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public void setDefaultClusterName(String defaultClusterName) {
        this.acquireExclusiveLock();
        try {
            this.defaultClusterName = defaultClusterName;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        OIndex<OIdentifiable> idx;
        this.acquireExclusiveLock();
        try {
            idx = this.getIndex(DICTIONARY_NAME);
            if (idx == null) {
                idx = this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
        return new ODictionary(idx);
    }

    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.getDocument();
            return oDocument;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    protected ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.flush();
            this.indexes.clear();
            this.classPropertyIndex.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OIndexManager setDirty() {
        this.acquireExclusiveLock();
        try {
            this.document.setDirty();
            OIndexManagerAbstract oIndexManagerAbstract = this;
            return oIndexManagerAbstract;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndex<?> getIndex(ORID iRID) {
        for (OIndex oIndex : this.indexes.values()) {
            if (!oIndex.getIdentity().equals(iRID)) continue;
            return this.getIndexInstance(oIndex);
        }
        return null;
    }

    protected void addIndexInternal(OIndexInternal<?> index) {
        this.acquireExclusiveLock();
        try {
            this.indexes.put(index.getName().toLowerCase(), index);
            OIndexDefinition indexDefinition = index.getDefinition();
            if (indexDefinition == null || indexDefinition.getClassName() == null) {
                return;
            }
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
            if (propertyIndex == null) {
                propertyIndex = new HashMap();
                this.classPropertyIndex.put(indexDefinition.getClassName().toLowerCase(), propertyIndex);
            }
            int paramCount = indexDefinition.getParamCount();
            int i = 1;
            while (i <= paramCount) {
                List<String> fields = indexDefinition.getFields().subList(0, i);
                OMultiKey multiKey = new OMultiKey(this.normalizeFieldNames(fields));
                Set<OIndex<?>> indexSet = propertyIndex.get(multiKey);
                if (indexSet == null) {
                    indexSet = new HashSet();
                }
                indexSet.add(index);
                propertyIndex.put(multiKey, indexSet);
                ++i;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, Collection<String> fields) {
        this.acquireSharedLock();
        try {
            fields = this.normalizeFieldNames(fields);
            OMultiKey multiKey = new OMultiKey(fields);
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex == null || !propertyIndex.containsKey(multiKey)) {
                Set<OIndex<?>> set = Collections.emptySet();
                return set;
            }
            Set<OIndex<?>> rawResult = propertyIndex.get(multiKey);
            HashSet transactionalResult = new HashSet(rawResult.size());
            for (OIndex<?> index : rawResult) {
                transactionalResult.add(this.preProcessBeforeReturn((OIndexInternal)index));
            }
            HashSet hashSet = transactionalResult;
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, String ... fields) {
        return this.getClassInvolvedIndexes(className, Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(String className, Collection<String> fields) {
        this.acquireSharedLock();
        try {
            fields = this.normalizeFieldNames(fields);
            OMultiKey multiKey = new OMultiKey(fields);
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex == null) {
                return false;
            }
            boolean bl = propertyIndex.containsKey(multiKey) && !propertyIndex.get(multiKey).isEmpty();
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean areIndexed(String className, String ... fields) {
        return this.areIndexed(className, Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getClassIndexes(String className) {
        this.acquireSharedLock();
        try {
            HashSet result = new HashSet();
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex == null) {
                Set<OIndex<?>> set = Collections.emptySet();
                return set;
            }
            for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
                for (OIndex<?> index : propertyIndexes) {
                    result.add(this.preProcessBeforeReturn((OIndexInternal)index));
                }
            }
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndex<?> getClassIndex(String className, String indexName) {
        className = className.toLowerCase();
        OIndexInternal<?> index = this.indexes.get(indexName = indexName.toLowerCase());
        if (index != null && index.getDefinition() != null && index.getDefinition().getClassName() != null && className.equals(index.getDefinition().getClassName().toLowerCase())) {
            return this.preProcessBeforeReturn(index);
        }
        return null;
    }

    protected List<String> normalizeFieldNames(Collection<String> fieldNames) {
        ArrayList<String> result = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            result.add(fieldName.toLowerCase());
        }
        return result;
    }

    protected OIndex<?> preProcessBeforeReturn(OIndexInternal<?> index) {
        this.getDatabase().registerListener(index);
        if (index instanceof OIndexMultiValues) {
            return new OIndexTxAwareMultiValue(this.getDatabase(), this.getIndexInstance(index));
        }
        if (index instanceof OIndexDictionary) {
            return new OIndexTxAwareDictionary(this.getDatabase(), this.getIndexInstance(index));
        }
        if (index instanceof OIndexOneValue) {
            return new OIndexTxAwareOneValue(this.getDatabase(), this.getIndexInstance(index));
        }
        return index;
    }
}

