/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private static final String QUERY_DROP = "drop index %s";

    public OIndexManagerRemote(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    @Override
    protected OIndex<?> getIndexInstance(OIndex<?> iIndex) {
        if (iIndex instanceof OIndexMultiValues) {
            return new OIndexRemoteMultiValue(iIndex.getName(), iIndex.getType(), iIndex.getIdentity(), iIndex.getDefinition(), this.getConfiguration(), iIndex.getClusters());
        }
        return new OIndexRemoteOneValue(iIndex.getName(), iIndex.getType(), iIndex.getIdentity(), iIndex.getDefinition(), this.getConfiguration(), iIndex.getClusters());
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType);
        this.acquireExclusiveLock();
        try {
            if (iProgressListener != null) {
                iProgressListener.onBegin(this, 0L);
            }
            this.getDatabase().command(new OCommandSQL(createIndexDDL)).execute(new Object[0]);
            this.document.setIdentity(new ORecordId(this.document.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
            if (iProgressListener != null) {
                iProgressListener.onCompletition(this, true);
            }
            this.reload();
            OIndex<?> oIndex = this.preProcessBeforeReturn((OIndexInternal)this.indexes.get(iName.toLowerCase()));
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndexManager dropIndex(String iIndexName) {
        this.acquireExclusiveLock();
        try {
            String text = String.format(QUERY_DROP, iIndexName);
            this.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
            this.indexes.remove(iIndexName.toLowerCase());
            this.reload();
            OIndexManagerRemote oIndexManagerRemote = this;
            return oIndexManagerRemote;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            Collection idxs = (Collection)this.document.field("indexes");
            this.indexes.clear();
            this.classPropertyIndex.clear();
            if (idxs != null) {
                for (ODocument d : idxs) {
                    OIndexInternal<?> index = OIndexes.createIndex(this.getDatabase(), (String)d.field("type"));
                    index.loadFromConfiguration(d);
                    this.addIndexInternal(index);
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument toStream() {
        this.acquireExclusiveLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
                for (OIndexInternal i : this.indexes.values()) {
                    idxs.add(i.updateConfiguration());
                }
                this.document.field("indexes", idxs, OType.EMBEDDEDSET);
            }
            finally {
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
            this.document.setDirty();
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }
}

