/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexMultiValues
extends OIndexMVRBTreeAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String iType) {
        super(iType);
    }

    @Override
    public Set<OIdentifiable> get(Object iKey) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(iKey);
            if (values == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeRIDSet oMVRBTreeRIDSet = values;
            return oMVRBTreeRIDSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OIndexMultiValues put(Object iKey, OIdentifiable iSingleValue) {
        this.acquireExclusiveLock();
        try {
            this.checkForKeyType(iKey);
            Set values = (Set)this.map.get(iKey);
            if (values == null) {
                values = new OMVRBTreeRIDSet().setAutoConvert(false);
            }
            if (!iSingleValue.getIdentity().isValid()) {
                ((ORecord)iSingleValue).save();
            }
            values.add(iSingleValue.getIdentity());
            this.map.put(iKey, values);
            OIndexMultiValues oIndexMultiValues = this;
            return oIndexMultiValues;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iValue) {
        this.acquireExclusiveLock();
        try {
            Object recs = this.get(iKey);
            if (recs.remove(iValue)) {
                if (recs.isEmpty()) {
                    this.map.remove(iKey);
                } else {
                    this.map.put(iKey, recs);
                }
                return true;
            }
            return false;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int remove(OIdentifiable iRecord) {
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                this.remove(entries.getKey(), iRecord);
                ++tot;
            }
            int n = tot;
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int count(OIdentifiable iRecord) {
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                ++tot;
            }
            int n = tot;
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OIndexMultiValues create(String iName, OIndexDefinition indexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        return (OIndexMultiValues)super.create(iName, indexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, OStreamSerializerListRID.INSTANCE);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = iFromInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iToInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                if (values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                        HashSet<OIdentifiable> hashSet = result;
                        return hashSet;
                    }
                    result.add(value);
                }
                entry = OMVRBTree.next(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = firstEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                if (values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                        HashSet<OIdentifiable> hashSet = result;
                        return hashSet;
                    }
                    result.add(value);
                }
                entry = OMVRBTree.next(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = lastEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                if (values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                        HashSet<OIdentifiable> hashSet = result;
                        return hashSet;
                    }
                    result.add(value);
                }
                entry = OMVRBTree.previous(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        this.acquireExclusiveLock();
        try {
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                        HashSet<OIdentifiable> hashSet = result;
                        return hashSet;
                    }
                    result.add(value);
                }
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = firstEntry;
            HashSet<ODocument> result = new HashSet<ODocument>();
            while (entry != null) {
                Object key = entry.getKey();
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                if (values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                        HashSet<ODocument> hashSet = result;
                        return hashSet;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
                entry = OMVRBTree.next(entry);
            }
            HashSet<ODocument> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = lastEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null) {
                Object key = entry.getKey();
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                if (values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                        ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                        return oDocumentFieldsHashSet;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
                entry = OMVRBTree.previous(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = iInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                Object key = entry.getKey();
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                if (values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                        ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                        return oDocumentFieldsHashSet;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
                entry = OMVRBTree.next(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        this.acquireExclusiveLock();
        try {
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                        ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                        return oDocumentFieldsHashSet;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }
}

