/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexOneValue
extends OIndexMVRBTreeAbstract<OIdentifiable> {
    public OIndexOneValue(String iType) {
        super(iType);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        this.acquireExclusiveLock();
        try {
            OIdentifiable oIdentifiable = (OIdentifiable)this.map.get(iKey);
            return oIdentifiable;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int remove(OIdentifiable iRecord) {
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                if (!((OIdentifiable)entries.getValue()).equals(iRecord)) continue;
                this.remove(entries.getKey(), iRecord);
                ++tot;
            }
            int n = tot;
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int count(OIdentifiable iRecord) {
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                if (!((OIdentifiable)entries.getValue()).equals(iRecord)) continue;
                ++tot;
            }
            int n = tot;
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
        OIdentifiable indexedRID = this.get(iKey);
        if (indexedRID != null && !indexedRID.getIdentity().equals(iRecord.getIdentity())) {
            OTransactionIndexChangesPerKey keyChanges;
            OTransactionIndexChanges indexChanges = ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().getIndexChanges(this.getName());
            if (indexChanges != null && (keyChanges = indexChanges.getChangesPerKey(iKey)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : keyChanges.entries) {
                    if (entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                    return;
                }
            }
            OLogManager.instance().exception("Found duplicated key '%s' previously assigned to the record %s", null, OIndexException.class, iKey, indexedRID);
        }
    }

    public OIndexOneValue create(String iName, OIndexDefinition iIndexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        return (OIndexOneValue)super.create(iName, iIndexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, OStreamSerializerRID.INSTANCE);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        if (iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = iFromInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iToInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (!(entry == null || entry == lastEntry && this.map.getPageIndex() == lastEntryIndex || maxValuesToFetch > -1 && result.size() == maxValuesToFetch)) {
                result.add((OIdentifiable)entry.getValue());
                entry = OMVRBTree.next(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = firstEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null && (maxValuesToFetch <= -1 || result.size() != maxValuesToFetch)) {
                result.add((OIdentifiable)entry.getValue());
                entry = OMVRBTree.next(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = lastEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null && (maxValuesToFetch <= -1 || result.size() != maxValuesToFetch)) {
                result.add((OIdentifiable)entry.getValue());
                entry = OMVRBTree.previous(entry);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToSearch) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        this.acquireExclusiveLock();
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        try {
            for (Object key : sortedKeys) {
                if (maxValuesToSearch > -1 && result.size() == maxValuesToSearch) {
                    HashSet<OIdentifiable> hashSet = result;
                    return hashSet;
                }
                OIdentifiable val = (OIdentifiable)this.map.get(key);
                if (val == null) continue;
                result.add(val);
            }
            HashSet<OIdentifiable> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = firstEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null && (maxEntriesToFetch <= -1 || result.size() != maxEntriesToFetch)) {
                ODocument document = new ODocument();
                document.field("key", entry.getKey());
                document.field("rid", ((OIdentifiable)entry.getValue()).getIdentity());
                document.unsetDirty();
                result.add(document);
                entry = OMVRBTree.next(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            OMVRBTreeEntry entry = lastEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null && (maxEntriesToFetch <= -1 || result.size() != maxEntriesToFetch)) {
                ODocument document = new ODocument();
                document.field("key", entry.getKey());
                document.field("rid", ((OIdentifiable)entry.getValue()).getIdentity());
                document.unsetDirty();
                result.add(document);
                entry = OMVRBTree.previous(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        if (iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry firstEntry = iInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry == null) {
                Set<ODocument> set = Collections.emptySet();
                return set;
            }
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (!(entry == null || entry == lastEntry && this.map.getPageIndex() == lastEntryIndex || maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch)) {
                ODocument document = new ODocument();
                document.field("key", entry.getKey());
                document.field("rid", ((OIdentifiable)entry.getValue()).getIdentity());
                document.unsetDirty();
                result.add(document);
                entry = OMVRBTree.next(entry);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        this.acquireExclusiveLock();
        ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
        try {
            for (Object key : sortedKeys) {
                if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                    ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
                    return oDocumentFieldsHashSet;
                }
                OIdentifiable val = (OIdentifiable)this.map.get(key);
                if (val == null) continue;
                ODocument document = new ODocument();
                document.field("key", key);
                document.field("rid", val.getIdentity());
                document.unsetDirty();
                result.add(document);
            }
            ODocumentFieldsHashSet oDocumentFieldsHashSet = result;
            return oDocumentFieldsHashSet;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }
}

