/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;

public class OIndexUnique
extends OIndexOneValue {
    public static final String TYPE_ID = OClass.INDEX_TYPE.UNIQUE.toString();

    public OIndexUnique() {
        super(TYPE_ID);
    }

    public OIndexOneValue put(Object iKey, OIdentifiable iSingleValue) {
        this.acquireExclusiveLock();
        try {
            this.checkForKeyType(iKey);
            OIdentifiable value = (OIdentifiable)this.map.get(iKey);
            if (value != null) {
                if (!value.equals(iSingleValue)) {
                    throw new OIndexException("Found duplicated key '" + iKey + "' on unique index '" + this.name + "' for record " + iSingleValue.getIdentity() + ". The record already present in the index is " + value.getIdentity());
                }
                OIndexUnique oIndexUnique = this;
                return oIndexUnique;
            }
            if (!iSingleValue.getIdentity().isValid()) {
                ((ORecord)iSingleValue).save();
            }
            this.map.put(iKey, iSingleValue.getIdentity());
            OIndexUnique oIndexUnique = this;
            return oIndexUnique;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public boolean canBeUsedInEqualityOperators() {
        return true;
    }
}

