/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;

    static {
        HashSet<String> types = new HashSet<String>();
        types.add(OIndexUnique.TYPE_ID);
        types.add(OIndexNotUnique.TYPE_ID);
        types.add(OIndexFullText.TYPE_ID);
        types.add(OIndexDictionary.TYPE_ID);
        TYPES = Collections.unmodifiableSet(types);
    }

    @Override
    public Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public OIndexInternal<?> createIndex(ODatabaseRecord iDatabase, String iIndexType) throws OConfigurationException {
        if (OIndexUnique.TYPE_ID.equals(iIndexType)) {
            return new OIndexUnique();
        }
        if (OIndexNotUnique.TYPE_ID.equals(iIndexType)) {
            return new OIndexNotUnique();
        }
        if (OIndexFullText.TYPE_ID.equals(iIndexType)) {
            return new OIndexFullText();
        }
        if (OIndexDictionary.TYPE_ID.equals(iIndexType)) {
            return new OIndexDictionary();
        }
        throw new OConfigurationException("Unsupported type : " + iIndexType);
    }
}

