/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSimpleKeyIndexDefinition
extends ODocumentWrapperNoClass
implements OIndexDefinition {
    private OType[] keyTypes;

    public OSimpleKeyIndexDefinition(OType ... keyTypes) {
        super(new ODocument());
        this.keyTypes = keyTypes;
    }

    public OSimpleKeyIndexDefinition() {
    }

    @Override
    public List<String> getFields() {
        return Collections.emptyList();
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public Comparable<?> createValue(List<?> params) {
        return this.createValue(params != null ? params.toArray() : null);
    }

    @Override
    public Comparable<?> createValue(Object ... params) {
        if (params == null || params.length == 0) {
            return null;
        }
        if (this.keyTypes.length == 1) {
            return (Comparable)OType.convert(params[0], this.keyTypes[0].getDefaultJavaType());
        }
        OCompositeKey compositeKey = new OCompositeKey();
        int i = 0;
        while (i < params.length) {
            Comparable paramValue = (Comparable)OType.convert(params[i], this.keyTypes[i].getDefaultJavaType());
            if (paramValue == null) {
                return null;
            }
            compositeKey.addKey(paramValue);
            ++i;
        }
        return compositeKey;
    }

    @Override
    public int getParamCount() {
        return this.keyTypes.length;
    }

    @Override
    public OType[] getTypes() {
        return this.keyTypes;
    }

    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            ArrayList<String> keyTypeNames = new ArrayList<String>(this.keyTypes.length);
            OType[] oTypeArray = this.keyTypes;
            int n = this.keyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                OType keyType = oTypeArray[n2];
                keyTypeNames.add(keyType.toString());
                ++n2;
            }
            this.document.field("keyTypes", keyTypeNames, OType.EMBEDDEDLIST);
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    @Override
    protected void fromStream() {
        List keyTypeNames = (List)this.document.field("keyTypes");
        this.keyTypes = new OType[keyTypeNames.size()];
        int i = 0;
        for (String keyTypeName : keyTypeNames) {
            this.keyTypes[i] = OType.valueOf(keyTypeName);
            ++i;
        }
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        throw new OIndexException("This method is not supported in given index definition.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSimpleKeyIndexDefinition that = (OSimpleKeyIndexDefinition)o;
        return Arrays.equals((Object[])this.keyTypes, (Object[])that.keyTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keyTypes != null ? Arrays.hashCode((Object[])this.keyTypes) : 0);
        return result;
    }

    @Override
    public String toString() {
        return "OSimpleKeyIndexDefinition{keyTypes=" + (this.keyTypes == null ? null : Arrays.asList(this.keyTypes)) + '}';
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType) {
        StringBuilder ddl = new StringBuilder("create index ");
        ddl.append(indexName).append(" ").append(indexType).append(" ");
        if (this.keyTypes != null && this.keyTypes.length > 0) {
            ddl.append(this.keyTypes[0].toString());
            int i = 1;
            while (i < this.keyTypes.length) {
                ddl.append(", ").append(this.keyTypes[i].toString());
                ++i;
            }
        }
        return ddl.toString();
    }
}

