/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSchemaShared
extends ODocumentWrapperNoClass
implements OSchema,
OCloseable {
    public static final int CURRENT_VERSION_NUMBER = 4;
    private static final String DROP_INDEX_QUERY = "drop index ";
    protected Map<String, OClass> classes = new HashMap<String, OClass>();
    private final OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);

    public OSchemaShared(int schemaClusterId) {
        super(new ODocument());
    }

    @Override
    public int countClasses() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        this.lock.acquireSharedLock();
        try {
            int n = this.classes.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OClass createClass(Class<?> iClass) {
        Class<?> superClass = iClass.getSuperclass();
        OClass cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
        return this.createClass(iClass.getSimpleName(), cls, OStorage.CLUSTER_TYPE.PHYSICAL);
    }

    @Override
    public OClass createClass(Class<?> iClass, int iDefaultClusterId) {
        Class<?> superClass = iClass.getSuperclass();
        OClass cls = superClass != null && superClass != Object.class && this.existsClass(superClass.getSimpleName()) ? this.getClass(superClass.getSimpleName()) : null;
        return this.createClass(iClass.getSimpleName(), cls, iDefaultClusterId);
    }

    @Override
    public OClass createClass(String iClassName) {
        return this.createClass(iClassName, null, OStorage.CLUSTER_TYPE.PHYSICAL);
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass) {
        return this.createClass(iClassName, iSuperClass, OStorage.CLUSTER_TYPE.PHYSICAL);
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, OStorage.CLUSTER_TYPE iType) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create a new class inside a transaction");
        }
        int clusterId = this.getDatabase().getClusterIdByName(iClassName);
        if (clusterId == -1) {
            clusterId = this.getDatabase().addCluster(iType.toString(), iClassName, null, null, new Object[0]);
        }
        return this.createClass(iClassName, iSuperClass, clusterId);
    }

    @Override
    public OClass createClass(String iClassName, int iDefaultClusterId) {
        return this.createClass(iClassName, null, new int[]{iDefaultClusterId});
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, int iDefaultClusterId) {
        return this.createClass(iClassName, iSuperClass, new int[]{iDefaultClusterId});
    }

    @Override
    public OClass getOrCreateClass(String iClassName) {
        this.lock.acquireExclusiveLock();
        try {
            OClass cls = this.classes.get(iClassName.toLowerCase());
            if (cls == null) {
                cls = this.createClass(iClassName);
            }
            OClass oClass = cls;
            return oClass;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public OClass createClass(String iClassName, OClass iSuperClass, int[] iClusterIds) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_CREATE);
        String key = iClassName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class " + iClassName + " already exists in current database");
            }
            StringBuilder cmd = new StringBuilder("create class ");
            cmd.append(iClassName);
            if (iSuperClass != null) {
                cmd.append(" extends ");
                cmd.append(iSuperClass.getName());
            }
            if (iClusterIds != null) {
                cmd.append(" cluster ");
                int i = 0;
                while (i < iClusterIds.length) {
                    if (i > 0) {
                        cmd.append(',');
                    } else {
                        cmd.append(' ');
                    }
                    cmd.append(iClusterIds[i]);
                    ++i;
                }
            }
            this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
            this.getDatabase().reload();
            if (this.classes.containsKey(key)) {
                OClass oClass = this.classes.get(key);
                return oClass;
            }
            this.createClassInternal(iClassName, iSuperClass, iClusterIds);
            OClass oClass = this.classes.get(key);
            return oClass;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public OClass createClassInternal(String iClassName, OClass iSuperClass, int[] iClusterIds) {
        if (iClassName == null || iClassName.length() == 0) {
            throw new OSchemaException("Found class name null");
        }
        Character wrongCharacter = OSchemaShared.checkNameIfValid(iClassName);
        if (wrongCharacter != null) {
            throw new OSchemaException("Found invalid class name. Character '" + wrongCharacter + "' cannot be used in class name.");
        }
        if (iClusterIds == null || iClusterIds.length == 0) {
            iClusterIds = new int[]{this.getDatabase().addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), iClassName, null, null, new Object[0])};
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_CREATE);
        String key = iClassName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class " + iClassName + " already exists in current database");
            }
            OClassImpl cls = new OClassImpl(this, iClassName, iClusterIds);
            this.classes.put(key, cls);
            if (cls.getShortName() != null) {
                this.classes.put(cls.getShortName().toLowerCase(), cls);
            }
            if (iSuperClass != null) {
                cls.setSuperClassInternal(iSuperClass);
            }
            OClassImpl oClassImpl = cls;
            return oClassImpl;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public static Character checkNameIfValid(String iName) {
        if (iName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if ((iName = iName.trim()).length() == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        int i = 0;
        while (i < iName.length()) {
            char c = iName.charAt(i);
            if (c == ':' || c == ',') {
                return Character.valueOf(c);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void dropClass(String iClassName) {
        if (iClassName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        String key = iClassName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            OClass cls = this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class " + iClassName + " was not found in current database");
            }
            if (cls.getBaseClasses() != null) {
                throw new OSchemaException("Class " + iClassName + " cannot be dropped because it has sub classes. Remove the dependencies before trying to drop it again");
            }
            StringBuilder cmd = new StringBuilder("drop class ");
            cmd.append(iClassName);
            this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
            this.getDatabase().reload();
            this.reload();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void dropClassInternal(String iClassName) {
        if (iClassName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        String key = iClassName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            OClass cls = this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class " + iClassName + " was not found in current database");
            }
            if (cls.getBaseClasses() != null) {
                throw new OSchemaException("Class " + iClassName + " cannot be dropped because it has sub classes. Remove the dependencies before trying to drop it again");
            }
            if (cls.getSuperClass() != null) {
                ((OClassImpl)cls.getSuperClass()).removeBaseClassInternal(cls);
            }
            this.dropClassIndexes(cls);
            this.classes.remove(key);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    private void dropClassIndexes(OClass cls) {
        for (OIndex<?> index : this.getDatabase().getMetadata().getIndexManager().getClassIndexes(cls.getName())) {
            this.getDatabase().command(new OCommandSQL(DROP_INDEX_QUERY + index.getName()));
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        this.getDatabase().getStorage().callInLock(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                OSchemaShared.this.lock.acquireExclusiveLock();
                try {
                    OSchemaShared.this.reload(null);
                }
                finally {
                    OSchemaShared.this.lock.releaseExclusiveLock();
                }
                return null;
            }
        }, false);
        return (RET)this;
    }

    @Override
    public boolean existsClass(String iClassName) {
        this.lock.acquireSharedLock();
        try {
            boolean bl = this.classes.containsKey(iClassName.toLowerCase());
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OClass getClass(Class<?> iClass) {
        return this.getClass(iClass.getSimpleName());
    }

    @Override
    public OClass getClass(String iClassName) {
        Class<?> javaClass;
        ODatabaseComplex<?> ownerDb;
        OClass cls;
        if (iClassName == null) {
            return null;
        }
        this.lock.acquireSharedLock();
        try {
            cls = this.classes.get(iClassName.toLowerCase());
        }
        finally {
            this.lock.releaseSharedLock();
        }
        if (cls == null && (ownerDb = this.getDatabase().getDatabaseOwner()) instanceof ODatabaseObject && (javaClass = ((ODatabaseObject)ownerDb).getEntityManager().getEntityClass(iClassName)) != null) {
            cls = this.cascadeCreate(javaClass);
        }
        return cls;
    }

    public void changeClassName(String iOldName, String iNewName) {
        OClass clazz = this.classes.remove(iOldName.toLowerCase());
        this.classes.put(iNewName.toLowerCase(), clazz);
    }

    @Override
    public void fromStream() {
        OClassImpl cls;
        int schemaVersion = (Integer)this.document.field("schemaVersion");
        if (schemaVersion != 4) {
            throw new OConfigurationException("Database schema is different. Please export your old database with the previous version of OrientDB and reimport it using the current one.");
        }
        this.classes.clear();
        Collection storedClasses = (Collection)this.document.field("classes");
        for (ODocument c : storedClasses) {
            cls = new OClassImpl(this, c);
            cls.fromStream();
            this.classes.put(cls.getName().toLowerCase(), cls);
            if (cls.getShortName() == null) continue;
            this.classes.put(cls.getShortName().toLowerCase(), cls);
        }
        for (ODocument c : storedClasses) {
            String superClassName = (String)c.field("superClass");
            if (superClassName == null) continue;
            cls = (OClassImpl)this.classes.get(((String)c.field("name")).toLowerCase());
            OClass superClass = this.classes.get(superClassName.toLowerCase());
            if (superClass == null) {
                throw new OConfigurationException("Super class '" + superClassName + "' was declared in class '" + cls.getName() + "' but was not found in schema. Remove the dependency or create the class to continue.");
            }
            cls.setSuperClassInternal(superClass);
        }
    }

    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("schemaVersion", 4);
            HashSet<ODocument> cc = new HashSet<ODocument>();
            for (OClass c : this.classes.values()) {
                cc.add(((OClassImpl)c).toStream());
            }
            this.document.field("classes", cc, OType.EMBEDDEDSET);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public Collection<OClass> getClasses() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        this.lock.acquireSharedLock();
        try {
            HashSet<OClass> hashSet = new HashSet<OClass>(this.classes.values());
            return hashSet;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public OSchemaShared load() {
        this.lock.acquireExclusiveLock();
        try {
            this.getDatabase();
            ((ORecordId)this.document.getIdentity()).fromString(this.getDatabase().getStorage().getConfiguration().schemaRecordId);
            super.reload("*:-1 index:0");
            OSchemaShared oSchemaShared = this;
            return oSchemaShared;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void create() {
        ODatabaseRecord db = this.getDatabase();
        super.save("internal");
        db.getStorage().getConfiguration().schemaRecordId = this.document.getIdentity().toString();
        db.getStorage().getConfiguration().update();
    }

    public void saveInternal() {
        this.getDatabase();
        if (this.document.getDatabase().getTransaction().isActive()) {
            throw new OSchemaException("Cannot change the schema while a transaction is active. Schema changes are not transactional");
        }
        this.lock.acquireExclusiveLock();
        try {
            this.document.setDirty();
            super.save();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int getVersion() {
        this.lock.acquireSharedLock();
        try {
            int n = this.document.getVersion();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public ORID getIdentity() {
        return this.document.getIdentity();
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        return (RET)this;
    }

    @Override
    public <RET extends ODocumentWrapper> RET save(String iClusterName) {
        return (RET)this;
    }

    public OSchemaShared setDirty() {
        this.document.setDirty();
        return this;
    }

    private OClass cascadeCreate(Class<?> javaClass) {
        OClassImpl cls = (OClassImpl)this.createClass(javaClass.getSimpleName());
        Class<?> javaSuperClass = javaClass.getSuperclass();
        if (javaSuperClass != null && !javaSuperClass.getName().equals("java.lang.Object")) {
            OClass superClass = this.classes.get(javaSuperClass.getSimpleName().toLowerCase());
            if (superClass == null) {
                superClass = this.cascadeCreate(javaSuperClass);
            }
            cls.setSuperClass(superClass);
        }
        return cls;
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void close() {
        this.classes.clear();
        this.document.reset();
    }
}

