/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSecurityShared
extends OSharedResourceAdaptive
implements OSecurity,
OCloseable {
    @Override
    public OUser authenticate(String iUserName, String iUserPassword) {
        this.acquireExclusiveLock();
        try {
            String dbName = this.getDatabase().getName();
            OUser user = this.getUser(iUserName);
            if (user == null) {
                throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
            }
            if (user.getAccountStatus() != OUser.STATUSES.ACTIVE) {
                throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
            }
            if (this.getDatabase().getStorage() instanceof OStorageEmbedded && !user.checkPassword(iUserPassword)) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
            }
            OUser oUser = user;
            return oUser;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OUser getUser(String iUserName) {
        this.acquireExclusiveLock();
        try {
            List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser where name = '" + iUserName + "' limit 1").setFetchPlan("*:-1")).execute(new Object[0]);
            if (result != null && !result.isEmpty()) {
                OUser oUser = new OUser((ODocument)result.get(0));
                return oUser;
            }
            return null;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OUser createUser(String iUserName, String iUserPassword, String[] iRoles) {
        this.acquireExclusiveLock();
        try {
            OUser user = new OUser(iUserName, iUserPassword);
            if (iRoles != null) {
                String[] stringArray = iRoles;
                int n = iRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    String r = stringArray[n2];
                    user.addRole(r);
                    ++n2;
                }
            }
            OUser oUser = user.save();
            return oUser;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean dropUser(String iUserName) {
        this.acquireExclusiveLock();
        try {
            Number removed = (Number)this.getDatabase().command(new OSQLSynchQuery("delete from OUser where name = '" + iUserName + "'")).execute(new Object[0]);
            boolean bl = removed != null && removed.intValue() > 0;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ORole getRole(String iRoleName) {
        this.acquireExclusiveLock();
        try {
            List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole where name = '" + iRoleName + "' limit 1").setFetchPlan("*:-1")).execute(new Object[0]);
            if (result != null && !result.isEmpty()) {
                ORole oRole = new ORole((ODocument)result.get(0));
                return oRole;
            }
            return null;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ORole createRole(String iRoleName, ORole.ALLOW_MODES iAllowMode) {
        return this.createRole(iRoleName, null, iAllowMode);
    }

    @Override
    public ORole createRole(String iRoleName, ORole iParent, ORole.ALLOW_MODES iAllowMode) {
        this.acquireExclusiveLock();
        try {
            ORole role = new ORole(iRoleName, iParent, iAllowMode);
            ORole oRole = role.save();
            return oRole;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public boolean dropRole(String iRoleName) {
        this.acquireExclusiveLock();
        try {
            Number removed = (Number)this.getDatabase().command(new OSQLSynchQuery("delete from ORole where name = '" + iRoleName + "'")).execute(new Object[0]);
            boolean bl = removed != null && removed.intValue() > 0;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public List<ODocument> getAllUsers() {
        this.acquireExclusiveLock();
        try {
            List list = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser")).execute(new Object[0]);
            return list;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public List<ODocument> getAllRoles() {
        this.acquireExclusiveLock();
        try {
            List list = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole")).execute(new Object[0]);
            return list;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OUser create() {
        this.acquireExclusiveLock();
        try {
            if (!this.getDatabase().getMetadata().getSchema().getClasses().isEmpty()) {
                throw new OSecurityException("Default users and roles already installed");
            }
            OUser adminUser = this.createMetadata();
            ORole readerRole = this.createRole("reader", ORole.ALLOW_MODES.DENY_ALL_BUT);
            readerRole.addRule("database", ORole.PERMISSION_READ);
            readerRole.addRule("database.schema", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.internal", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.orole", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.ouser", ORole.PERMISSION_READ);
            readerRole.addRule("database.class.*", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.*", ORole.PERMISSION_READ);
            readerRole.addRule("database.command", ORole.PERMISSION_READ);
            readerRole.addRule("database.hook.record", ORole.PERMISSION_READ);
            readerRole.save();
            this.createUser("reader", "reader", new String[]{readerRole.getName()});
            ORole writerRole = this.createRole("writer", ORole.ALLOW_MODES.DENY_ALL_BUT);
            writerRole.addRule("database", ORole.PERMISSION_READ);
            writerRole.addRule("database.schema", ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
            writerRole.addRule("database.cluster.internal", ORole.PERMISSION_READ);
            writerRole.addRule("database.cluster.orole", ORole.PERMISSION_READ);
            writerRole.addRule("database.cluster.ouser", ORole.PERMISSION_READ);
            writerRole.addRule("database.class.*", ORole.PERMISSION_ALL);
            writerRole.addRule("database.cluster.*", ORole.PERMISSION_ALL);
            writerRole.addRule("database.command", ORole.PERMISSION_ALL);
            writerRole.addRule("database.hook.record", ORole.PERMISSION_ALL);
            writerRole.save();
            this.createUser("writer", "writer", new String[]{writerRole.getName()});
            OUser oUser = adminUser;
            return oUser;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OUser repair() {
        this.acquireExclusiveLock();
        try {
            OUser oUser = this.createMetadata();
            return oUser;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected OUser createMetadata() {
        OUser adminUser;
        ORole adminRole;
        OClass userClass;
        ODatabaseRecord database = this.getDatabase();
        OClass roleClass = database.getMetadata().getSchema().getClass("ORole");
        if (roleClass == null) {
            roleClass = database.getMetadata().getSchema().createClass("ORole");
        }
        if (!roleClass.existsProperty("name")) {
            roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!roleClass.existsProperty("mode")) {
            roleClass.createProperty("mode", OType.BYTE);
        }
        if (!roleClass.existsProperty("rules")) {
            roleClass.createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE);
        }
        if ((userClass = database.getMetadata().getSchema().getClass("OUser")) == null) {
            userClass = database.getMetadata().getSchema().createClass("OUser");
        }
        if (!userClass.existsProperty("name")) {
            userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("password")) {
            userClass.createProperty("password", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("roles")) {
            userClass.createProperty("roles", OType.LINKSET, roleClass);
        }
        if ((adminRole = this.getRole("admin")) == null) {
            adminRole = this.createRole("admin", ORole.ALLOW_MODES.ALLOW_ALL_BUT);
        }
        if ((adminUser = this.getUser("admin")) == null) {
            adminUser = this.createUser("admin", "admin", new String[]{adminRole.getName()});
        }
        return adminUser;
    }

    @Override
    public void close() {
    }

    @Override
    public void load() {
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

