/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.nativ;

import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.nativ.ONativeQuery;
import com.orientechnologies.orient.core.query.nativ.OQueryContextNative;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ONativeAsynchQuery<CTX extends OQueryContextNative>
extends ONativeQuery<CTX> {
    protected int resultCount = 0;
    protected ORecordInternal<?> record;

    public ONativeAsynchQuery(String iCluster, CTX iQueryRecordImpl) {
        this(iCluster, iQueryRecordImpl, null);
    }

    public ONativeAsynchQuery(String iCluster, CTX iQueryRecordImpl, OCommandResultListener iResultListener) {
        super(iCluster);
        this.resultListener = iResultListener;
        this.queryRecord = iQueryRecordImpl;
        this.record = new ODocument();
    }

    @Deprecated
    public ONativeAsynchQuery(ODatabaseRecord iDatabase, String iCluster, CTX iQueryRecordImpl, OCommandResultListener iResultListener) {
        this(iCluster, iQueryRecordImpl, iResultListener);
    }

    public boolean isAsynchronous() {
        return this.resultListener != this;
    }

    public boolean foreach(ORecordInternal<?> iRecord) {
        ODocument record = (ODocument)iRecord;
        this.queryRecord.setRecord(record);
        if (this.filter(this.queryRecord)) {
            ++this.resultCount;
            this.resultListener.result(record.copy());
            if (this.limit > -1 && this.resultCount == this.limit) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<ODocument> run(Object ... iArgs) {
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (!(database.getStorage() instanceof OStorageEmbedded)) {
            throw new OCommandExecutionException("Native queries can run only in embedded-local version. Not in the remote one.");
        }
        this.queryRecord.setSourceQuery(this);
        OClass cls = database.getMetadata().getSchema().getClass(this.className);
        if (cls == null) {
            throw new OCommandExecutionException("Class '" + this.className + "' was not found");
        }
        ORecordIteratorClass target = new ORecordIteratorClass(database, (ODatabaseRecordAbstract)database, this.className, this.isPolymorphic());
        for (OIdentifiable id : target) {
            ORecordInternal record = (ORecordInternal)id.getRecord();
            if (record != null && record.getRecordType() != 100) continue;
            this.queryRecord.setRecord((ODocument)record);
            if (!this.filter(this.queryRecord)) continue;
            ++this.resultCount;
            this.resultListener.result(record.copy());
            if (this.limit > -1 && this.resultCount == this.limit) break;
        }
        return null;
    }

    @Override
    public ODocument runFirst(Object ... iArgs) {
        this.setLimit(1);
        this.execute(new Object[0]);
        return null;
    }

    @Override
    public OCommandResultListener getResultListener() {
        return this.resultListener;
    }

    @Override
    public void setResultListener(OCommandResultListener resultListener) {
        this.resultListener = resultListener;
    }
}

