/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordAbstract<T>
implements ORecord<T>,
ORecordInternal<T> {
    protected ORecordId _recordId;
    protected int _version;
    protected byte[] _source;
    protected int _size;
    protected String _dataSegmentName;
    protected transient ORecordSerializer _recordFormat;
    protected Boolean _pinned = null;
    protected boolean _dirty = true;
    protected ORecordElement.STATUS _status = ORecordElement.STATUS.LOADED;
    protected transient Set<ORecordListener> _listeners = null;

    public ORecordAbstract() {
    }

    public ORecordAbstract(byte[] iSource) {
        this._source = iSource;
        this._size = iSource.length;
        this.unsetDirty();
    }

    @Override
    public ORecordAbstract<?> fill(ORecordId iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this._recordId.clusterId = iRid.clusterId;
        this._recordId.clusterPosition = iRid.clusterPosition;
        this._version = iVersion;
        this._status = ORecordElement.STATUS.LOADED;
        this._source = iBuffer;
        int n = this._size = iBuffer != null ? iBuffer.length : 0;
        if (this._source != null && this._source.length > 0) {
            this._dirty = iDirty;
        }
        return this;
    }

    @Override
    public ORID getIdentity() {
        return this._recordId;
    }

    public ORecord<?> getRecord() {
        return this;
    }

    @Override
    public ORecordAbstract<?> setIdentity(int iClusterId, long iClusterPosition) {
        if (this._recordId == null || this._recordId == ORecordId.EMPTY_RECORD_ID) {
            this._recordId = new ORecordId(iClusterId, iClusterPosition);
        } else {
            this._recordId.clusterId = iClusterId;
            this._recordId.clusterPosition = iClusterPosition;
        }
        return this;
    }

    @Override
    public ORecordAbstract<?> setIdentity(ORecordId iIdentity) {
        this._recordId = iIdentity;
        return this;
    }

    @Override
    public boolean detach() {
        return true;
    }

    @Override
    public ORecordAbstract<T> clear() {
        this.setDirty();
        this.invokeListenerEvent(ORecordListener.EVENT.CLEAR);
        return this;
    }

    @Override
    public ORecordAbstract<T> reset() {
        this._status = ORecordElement.STATUS.LOADED;
        this._version = 0;
        this.setDirty();
        if (this._recordId != null) {
            this._recordId.reset();
        }
        this.invokeListenerEvent(ORecordListener.EVENT.RESET);
        return this;
    }

    @Override
    public byte[] toStream() {
        if (this._source == null) {
            this._source = this._recordFormat.toStream(this, false);
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    @Override
    public ORecordAbstract<T> fromStream(byte[] iRecordBuffer) {
        this._dirty = false;
        this._source = iRecordBuffer;
        this._size = iRecordBuffer != null ? iRecordBuffer.length : 0;
        this._status = ORecordElement.STATUS.LOADED;
        this.invokeListenerEvent(ORecordListener.EVENT.UNMARSHALL);
        return this;
    }

    @Override
    public void unsetDirty() {
        if (this._dirty) {
            this._dirty = false;
        }
    }

    public ORecordAbstract<T> setDirty() {
        if (!this._dirty && this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this._dirty = true;
        }
        this._source = null;
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
        this.invokeListenerEvent(ORecordListener.EVENT.IDENTITY_CHANGED);
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public Boolean isPinned() {
        return this._pinned;
    }

    @Override
    public ORecordAbstract<T> pin() {
        this._pinned = Boolean.TRUE;
        return this;
    }

    @Override
    public ORecordAbstract<T> unpin() {
        this._pinned = Boolean.FALSE;
        return this;
    }

    @Override
    public <RET extends ORecord<T>> RET fromJSON(String iSource) {
        ORecordSerializerJSON.INSTANCE.fromString(iSource, this);
        return (RET)this;
    }

    @Override
    public String toJSON() {
        return this.toJSON("rid,version,class,type,attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0");
    }

    @Override
    public String toJSON(String iFormat) {
        return ORecordSerializerJSON.INSTANCE.toString(this, new StringBuilder(), iFormat).toString();
    }

    public String toString() {
        return (this._recordId.isValid() ? this._recordId : "") + (this._source != null ? Arrays.toString(this._source) : "[]") + " v" + this._version;
    }

    @Override
    public String getDataSegmentName() {
        return this._dataSegmentName;
    }

    @Override
    public <RET extends ORecord<T>> RET setDataSegmentName(String iName) {
        if (this._recordId.isValid()) {
            throw new IllegalStateException("Cannot assign a data segment to a not new record");
        }
        this._dataSegmentName = iName;
        return (RET)this;
    }

    @Override
    public int getVersion() {
        this.checkForLoading();
        return this._version;
    }

    @Override
    public void setVersion(int iVersion) {
        this._version = iVersion;
    }

    @Override
    public ORecordAbstract<T> unload() {
        this._status = ORecordElement.STATUS.NOT_LOADED;
        this._source = null;
        this.unsetDirty();
        this.invokeListenerEvent(ORecordListener.EVENT.UNLOAD);
        return this;
    }

    @Override
    public ORecordInternal<T> load() {
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException("The record has no id, probably it's new or transient yet ");
        }
        try {
            ORecordInternal result = (ORecordInternal)this.getDatabase().load(this);
            if (result == null) {
                throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' not found");
            }
            return result;
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' not found", e);
        }
    }

    @Override
    public ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public ORecordInternal<T> reload() {
        return this.reload(null);
    }

    public ORecordInternal<T> reload(String iFetchPlan) {
        return this.reload(null, true);
    }

    public ORecordInternal<T> reload(String iFetchPlan, boolean iIgnoreCache) {
        if (!this.getIdentity().isValid()) {
            throw new ORecordNotFoundException("The record has no id. It is probably new or still transient");
        }
        try {
            this.getDatabase().reload(this, iFetchPlan, iIgnoreCache);
            return this;
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' not found", e);
        }
    }

    @Override
    public ORecordAbstract<T> save() {
        this.getDatabase().save(this);
        return this;
    }

    @Override
    public ORecordAbstract<T> save(String iClusterName) {
        this.getDatabase().save(this, iClusterName);
        return this;
    }

    @Override
    public ORecordAbstract<T> delete() {
        this.getDatabase().delete(this);
        this.setDirty();
        return this;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    protected void setup() {
        if (this._recordId == null) {
            this._recordId = new ORecordId();
        }
    }

    public int hashCode() {
        return this._recordId != null ? this._recordId.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof OIdentifiable) {
            return this._recordId.equals(((OIdentifiable)obj).getIdentity());
        }
        return false;
    }

    @Override
    public int compare(OIdentifiable iFirst, OIdentifiable iSecond) {
        if (iFirst == null || iSecond == null) {
            return -1;
        }
        return iFirst.compareTo(iSecond);
    }

    @Override
    public int compareTo(OIdentifiable iOther) {
        if (iOther == null) {
            return 1;
        }
        if (this._recordId == null) {
            return iOther.getIdentity() == null ? 0 : 1;
        }
        return this._recordId.compareTo(iOther.getIdentity());
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this._status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this._status = iStatus;
    }

    public ORecordAbstract<T> copyTo(ORecordAbstract<T> cloned) {
        cloned._source = this._source;
        cloned._size = this._size;
        cloned._recordId = this._recordId.copy();
        cloned._version = this._version;
        cloned._pinned = this._pinned;
        cloned._status = this._status;
        cloned._recordFormat = this._recordFormat;
        cloned._listeners = null;
        cloned._dirty = false;
        return cloned;
    }

    @Override
    public void addListener(ORecordListener iListener) {
        if (this._listeners == null) {
            this._listeners = Collections.newSetFromMap(new WeakHashMap());
        }
        this._listeners.add(iListener);
    }

    @Override
    public void removeListener(ORecordListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    protected void invokeListenerEvent(ORecordListener.EVENT iEvent) {
        if (this._listeners != null) {
            for (ORecordListener listener : this._listeners) {
                if (listener == null) continue;
                listener.onEvent(this, iEvent);
            }
        }
    }

    @Override
    public <RET extends ORecord<T>> RET flatCopy() {
        return this.copy();
    }

    protected void checkForLoading() {
        if (this._status == ORecordElement.STATUS.NOT_LOADED && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            this.reload(null, true);
        }
    }
}

