/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODocumentComparator
implements Comparator<OIdentifiable> {
    private List<OPair<String, String>> orderCriteria;

    public ODocumentComparator(List<OPair<String, String>> iOrderCriteria) {
        this.orderCriteria = iOrderCriteria;
    }

    @Override
    public int compare(OIdentifiable iDoc1, OIdentifiable iDoc2) {
        if (iDoc1 != null && iDoc1.equals(iDoc2)) {
            return 0;
        }
        int partialResult = 0;
        for (OPair<String, String> field : this.orderCriteria) {
            Object fieldValue1 = ((ODocument)iDoc1.getRecord()).field((String)field.getKey());
            if (fieldValue1 == null) {
                return this.factor(-1, field.getValue());
            }
            Object fieldValue2 = ((ODocument)iDoc2.getRecord()).field((String)field.getKey());
            if (fieldValue2 == null) {
                return this.factor(1, field.getValue());
            }
            if (!(fieldValue1 instanceof Comparable)) {
                throw new IllegalArgumentException("Cannot sort documents because the field '" + (String)field.getKey() + "' is not comparable");
            }
            partialResult = ((Comparable)fieldValue1).compareTo(fieldValue2);
            if ((partialResult = this.factor(partialResult, field.getValue())) != 0) break;
        }
        return partialResult;
    }

    private int factor(int partialResult, String iOrdering) {
        if (iOrdering.equals("DESC")) {
            return partialResult * -1;
        }
        return partialResult;
    }
}

