/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordBytes
extends ORecordAbstract<byte[]> {
    public static final byte RECORD_TYPE = 98;
    private static final byte[] EMPTY_SOURCE = new byte[0];

    public ORecordBytes() {
        this.setup();
    }

    public ORecordBytes(ODatabaseRecord iDatabase) {
        this.setup();
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordBytes(ODatabaseRecord iDatabase, byte[] iSource) {
        this(iSource);
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordBytes(byte[] iSource) {
        super(iSource);
        this._dirty = true;
        this.setup();
    }

    public ORecordBytes(ORID iRecordId) {
        this._recordId = (ORecordId)iRecordId;
        this.setup();
    }

    public ORecordBytes reset(byte[] iSource) {
        this.reset();
        this._source = iSource;
        return this;
    }

    @Override
    public ORecordBytes copy() {
        return (ORecordBytes)this.copyTo(new ORecordBytes());
    }

    @Override
    public ORecordBytes fromStream(byte[] iRecordBuffer) {
        this._source = iRecordBuffer;
        this._status = ORecordElement.STATUS.LOADED;
        return this;
    }

    @Override
    public byte[] toStream() {
        return this._source;
    }

    @Override
    public byte getRecordType() {
        return 98;
    }

    @Override
    protected void setup() {
        super.setup();
        this._recordFormat = ORecordSerializerFactory.instance().getFormat("ORecordDocumentRaw");
    }

    public int fromInputStream(InputStream in) throws IOException {
        OMemoryStream out = new OMemoryStream();
        try {
            int b;
            while ((b = in.read()) > -1) {
                out.write(b);
            }
            out.flush();
            this._source = out.toByteArray();
        }
        finally {
            out.close();
        }
        this._size = this._source.length;
        return this._size;
    }

    public int fromInputStream(InputStream in, int iMaxSize) throws IOException {
        byte[] buffer = new byte[iMaxSize];
        int readBytesCount = in.read(buffer);
        if (readBytesCount == -1) {
            this._source = EMPTY_SOURCE;
            this._size = 0;
        } else if (readBytesCount == iMaxSize) {
            this._source = buffer;
            this._size = iMaxSize;
        } else {
            this._source = Arrays.copyOf(buffer, readBytesCount);
            this._size = readBytesCount;
        }
        return this._size;
    }

    public void toOutputStream(OutputStream out) throws IOException {
        this.checkForLoading();
        if (this._source.length > 0) {
            out.write(this._source);
        }
    }
}

