/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Arrays;

public class OJSONReader {
    private BufferedReader in;
    private int cursor = 0;
    private int lineNumber = 0;
    private int columnNumber = 0;
    private StringBuilder buffer = new StringBuilder();
    private String value;
    private char c;
    private Character missedChar;
    public static final char NEW_LINE = '\n';
    public static final char[] DEFAULT_JUMP = new char[]{' ', '\r', '\n', '\t'};
    public static final char[] BEGIN_OBJECT = new char[]{'{'};
    public static final char[] END_OBJECT = new char[]{'}'};
    public static final char[] FIELD_ASSIGNMENT = new char[]{':'};
    public static final char[] BEGIN_STRING = new char[]{'\"'};
    public static final char[] COMMA_SEPARATOR = new char[]{','};
    public static final char[] NEXT_IN_OBJECT = new char[]{',', '}'};
    public static final char[] NEXT_IN_ARRAY = new char[]{',', ']'};
    public static final char[] NEXT_OBJ_IN_ARRAY = new char[]{'{', ']'};
    public static final char[] ANY_NUMBER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] BEGIN_COLLECTION = new char[]{'['};
    public static final char[] END_COLLECTION = new char[]{']'};

    public OJSONReader(InputStreamReader iIn) {
        this.in = new BufferedReader(iIn);
    }

    public int getCursor() {
        return this.cursor;
    }

    public OJSONReader checkContent(String iExpected) throws ParseException {
        if (!this.value.equals(iExpected)) {
            throw new ParseException("Expected content is " + iExpected + " but found " + this.value, this.cursor);
        }
        return this;
    }

    public boolean isContent(String iExpected) {
        return this.value.equals(iExpected);
    }

    public int readInteger(char[] iUntil) throws IOException, ParseException {
        return this.readNumber(iUntil, false);
    }

    public int readNumber(char[] iUntil, boolean iInclude) throws IOException, ParseException {
        if (this.readNext(iUntil, iInclude) == null) {
            throw new ParseException("Expected integer", this.cursor);
        }
        return Integer.parseInt(this.value.trim());
    }

    public String readString(char[] iUntil) throws IOException, ParseException {
        return this.readString(iUntil, false);
    }

    public String readString(char[] iUntil, boolean iInclude) throws IOException, ParseException {
        if (this.readNext(iUntil, iInclude) == null) {
            return null;
        }
        if (!iInclude && this.value.startsWith("\"")) {
            return this.value.substring(1, this.value.lastIndexOf("\""));
        }
        return this.value;
    }

    public OJSONReader readNext(char[] iUntil) throws IOException, ParseException {
        this.readNext(iUntil, false);
        return this;
    }

    public OJSONReader readNext(char[] iUntil, boolean iInclude) throws IOException, ParseException {
        this.readNext(iUntil, iInclude, DEFAULT_JUMP);
        return this;
    }

    public OJSONReader readNext(char[] iUntil, boolean iInclude, char[] iJumpChars) throws IOException, ParseException {
        boolean found;
        if (!this.in.ready()) {
            return this;
        }
        this.jump(iJumpChars);
        if (!this.in.ready()) {
            return this;
        }
        int openBrackets = 0;
        int beginStringChar = 32;
        boolean encodeMode = false;
        do {
            found = false;
            if (beginStringChar == 32) {
                char u;
                int n;
                int n2;
                char[] cArray;
                if (openBrackets == 0) {
                    cArray = iUntil;
                    n2 = iUntil.length;
                    n = 0;
                    while (n < n2) {
                        u = cArray[n];
                        if (u == this.c) {
                            found = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (this.c == '\'' || this.c == '\"' && !encodeMode) {
                    beginStringChar = this.c;
                } else if (this.c == '{') {
                    ++openBrackets;
                } else if (this.c == '}' && openBrackets > 0) {
                    --openBrackets;
                }
                if (!found && openBrackets == 0) {
                    cArray = iUntil;
                    n2 = iUntil.length;
                    n = 0;
                    while (n < n2) {
                        u = cArray[n];
                        if (u == this.c) {
                            found = true;
                            break;
                        }
                        ++n;
                    }
                }
            } else if (beginStringChar == this.c && !encodeMode) {
                beginStringChar = 32;
            }
            encodeMode = this.c == '\\' && !encodeMode;
            if (found) continue;
            this.c = this.nextChar();
            this.buffer.append(this.c);
        } while (!found && this.in.ready());
        if (this.buffer.length() == 0) {
            throw new ParseException("Expected characters '" + Arrays.toString(iUntil) + "' not found", this.cursor);
        }
        if (!iInclude) {
            this.buffer.setLength(this.buffer.length() - 1);
        }
        this.value = this.buffer.toString();
        return this;
    }

    public char jump(char[] iJumpChars) throws IOException, ParseException {
        this.buffer.setLength(0);
        if (!this.in.ready()) {
            return '\u0000';
        }
        boolean go = true;
        block0: while (go && this.in.ready()) {
            this.c = this.nextChar();
            go = false;
            char[] cArray = iJumpChars;
            int n = iJumpChars.length;
            int n2 = 0;
            while (n2 < n) {
                char j = cArray[n2];
                if (j == this.c) {
                    go = true;
                    continue block0;
                }
                ++n2;
            }
        }
        this.buffer.append(this.c);
        return this.c;
    }

    private char nextChar() throws IOException {
        if (this.missedChar != null) {
            this.c = this.missedChar.charValue();
            this.missedChar = null;
        } else {
            this.c = (char)this.in.read();
            if (this.c == '\\') {
                char c2 = (char)this.in.read();
                if (c2 == 'u') {
                    StringBuilder buff = new StringBuilder();
                    int i = 0;
                    while (i < 4) {
                        buff.append((char)this.in.read());
                        ++i;
                    }
                    this.cursor += 6;
                    return (char)Integer.parseInt(buff.toString(), 16);
                }
                this.missedChar = Character.valueOf(c2);
            }
        }
        ++this.cursor;
        if (this.c == '\n') {
            ++this.lineNumber;
            this.columnNumber = 0;
        } else {
            ++this.columnNumber;
        }
        return this.c;
    }

    public char lastChar() {
        return this.c;
    }

    public String getValue() {
        return this.value;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean hasNext() throws IOException {
        return this.in.ready();
    }
}

